<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Radio,
    Submit,
    Hidden,
    Textarea
};
use Zend\Validator\{
    NotEmpty
};
use Zend\InputFilter\InputFilterProviderInterface;


class CmsPageForm extends Form implements InputFilterProviderInterface {

    public static $menuGroup = [];
    public static $pageOrder = [];
    public static $pageList =   [];

    public function __construct($name = null) {

        parent::__construct('page-add-form');

        /**
         *
         * Menu Group Id...
         */
        $this->add([
            'name' => 'menu_group_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'menu-group-id',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Menu Group<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$menuGroup,
                'disable_inarray_validator' => true,
                'empty_option' => 'Select',
            ],
        ]);

        /**
         *
         * Menu Group Id...
         */
        $this->add([
            'name' => 'page_name',
            'type' => Select::class,
            'attributes' => [
                'id' => 'page-name',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Pages<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$pageList,
                'disable_inarray_validator' => true,
                'empty_option' => 'Select',
            ],
        ]);

        /**
         *
         * Name of Page...
         */
        $this->add([
            'name' => 'menu_name',
             'type' => Text::class,
            'attributes' => [
                'id' => 'menu-name',
                'placeholder' => 'Menu Name',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Menu Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         *
         * Name of Page...
         */
        $this->add([
            'name' => 'page_type',
             'type' => Text::class,
            'attributes' => [
                'id' => 'page-type',
                'placeholder' => 'Page Type',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Page Type<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Name of Page...
         */
        $this->add([
            'name' => 'page_title',
             'type' => Text::class,
            'attributes' => [
                'id' => 'page-title',
                'placeholder' => 'Page Title',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Page Title<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Upload Image...
         */
        $this->add([
            'name' => 'page_image',
            'type' => File::class,
            'attributes' => [
                'id' => 'page-image',
                'class' => 'form-control'
            ],
            'options' => [
                 'label' => 'Page Image',
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);

        /**
         *
         * Name of Page...
         */
        $this->add([
            'name' => 'page_url',
             'type' => Text::class,
            'attributes' => [
                'id' => 'page-url',
                'placeholder' => 'Permalink',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Permalink<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Menu Group Id...
         */
        $this->add([
            'name' => 'page_order',
            'type' => Select::class,
            'attributes' => [
                'id' => 'page-order',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Page Order<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$pageOrder,
                'disable_inarray_validator' => true,
                'empty_option' => 'Select',
            ],
        ]);

        /**
         *
         * Menu Group Id...
         */
        $this->add([
            'name' => 'menu_order',
            'type' => Select::class,
            'attributes' => [
                'id' => 'menu-order',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Menu Order<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$pageOrder,
                'disable_inarray_validator' => true,
                'empty_option' => 'Select',
            ],
        ]);

        /**
         *
         * Content...
         */
        $this->add([
            'name' => 'page_desc',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'page-desc',
                'placeholder' => 'Content',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Content<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         *
         * Show after Login...
         */
        $this->add([
            'name' => 'show_after_login',
             'type' => Select::class,
            'attributes' => [
                'id' => 'show-after-login',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Show after Login<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true,
                'empty_option' => 'Select',
                'value_options' => [
                    'Yes' => 'Yes',
                    'No' => 'No'
                ],
            ],
        ]);

        /**
         *
         * Select Target...
         */
        $this->add([
            'name' => 'page_target',
             'type' => Select::class,
            'attributes' => [
                'id' => 'page-target',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Select Target<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true,
                'empty_option' => 'Select',
                'value_options' => [
                    'self' => 'self',
                    'parent' => 'parent'
                ],
            ],
        ]);


        /**
         *
         * Icon class...
         */
        $this->add([
            'name' => 'icon_class',
            'type' => Text::class,
            'attributes' => [
                'id' => 'icon-class',
                'placeholder' => 'Icon class',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Icon class<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Meta Title.....
         */
        $this->add([
            'name' => 'meta_title',
            'type' => Text::class,
            'attributes' => [
                'id' => 'meta-title',
                'placeholder' => 'Meta Title',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Meta Title<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Meta Title.....
         */
        $this->add([
            'name' => 'meta_keywords',
            'type' => Text::class,
            'attributes' => [
                'id' => 'meta-keywords',
                'placeholder' => 'Keywords',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Meta Keywords<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Meta Title.....
         */
        $this->add([
            'name' => 'meta_desc',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'meta-desc',
                'placeholder' => 'Meta Description',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Description<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Upload File...
         */
//        $this->add([
//            'name' => 'upload_file',
//            'type' => File::class,
//            'attributes' => [
//                'id' => 'upload-file',
//                'class' => 'form-control'
//            ],
//            'options' => [
//                'label' => 'Upload File<span style="color: red"> *</span>',
//                'label_options' => ['disable_html_escape' => true]
//            ],
//        ]);

        /**
         *
         * Thumb Upload File...
         */
//         $this->add([
//            'name' => 'thumb_upload_file',
//            'type' => File::class,
//            'attributes' => [
//                'id' => 'thumb-upload-file',
//                'class' => 'form-control'
//            ],
//            'options' => [
//                'label' => 'Thumb Upload File<span style="color: red"> *</span>',
//                'label_options' => ['disable_html_escape' => true]
//            ],
//        ]);

        /**
         *
         * Page Id
         */
        $this->add([
            'name' => 'id',
            'type' => Hidden::class,
        ]);

        /**
         *
         * Menu Id
         */
        $this->add([
            'name' => 'menu_id',
            'type' => Hidden::class,
        ]);



         /**
         *  Existing Page Selected
         */
        $this->add([
            'name' => 'existing_selected',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'existing-selected',
                'class' => 'inputMaterial'
            ]
        ]);

        /**
         * Airport Transfer Going Selected
         */
        $this->add([
            'name' => 'new_selected',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'new-selected',
                'class' => 'inputMaterial'
            ]
        ]);


        /**
         *
         * save
         */
        $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'page-add-save-btn',
                'placeholder' => 'Save',
                'class' => 'save_data_btn btn btn-primary btn-warning',
                'Value' => 'Save',
            ],
        ]);


    }

        public function getInputFilterSpecification() {
        return [
            'menu_group_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Menu Group'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'page_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Page Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'page_title' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Page Title'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'page_url' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Permalink'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'page_order' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Page Order'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'menu_order' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Menu Order'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'page_desc' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Page Description'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'show_after_login' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Status'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'page_target' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Target'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'icon_class' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Icon Class'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'meta_title' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Meta Title'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'meta_keywords' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Keywords'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'meta_desc' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Meta Description'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'menu_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Menu Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'page_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Page'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
        ];
    }

}
