<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    Text,
    Submit,
    Hidden,
    Textarea,
    File
};
use Zend\Validator\{
    NotEmpty
};
use Zend\InputFilter\InputFilterProviderInterface;

class CityInstructionForm extends Form implements InputFilterProviderInterface {

    public static $booking_type = [];
    public static $country = [];

    public function __construct($name = null) {

        parent::__construct('city-instruction-form');

        /**
         * 
         * Country ...
         */
           /**
         * 
         * Destination | Area City
         */
       $this->add([
            'name' => 'destination_city',
             'type' => Text::class,
              'attributes' => [
                'id' => 'destination-city',
                'class' => 'form-control'
            ],
           'options' => [
                'label' => 'Destination City<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
       
       $this->add([
            'name' => 'destination_city_id',
             'type' => Hidden::class,
              'attributes' => [
                'id' => 'destination-city-id',
                'class' => 'form-control'
            ],
        ]);
        

        /**
         * 
         * booking type ...
         */
        $this->add([
            'name' => 'booking_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking-type',
                'placeholder' => '',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Booking Type <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$booking_type,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Booking Type--',
            ],
        ]);

        /**
         * 
         * Inclusions Name...
         */
        $this->add([
            'name' => 'title',
            'type' => Text::class,
            'attributes' => [
                'id' => 'title',
                'placeholder' => 'title',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Title<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        $this->add([
            'name' => 'id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'id'
            ],
        ]);

        /**
         * 
         * Thumb Image...
         */
        $this->add([
            'name' => 'thumb_image',
            'type' => File::class,
            'attributes' => [
                'id' => 'thumb-image',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Thumb Image<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);



        /**
         * 
         * Description ...
         */
        $this->add([
            'name' => 'description',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'description',
                'placeholder' => 'Content',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Content<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * 
         * Save...
         */
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Save',
                'id' => 'submit-button',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'destination_city' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select City'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'title' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Title'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'description' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Give Description'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'booking_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Booking Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
        ];
    }

}
