<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Radio,
    Submit,
    Checkbox,
    Date
};

class BillingManagementSearchForm extends Form {

    public static $payment_status =[];
    public static $usertype =[];

    public function __construct($name = null) {

        parent::__construct('billing-management-search-form');
        $this->setAttribute('method', 'post');

        /**
         *
         * Booking ID
         */
        $this->add([
            'name' => 'booking_id',
            'type' => Text::class,
            'attributes' => [
                'id' => 'booking-id',
                'placeholder' => 'Booking Id',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Booking ID',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * From Date
         */
        $this->add([
            'name' => 'from_date',
            'type' => text::class,
            'attributes' => [
                'id' => 'from-date',
                'class' => 'form-control inputchange datepicker'
            ],
            'options' => [
                'label' => 'From Date',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * To Date
         */
        $this->add([
            'name' => 'to_date',
            'type' => text::class,
            'attributes' => [
                'id' => 'to-date',
                'class' => 'form-control inputchange datepicker'
            ],
            'options' => [
                'label' => 'To Date',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Payment Status
         */
        $this->add([
            'name' => 'user_type',
             'type' => Select::class,
            'attributes' => [
                'id' => 'user-type',
                'class' => 'input form-control'
            ],
            'options' => [
                'label' => 'Customer Type',
                'value_options' => self::$usertype,
                'empty_option' => 'Select',
            ]
        ]);


        /**
         * Payment Status
         */
        $this->add([
            'name' => 'user_name',
             'type' => Select::class,
            'attributes' => [
                'id' => 'user-name',
                'class' => 'input form-control'
            ],
            'options' => [
                'label' => 'Customer Name',
                'empty_option' => 'Select Customer',
            ]
        ]);

        /**
         * Payment Status
         */
        $this->add([
            'name' => 'payment_status',
             'type' => Select::class,
            'attributes' => [
                'id' => 'payment-status',
                'class' => 'input form-control'
            ],
            'options' => [
                'label' => 'Payment Status',
                'value_options' => self::$payment_status,
                'empty_option' => 'Select',
            ]
        ]);

        /**
         *
         * Invoice No
         */
        $this->add([
            'name' => 'invoice_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'invoice-no',
                'placeholder' => 'Invoice No',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Invoice No',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Search
         */
        $this->add([
            'name' => 'search',
                 'type' => Submit::class,
            'attributes' => [
                'value' => 'Search',
                'id' => 'search',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);

        /**
         * Clear
         */
        $this->add([
            'name' => 'clear',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Clear',
                'id' => 'clear',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);
    }

}
