<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;
use Zend\Form\Element\Select;
use Zend\Form\Element\File;
use Zend\Form\Element\Text;
use Zend\Form\Element\Radio;
use Zend\Form\Element\Submit;
use Zend\Form\Element\Textarea;
use Zend\Form\Element\Hidden;
use Zend\Validator\{
    NotEmpty,
    Digits,
    EmailAddress,
    StringLength
};
use Zend\InputFilter\InputFilterProviderInterface;

class AdUserLicenseForm extends Form implements InputFilterProviderInterface {

    public static $membershipackage = [];
    public static $master_package = [];

    public function __construct($name = null) {

        parent::__construct('');
        $this->setAttribute('method', 'post');

        /**
         * Owner Name
         */
        $this->add([
            'name' => 'owner_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'owner-name',
                'class' => 'form-control',
                'readonly'=>true,
            ],
            'options' => [
                'label' => 'Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Owner Email
         */
        $this->add([
            'name' => 'owner_email',
            'type' => Text::class,
            'attributes' => [
                'id' => 'owner-email',
                'class' => 'form-control',
                'readonly'=>true,
            ],
            'options' => [
                'label' => 'Email<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Owner Mobile
         */
        $this->add([
            'name' => 'owner_mobile',
            'type' => Text::class,
            'attributes' => [
                'id' => 'owner-mobile',
                'class' => 'form-control',
                'maxlength' => 10,
                'onkeypress' => "return isNumber(event)",
                'readonly'=>true,
            ],
            'options' => [
                'label' => 'Mobile<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Owner Mobile
         */
        $this->add([
            'name' => 'owner_address',
            'type' => Text::class,
            'attributes' => [
                'id' => 'owner-address',
                'class' => 'form-control',
                'readonly'=>true,
            ],
            'options' => [
                'label' => 'Address<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         * License Start validity
         */
        $this->add([
            'name' => 'license_start_date',
            'type' => Text::class,
            'attributes' => [
                'id' => 'license-start-date',
                'class' => 'form-control datecalender',
                'readonly'=>true,
            ],
            'options' => [
                'label' => 'License Start Date<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        /**
         * License Start validity
         */
        $this->add([
            'name' => 'license_end_date',
            'type' => Text::class,
            'attributes' => [
                'id' => 'license-end-date',
                'class' => 'form-control datecalender',
                'readonly'=>true,
            ],
            'options' => [
                'label' => 'License End Date<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * License Validity
         */
        $this->add([
            'name' => 'license_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'license-no',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'License No<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * License Validity
         */
        $this->add([
            'name' => 'no_of_domain',
            'type' => Select::class,
            'attributes' => [
                'id' => 'no-of-domain',
                'class' => 'selectpicker form-control country-select',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'No of domain<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => [1 => 1, 2 => 2, 3 => 3, 4 => 4, 5 => 5],
                'disable_inarray_validator' => true,
                'empty_option' => '--Select--',
            ],
        ]);


        /**
         * Domain Name
         */
        $this->add([
            'name' => 'domain_name[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'domain-name',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Domain Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         * Domain Start Date
         */
        $this->add([
            'name' => 'license_option',
            'type' => Select::class,
            'attributes' => [
                'id' => 'license-option',
                'class' => 'selectpicker form-control country-select',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'License Option<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => ['1' => 'Lifetime', '2' => 'Yearly', '3' => 'Half Year', '4' => 'Monthly'],
                'disable_inarray_validator' => true,
                'empty_option' => '--Select--',
            ],
        ]);

        /**
         * Domain End Date
         */
        $this->add([
            'name' => 'package',
            'type' => Select::class,
            'attributes' => [
                'id' => 'user-package',
                'class' => 'selectpicker form-control country-select',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Package<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select--',
                'disable_inarray_validator' => true,
                'value_options' => self::$membershipackage
            ],
        ]);

        /**
         * Package
         */
        $this->add([
            'name' => 'module',
            'type' => Select::class,
            'attributes' => [
                'id' => 'user-package',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Select Module<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$master_package,
                'disable_inarray_validator' => true,
                'empty_option' => '',
            ],
        ]);
        
        /**
         *
         * vehicle type_name
         */
        $this->add([
            'name' => 'user_license_id',
            'type' => Hidden::class,
        ]);
        
        /**
         * Save...
         */
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Save',
                'id' => 'add-user-license',
                'class' => 'save_data_btn btn btn-primary btn-new-vehile btn-warning'
            ]
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'owner_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'owner_email' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'EmailAddress',
                        'options' => [
                            'messages' => [
                                EmailAddress::INVALID => 'Please Enter Valid Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'owner_mobile' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Mobile No.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'Digits',
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please Enter Numeric value only',
                            ],
                        ],
                        'break_chain_on_failure' => true,
                    ],
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 8,
                            'max' => 10,
                            'messages' => [
                                StringLength::TOO_LONG => 'Please enter Less than 10 Digits',
                                StringLength::TOO_SHORT => 'Please enter greater than 8 Digits',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],
            'owner_address' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Address'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'license_option' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select License Option'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'package' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Package'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'no_of_domain' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select No of Domain'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'module' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Module'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
        ];
    }

}
