<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Text,
    Submit
};
use Zend\Validator\{
    NotEmpty
};
use Zend\InputFilter\InputFilterProviderInterface;

class AccountDetailsForm extends Form implements InputFilterProviderInterface {

    public function __construct($name = null) {
        parent::__construct('account-details');
        $this->setAttribute('method', 'post');

        /**
         *
         * Address
         */
        $this->add([
            'name' => 'driver_min_balance',
            'type' => Text::class,
            'attributes' => [
                'id' => 'driver-min-balance',
                'placeholder' => '',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Minimum Balance: <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Bank Name
         */
        $this->add([
            'name' => 'bank_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'bank-name',
                'placeholder' => '',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Bank Name : <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Account Holder Name
         */
        $this->add([
            'name' => 'ac_holder_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'ac-holder-name',
                'placeholder' => '',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Account Holder Name: <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Branch
         */
        $this->add([
            'name' => 'branch',
            'type' => Text::class,
            'attributes' => [
                'id' => 'branch',
                'placeholder' => '',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Branch : <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * IFSC Code
         */
        $this->add([
            'name' => 'ifsc_code',
            'type' => Text::class,
            'attributes' => [
                'id' => 'ifsc-code',
                'placeholder' => '',
                'class' => 'form-control margin-top0',
            ],
            'options' => [
                'label' => 'IFSC Code : <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * ACCOUNT No
         */
        $this->add([
            'name' => 'account_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'account-no',
                'placeholder' => '',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Account No : <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * button System Backup
         */
        $this->add([
            'name' => 'system_backup',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'system-backup-id',
                'placeholder' => 'System Backup',
                'class' => 'btn btn-info',
            ],
        ]);

        /**
         *
         * button Restore
         */
        $this->add([
            'name' => 'restore',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'restore-id',
                'placeholder' => 'Restore',
                'class' => 'btn btn-danger',
            ],
        ]);


        /**
         *
         * button reset
         */
        $this->add([
            'name' => 'reset',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'reset-id',
                'placeholder' => 'reset',
                'class' => 'btn btn-success',
            ],
        ]);

        /**
         *
         * save
         */
        $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'contact-us-save-btn',
                'placeholder' => 'Save',
                'class' => 'save_data_btn btn btn-primary btn-warning pull-right margin-L-1',
                'Value' => 'Save',
                'onclick' => "submitForm('#account-details', event);"
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'driver_min_balance' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Minimum Balance.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'bank_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Bank Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'ac_holder_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Account Holder Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'branch' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Branch Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'ifsc_code' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter IFSC Code'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'account_no' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Account No'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ]
        ];
    }
}