<?php

namespace Dashboard\Controller;

use Zend\Mvc\Controller\AbstractActionController;
use Application\Controller\RestAPIClientController;
use Dashboard\Form\RefundPolicyForm;
use Zend\View\Model\{
    ViewModel,
    JsonModel
};
use Zend\Json\Json;
use Zend\Session\Container;
use Zend\Debug\Debug;
use Dashboard\Model\CommonModel;
use Dashboard\Model\User;

class RefundPolicyController extends RestAPIClientController {

    public function __construct() {
        $this->CommonModel = new CommonModel();
        $this->userModel = new User();
    }

    /**
     * Index
     * @return ViewModel
     */
    public function indexAction() {
        $form = new RefundPolicyForm();
        $data = [];
        $pStrtuctureList = $this->CommonModel->getRefundPolicyDetails($data);
        $viewModel = new ViewModel(['pStrtuctureList' => $pStrtuctureList]);
        return $viewModel;
    }

    public function addRefundPolicyAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        RefundPolicyForm::$country = $this->userModel->getCountryList();
        RefundPolicyForm::$booking_type = $this->CommonModel->getTourTypeList();
        $form = new RefundPolicyForm();
        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();
                $data = [
                    'country_id' => $post['country_id'],
                    'booking_type' => $post['booking_type'],
                    'title' => $post['title'],
                    'description' => $post['description'],
                    'status' => 1,
                    'created_by' => $user_id,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];
                $insertStatus = $this->CommonModel->addRefundPolicyDetails($data);
                if ($insertStatus['responsedata']['status'] == "success") {
                    $this->flashMessenger()->addMessage(array('success' => 'Details added successfully...'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'Somet thing Went Wrong'));
                }
                $this->redirect()->toRoute('refund-policy', ['action' => 'index']);
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    public function editRefundPolicyAction() {
        $sessionUser = new Container('userlogin');
        $user_id = $sessionUser->userData['user_id'];

        RefundPolicyForm::$country = $this->userModel->getCountryList();
        RefundPolicyForm::$booking_type = $this->CommonModel->getTourTypeList();
        $form = new RefundPolicyForm();
        $id = $this->params()->fromQuery('id');
        $data = [
            'auto_id' => $id
        ];
        $vehicleData = $this->CommonModel->getRefundPolicyDetails($data);
        $vehicleData = $vehicleData[0];
        $form->setData($vehicleData);
        $form->get('id')->setValue($vehicleData['id']);
        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();
                $data = [
                    'country_id' => $post['country_id'],
                    'booking_type' => $post['booking_type'],
                    'title' => $post['title'],
                    'description' => $post['description'],
                    'modified_by' => $user_id,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'auto_id' => $post['id']
                ];
                $updateStatus = $this->CommonModel->updateRefundPolicyDetails($data);
                if($updateStatus['responsedata']['status'] == "success") {
                    $this->flashMessenger()->addMessage(array('success' => 'Details Updated successfully...'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'Somet thing Went Wrong'));
                }
                $this->redirect()->toRoute('refund-policy', ['action' => 'index']);
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }
    
      /** Function to change PAYMENT STRUCTURE STATUS */
    public function refundPolicyStatusAction() {
        $data1 = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $data = $this->getRequest()->getPost();
        $id = implode(',', $data['selected']);
        $status = $data['status'];
        $data = ['user_id' => $user_id, 'id' => $id, 'status' => $status];
        $this->CommonModel->updateRefundPolicyStatus($data);
        $val = [];
        $pStrtuctureList = $this->CommonModel->getRefundPolicyDetails($val);
        $viewModel = new ViewModel(['pStrtuctureList' => $pStrtuctureList]);
        $viewModel->setTemplate('/dashboard/refund-policy/refund-policy-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function changeRecordStatusAction() {
        $status=0;
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if($postData['status']==0 || $postData['status']==2){
                $status=1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->CommonModel->updateRefundPolicyStatus($data);
        }
        $val = [];
        $pStrtuctureList = $this->CommonModel->getRefundPolicyDetails($val);
        $viewModel = new ViewModel(['pStrtuctureList' => $pStrtuctureList]);
        $viewModel->setTemplate('/dashboard/refund-policy/refund-policy-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function deleteRefundPolicyAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id'=>$userId, 'status'=>2];
        $this->CommonModel->updateRefundPolicyStatus($data);
        $this->redirect()->toRoute('refund-policy', ['action' => 'index']);
        $this->flashMessenger()->addMessage(array('success' => 'Details Delete Successfully'));
    }

}
