<?php

namespace Dashboard\Controller;

use Zend\Mvc\Controller\AbstractActionController;
use Zend\View\Model\ViewModel;
use Dashboard\Form\{PaymentSearchForm, AddPaymentGatewayForm};


class PaymentController extends AbstractActionController {
    
       
    /**
     * Payment Listing...
     * @return ViewModel
     */
    public function indexAction(){
        
        $paymentListing = [
            '0'=>[
                'id'=>'1',
                'gateway_image'=>''
            ],
            '1'=>[
                'id'=>'2',
                'gateway_image'=>''
            ]            
        ];        
        
        $form = new PaymentSearchForm();
        
        $viewModel = new ViewModel(['form'=>'$form', 'paymentListing'=>$paymentListing]);
        return $viewModel;
    }
    
    /**
     * Add New Payment Gateway...
     * @return ViewModel
     */
    public function addNewPaymentGatewayAction(){
        $form = new AddPaymentGatewayForm();
        
        
        
        $viewModel = new ViewModel(['form'=>'$form']);
        return $viewModel;
    }    
    
    /**
     * 
     * Publish...
     */
    public function publishPaymentGatewayAction(){
        
        $data = $this->getRequest()->getPost();
        $response = $this->getResponse();
        $response->getHeaders()->addHeaderLine('Content-Type', 'application/json');
        $msg = ['resp'=>0, 'error'=> '', 'status'=>'fail', 'message'=>'error occurred Try Again'];
        
        $res = 1;//call api
        
        if($res){           
            $msg = ['resp'=>1, 'error'=> '', 'status'=>'success', 'message'=>'Selected Data Published'];
        }
        
        $response->setContent(json_encode($msg));
        return $response;        
    }
    
    /**
     * 
     * Unpublish...
     */
    public function unpublishPaymentGatewayAction(){
        
        $data = $this->getRequest()->getPost();
        $response = $this->getResponse();
        $response->getHeaders()->addHeaderLine('Content-Type', 'application/json');
        $msg = ['resp'=>0, 'error'=> '', 'status'=>'fail', 'message'=>'error occurred Try Again'];
        
        $res = 1;//call api
        
        if($res){           
            $msg = ['resp'=>1, 'error'=> '', 'status'=>'success', 'message'=>'Selected Data Unpublished'];
        }
        
        $response->setContent(json_encode($msg));
        return $response;        
    }
    
    /**
     * 
     * Delete All Payment Gateway...
     */
    public function deleteAllPaymentGatewayAction(){  
        
        $data = $this->getRequest()->getPost();
        $response = $this->getResponse();
        $response->getHeaders()->addHeaderLine('Content-Type', 'application/json');
        $msg = ['resp'=>0, 'error'=> '', 'status'=>'fail', 'message'=>'error occurred Try Again'];
        
        $res = 1;//call api
        
        if($res){           
            $msg = ['resp'=>1, 'error'=> '', 'status'=>'success', 'message'=>'Selected Data Deleted'];
        }
        
        $response->setContent(json_encode($msg));
        return $response;        
    }
    
}
