<?php

namespace Dashboard\Controller;

use Zend\Mvc\Controller\AbstractActionController;
use Application\Controller\RestAPIClientController;
use Zend\View\Model\{
    ViewModel,
    JsonModel
};
use Zend\Json\Json;
use Zend\Session\Container;
use Dashboard\Form\{
    JobForm
};
use Zend\Debug\Debug;
use Dashboard\Model\CommonModel;

class JobController extends RestAPIClientController {

    public function __construct() {
        $this->commonModel = new CommonModel();
    }

    /**
     * Index
     * @return ViewModel
     */
    public function indexAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        JobForm::$department = $this->commonModel->getDepartmentByuserId($user_id);
        $form = new JobForm ();
        $data = [];
        $jobDetails = $this->commonModel->getJobDetails($data);
       
        $viewModel = new ViewModel(['form' => $form, 'jobdetails' => $jobDetails['data']]);

        return $viewModel;
    }

    public function addJobAction() {

        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        JobForm::$department = $this->commonModel->getDepartmentByuserId($user_id);

        $finalData = [];

        $form = new JobForm ();
        $request = $this->getRequest();

        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            $form->setData($postData);
            if ($form->isValid()) {

                $finalData = [
                    'dep_id' => $postData['department_name'],
                    'position_name' => $postData['position_name'],
                    'experience' => $postData['experience'],
                    'location' => $postData['location'],
                    'description' => $postData['description'],
                    'job_description' => $postData['job_description'],
                    'skills' => $postData['skills'],
                    'created_by' => $user_id,
                    'created_date' => date('Y-m-d'),
                    'status' => $postData['status'],
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];

                $JsonData = $this->commonModel->addNewJob($finalData);
   
                if ($JsonData['status']=='success') {
                    $msg = "Details Added Successfully!..";

                    $this->redirect()->toRoute('job', ['action' => 'index']);
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Details Could Not Added!..";
                    $color = "red";
                    $this->redirect()->toRoute('job', ['action' => 'add-job']);
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
            }
        }
        $viewModel = new ViewModel(['form' => $form]);

        return $viewModel;
    }

    public function editJobAction() {
        $status = 1;
        $finalData = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $id = $this->params()->fromQuery('id');

        JobForm::$department = $this->commonModel->getDepartmentByuserId($user_id);
        $form = new JobForm ();

        if (!empty($id)) {
            $getDetails = $this->commonModel->getUserJobDetails($id);
            $status = $getDetails['status'];
            $form->setData($getDetails);
            $form->get('department_name')->setValue($getDetails['dep_id']);
        }

        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            $form->setData($postData);
            if ($form->isValid()) {

                $finalData = [
                    'id' => $postData['id'],
                    'dep_id' => $postData['department_name'],
                    'position_name' => $postData['position_name'],
                    'experience' => $postData['experience'],
                    'location' => $postData['location'],
                    'description' => $postData['description'],
                    'job_description' => $postData['job_description'],
                    'skills' => $postData['skills'],
                    'modified_by' => $user_id,
                    'modified_date' => date('Y-m-d'),
                    'status' => $postData['status'],
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];

                $JsonData = $this->commonModel->updateJobs($finalData);
           
                if ((!empty($JsonData['count'] == 1)) && !isset($JsonData['error'])) {
                    $msg = "Details Updated Successfully!..";

                    $this->redirect()->toRoute('job', ['action' => 'index']);
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Details Could Not Updated!..";
                    $color = "red";
                    $this->redirect()->toRoute('job', ['action' => 'edit-job']);
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
            }
        }

        $viewModel = new ViewModel(['form' => $form, 'status' => $status]);
        return $viewModel;
    }

    public function deleteAction() {
        $JsonData = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $id = $this->params()->fromQuery('id');
        if (!empty($id)) {
            $JsonData = [
                'id' => $id,
                'modified_by' => $user_id,
                'status' => 2,
                'ip' => $_SERVER['REMOTE_ADDR']
            ];
        }
        $JsonData = $this->commonModel->updateJobs($JsonData);
  
        if ($JsonData['count'] == 1) {
            $msg = "Record Deleted Successfully..!";

            $this->redirect()->toRoute('job', ['action' => 'index']);
            $this->flashMessenger()->addMessage(array('success' => $msg));
        } else {
            $msg = "Record Could Not Deleted..!";
            $this->redirect()->toRoute('job', ['action' => 'index']);
            $this->flashMessenger()->addMessage(array('danger' => $msg));
        }
    }

    public function StatusAction() {
        $form = new JobForm ();
        $data = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $postData = $this->getRequest()->getPost();
        $id = implode(',', $postData['selected']);
        $status = $postData['status'];
        $data = ['id' => $id, 'user_id' => $user_id, 'job_status' => $status,];
        $JsonData = $this->commonModel->multiupdateJobs($data);
        $jobDetails = $this->commonModel->getJobDetails($data);
        $viewModel = new ViewModel(['form' => $form, 'jobdetails' => $jobDetails['data']]);
        $viewModel->setTemplate('dashboard/job/job-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    public function searchJobAction() {
        $data = [];
        $postData = $this->getRequest()->getPost()->toArray();
        $department_id = isset($postData['department_name']) ? $postData['department_name'] : '';
        $position_name = isset($postData['position_name']) ? $postData['position_name'] : '';
        $location = isset($postData['location']) ? $postData['location'] : '';

        if ($department_id != '') {
            $data['dep_id'] = $department_id;
        }
        if ($position_name != '') {
            $data['position_name'] = $position_name;
        }
        if ($location != '') {
            $data['location'] = $location;
        }
        $data['status'] = $postData['status'];
      
        $jobfilter = $this->commonModel->filterJobs($data);
      
        $viewModel = new ViewModel(['jobdetails' => $jobfilter['responsedata']]);
        $viewModel->setTemplate('dashboard/job/job-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

}
