<?php

namespace Dashboard\Controller;

use Zend\Mvc\Controller\AbstractActionController;
use Application\Controller\RestAPIClientController;
use Dashboard\Form\HotelAddForm;
use Dashboard\Form\HotelContactForm;
use Dashboard\Form\HotelAllocationForm;
use Dashboard\Form\HotelPaymentFeatureForm;
use Dashboard\Form\HotelRoomForm;
use Dashboard\Form\HotelRoomRateForm;
use Dashboard\Form\HotelMetaTagForm;
use Dashboard\Form\HotelTermsPolicyForm;
use Dashboard\Form\HotelImageForm;
use Dashboard\Form\HotelForm;
use Dashboard\Form\HotelCancellationFeesForm;
use Zend\View\Model\{
    ViewModel,
    JsonModel
};
use Zend\Json\Json;
use Zend\Session\Container;
use Dashboard\Model\CommonModel;
use Dashboard\Model\User;

class HotelController extends RestAPIClientController {

    public function __construct() {
        $this->CommonModel = new CommonModel();
        $this->userModel = new User();
    }

    private $hotelFacility = 1;
    private $hotelSportsRecreation = 2;
    private $hotelExtraInfo = 3;

    /**
     * Index
     * @return ViewModel
     */
    public function indexAction() {
        $sessionHotelContainer = new Container('addHotelData');
        unset($sessionHotelContainer->hotel_id);
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        $packageListing = $this->CommonModel->getHotelDetailsList($data);
        //echo '<pre>';print_r($packageListing);die();
        $viewModel = new ViewModel(['packageListing' => $packageListing]);
        return $viewModel;
    }

    public function mapDistanceAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        $packageListing = $this->CommonModel->getHotelDetailsList($data);
        //echo '<pre>';print_r($packageListing);die();
        $viewModel = new ViewModel(['packageListing' => $packageListing]);
        return $viewModel;
    }

    public function addHotelAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        HotelAddForm::$property_type = $this->CommonModel->getPropertyTypeList();
        HotelAddForm::$hotel_category = $this->CommonModel->getHotelCategoryList();
        $form = new HotelAddForm();
        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            //echo '<pre>';print_r($postData);
            $form->setData($postData);
            if ($form->isValid()) {
                $finalData = [];
                $finalData = [
                    'company_id' => $this->config()->getConfig()->company->companyId,
                    'code' => $this->generateHotelCode($postData['destination_city_id']),
                    'name' => $postData['name'],
                    'property_type' => $postData['property_type'],
                    'hotel_category' => $postData['hotel_category'],
                    'url' => $postData['url'],
                    'city_id' => $postData['destination_city_id'],
                    'location' => $postData['location'],
                    'featured' => $postData['featured'],
                    'preferred' => $postData['preferred'],
                    'total_floor' => $postData['total_floor'],
                    'total_rooms_single' => $postData['total_rooms_single'],
                    'total_rooms_double' => $postData['total_rooms_double'],
                    'total_rooms_twin' => $postData['total_rooms_twin'],
                    'total_rooms_disabled' => $postData['total_rooms_disabled'],
                    'interconnected_total_rooms' => $postData['interconnected_total_rooms'],
                    'check_in_time' => $postData['check_in_time'],
                    'check_out_time' => $postData['check_out_time'],
                    'total_conference_halls' => $postData['total_conference_halls'],
                    'total_board_rooms' => $postData['total_board_rooms'],
                    'total_party_lawns' => $postData['total_party_lawns'],
                    'description' => $postData['description'],
                    
                    'telephone' => $postData['telephone'],
                    'fax' => $postData['fax'],
                    'email' => $postData['email'],
                    'building_name' => $postData['building_name'],
                    'building_number' => $postData['building_number'],
                    'postal_code' => $postData['postal_code'],
                    'address' => $postData['address'],
                    'latitude' => $postData['latitude'],
                    'longitude' => $postData['longitude'],
                    
                    'created_date' => date('Y-m-d H:i:s'),
                    'user_id' => $userId,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];
                //$get=array_filter($finalData);
                // $p=json_encode($get);
                //echo'<pre>';print_r($finalData);die();

                $responseData = $this->CommonModel->insertHotelDetails($finalData);
                //echo '<pre>';print_r($responseData);die();           
                if ($responseData['response']['status'] == 'success') {
                    $msg = "Details Added Successfully!..";
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Details Could Not Added!..";
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
                $this->redirect()->toRoute('hotel', ['action' => 'index']);
            } else {
                $msg = $form->getMessages();
                echo '<pre>';
                print_r($msg);
                die();
            }
        }
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        $packageListing = $this->CommonModel->getHotelDetailsList($data);
        $viewModel = new ViewModel(['form' => $form, 'tab' => 'add-hotel', 'packageListing' => $packageListing,'google_map_url' => $this->config()->getConfig()->google_map->url,  'google_map_key' => $this->config()->getConfig()->google_map->key]);
        return $viewModel;
    }

    public function editHotelAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        HotelAddForm::$property_type = $this->CommonModel->getPropertyTypeList();
        HotelAddForm::$hotel_category = $this->CommonModel->getHotelCategoryList();
        $form = new HotelAddForm();
        $id = $this->params()->fromQuery('id');
        $data = [
            'auto_id' => $id
        ];
        $vehicleData = $this->CommonModel->getHotelDetailsList($data);
        $vehicleData = $vehicleData[0];
        $form->setData($vehicleData);
        $form->get('id')->setValue($vehicleData['id']);
        $form->get('destination_city_id')->setValue($vehicleData['city_id']);
        $form->get('hotel_city')->setValue($vehicleData['city_name']);

        $sessionHotelContainer = new Container('addHotelData');
        unset($sessionHotelContainer->hotel_id);
        $sessionHotelContainer->hotel_id = $id;

        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            //echo '<pre>';print_r($postData);die();
            $form->setData($postData);
            if ($form->isValid()) {
                $finalData = [];
                $finalData = [
                    'company_id' => $this->config()->getConfig()->company->companyId,
                    'name' => $postData['name'],
                    'code' => $this->generateHotelCode($postData['destination_city_id']) . '-' . $postData['id'],
                    'property_type' => $postData['property_type'],
                    'hotel_category' => $postData['hotel_category'],
                    'url' => $postData['url'],
                    'city_id' => $postData['destination_city_id'],
                    'location' => $postData['location'],
                    'featured' => $postData['featured'],
                    'preferred' => $postData['preferred'],
                    'total_floor' => $postData['total_floor'],
                    'total_rooms_single' => $postData['total_rooms_single'],
                    'total_rooms_double' => $postData['total_rooms_double'],
                    'total_rooms_twin' => $postData['total_rooms_twin'],
                    'total_rooms_disabled' => $postData['total_rooms_disabled'],
                    'interconnected_total_rooms' => $postData['interconnected_total_rooms'],
                    'check_in_time' => $postData['check_in_time'],
                    'check_out_time' => $postData['check_out_time'],
                    'total_conference_halls' => $postData['total_conference_halls'],
                    'total_board_rooms' => $postData['total_board_rooms'],
                    'total_party_lawns' => $postData['total_party_lawns'],
                    'description' => $postData['description'],
                    
                    'telephone' => $postData['telephone'],
                    'fax' => $postData['fax'],
                    'email' => $postData['email'],
                    'building_name' => $postData['building_name'],
                    'building_number' => $postData['building_number'],
                    'postal_code' => $postData['postal_code'],
                    'address' => $postData['address'],
                    'latitude' => $postData['latitude'],
                    'longitude' => $postData['longitude'],
                    
                    'modified_by' => $userId,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'auto_id' => $postData['id']
                ];
                //$get=array_filter($finalData);
                // $p=json_encode($get);
                //echo'<pre>';print_r($finalData);die();
                $responseData = $this->CommonModel->updateHotelDetails($finalData);
                //echo '<pre>';print_r($responseData);die();           
                if ($responseData['response']['status'] == 'success') {
                    $msg = "Details Added Successfully!..";
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Details Could Not Added!..";
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
                //$this->redirect()->toRoute('hotel', ['action' => 'add-hotel']);
                //$this->redirect()->toRoute('hotel', ['action' => 'edit-payment-feature-hotel', 'id' => $id]);
                return $this->redirect()->toUrl('edit-payment-feature-hotel?id=' . $postData['id']);
            }
//            else {
//                $msg = $form->getMessages();
//                echo '<pre>';
//                print_r($msg);
//                die();
//            }
        }

        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        $packageListing = $this->CommonModel->getHotelDetailsList($data);
        $viewModel = new ViewModel(['form' => $form, 'tab' => 'add-hotel', 'packageListing' => $packageListing, 'google_map_url' => $this->config()->getConfig()->google_map->url,  'google_map_key' => $this->config()->getConfig()->google_map->key]);
        return $viewModel;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 8-JANUARY-2022
     * @description : FUNCTION TO CHANGE HOTEL DETAILS STATUS
     */
    
    public function hotelDetailStatusAction() {
        $data1 = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $data = $this->getRequest()->getPost();
        $id = implode(',', $data['selected']);
        $status = $data['status'];
        $data = ['user_id' => $user_id, 'id' => $id, 'status' => $status];
        $this->CommonModel->updateHotelStatus($data);
        $val = ['company_id' => $this->config()->getConfig()->company->companyId];
        $packageListing = $this->CommonModel->getHotelDetailsList($val);
        $viewModel = new ViewModel(['packageListing' => $packageListing]);
        $viewModel->setTemplate('/dashboard/hotel/hotel-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 10-JANUARY-2022
     * @description : FUNCTION TO CHANGE HOTELS RECORD STATUS
     */

    public function changeRecordStatusAction() {
        $status = 0;
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status'] == 0 || $postData['status'] == 2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->CommonModel->updateHotelStatus($data);
        }
        $val = ['company_id' => $this->config()->getConfig()->company->companyId];
        $packageListing = $this->CommonModel->getHotelDetailsList($val);
        $viewModel = new ViewModel(['packageListing' => $packageListing]);
        $viewModel->setTemplate('/dashboard/hotel/hotel-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 10-JANUARY-2022
     * @description : FUNCTION TO DELETE HOTELS LIST
     */

    public function deleteHotelDetailsAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id' => $userId, 'status' => 2];
        $this->CommonModel->updateHotelStatus($data);
        $this->redirect()->toRoute('hotel', ['action' => 'index']);
        $this->flashMessenger()->addMessage(array('success' => 'Details Delete Successfully'));
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 10-JANUARY-2022
     * @description : FUNCTION TO ADD HOTEL CONTACT DETAILS
     */

    public function contactHotelAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        HotelContactForm::$hotel_list = $this->CommonModel->getHotelList($data);
        $form = new HotelContactForm();

        $id = $this->params()->fromQuery('id');
        if (!empty($id)) {
            $data = [
                'auto_id' => $id
            ];
            $vehicleData = $this->CommonModel->getHotelDetailsList($data);
            $vehicleData = $vehicleData[0];
            $form->setData($vehicleData);
            $form->getInputFilter()->get('hotel_id')->setRequired(false);
            $form->get('id')->setValue($vehicleData['id']);
            $form->get('hotel_id')->setValue($vehicleData['id']);
            $form->get('hotel_id')->setAttribute("disabled", [$vehicleData['id']]);
        }

        $request = $this->getRequest();

        //if request will be post                
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            //echo '<pre>';print_r($postData);die();
            $form->setData($postData);
            //if ($form->isValid()) {
                $finalData = [];
                $finalData = [
    'sales_person_name' => $postData['sales_person_name'],
    'sales_person_landline_no' => $postData['sales_person_landline_no'],
    'sales_person_mobile_no' => $postData['sales_person_mobile_no'],
    'sales_person_email' => $postData['sales_person_email'],
    'reservation_person_name' => $postData['reservation_person_name'],
    'reservation_person_landline_no' => $postData['reservation_person_landline_no'],
    'reservation_person_mobile_no' => $postData['reservation_person_mobile_no'],
    'reservation_person_email' => $postData['reservation_person_email'],
    'address' => $postData['address'],
    'user_id' => $userId,
    'ip' => $_SERVER['REMOTE_ADDR'],
    'auto_id' => $postData['id']
                ];
                //echo '<pre>';print_r($finalData);die();    
                $responseData = $this->CommonModel->updateHotelContactDetails($finalData);
                if ($responseData['responsedata']['status'] == 'success') {
                    $msg = "Details Updated Successfully!..";
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Details Could Not Upated!..";
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
                $this->redirect()->toRoute('hotel', ['action' => 'index']);
                //$this->redirect()->toRoute('hotel', ['action' => 'contact-hotel']);
               //return $this->redirect()->toUrl('edit-room-hotel?id=' . $postData['id']);
            }
        //}
        $viewModel = new ViewModel([
            'form' => $form, 
            'tab' => 'contact-hotel',
            ]);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 10-JANUARY-2022
     * @description : FUNCTION TO ADD HOTEL PAYMENT FETAURE DETAILS
     */

    public function paymentFeatureHotelAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        HotelPaymentFeatureForm::$hotel_list = $this->CommonModel->getHotelList($data);
        HotelPaymentFeatureForm::$currenyList = $this->CommonModel->getCurrencyList();
        HotelPaymentFeatureForm::$paymentOptionList = $this->CommonModel->getPaymentTypeList();
        $data = ['type_id' => $this->hotelFacility];
        HotelPaymentFeatureForm::$facilityList = $this->CommonModel->getHotelFeaturesList($data);
        $data = ['type_id' => $this->hotelSportsRecreation];
        HotelPaymentFeatureForm::$sportsRecreationList = $this->CommonModel->getHotelFeaturesList($data);
        $data = ['type_id' => $this->hotelExtraInfo];
        HotelPaymentFeatureForm::$extraHotelInfoList = $this->CommonModel->getHotelFeaturesList($data);
        $form = new HotelPaymentFeatureForm();
        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            //echo '<pre>';print_r($postData);die();
            $form->setData($postData);
            if ($form->isValid()) {
                //echo '<pre>';print_r($postData);die();
                $finalData = [];
                $finalData = [
                    'facility_name_id' => implode(",", $postData['facility_name_id']),
                    'sports_recreation_id' => implode(",", $postData['sports_recreation_id']),
                    'extra_info_id' => implode(",", $postData['extra_info_id']),
                    'payment_option_id' => implode(",", $postData['payment_option_id']),
                    'currency' => $postData['currency'],
                    'payment_description' => $postData['payment_description'],
                    'created_date' => date('Y-m-d'),
                    'user_id' => $userId,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'hotel_id' => $postData['hotel_id']
                ];
                $responseData = $this->CommonModel->updateHotelPaymentFeatureDetails($finalData);
                if ($responseData['response']['status'] == 'success') {
                    $msg = "Details Updated Successfully!..";
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Details Could Not Upated!..";
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
                $this->redirect()->toRoute('hotel', ['action' => 'index']);
            }
        }
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        $packageListing = $this->CommonModel->getHotelDetailsList($data);
        $viewModel = new ViewModel([
            'form' => $form,
            'tab' => 'payment-feature-hotel',
            'packageListing' => $packageListing
        ]);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 10-JANUARY-2022
     * @description : FUNCTION TO EDIT HOTEL PAYMENT FETAURE DETAILS
     */

    public function EditpaymentFeatureHotelAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        HotelPaymentFeatureForm::$hotel_list = $this->CommonModel->getHotelList($data);
        HotelPaymentFeatureForm::$currenyList = $this->CommonModel->getCurrencyList();
        HotelPaymentFeatureForm::$paymentOptionList = $this->CommonModel->getPaymentTypeList();
        $data = ['type_id' => $this->hotelFacility];
        HotelPaymentFeatureForm::$facilityList = $this->CommonModel->getHotelFeaturesList($data);
        $data = ['type_id' => $this->hotelSportsRecreation];
        HotelPaymentFeatureForm::$sportsRecreationList = $this->CommonModel->getHotelFeaturesList($data);
        $data = ['type_id' => $this->hotelExtraInfo];
        HotelPaymentFeatureForm::$extraHotelInfoList = $this->CommonModel->getHotelFeaturesList($data);
        $form = new HotelPaymentFeatureForm();

        $id = $this->params()->fromQuery('id');
        $data = [
            'auto_id' => $id
        ];
        $vehicleData = $this->CommonModel->getHotelDetailsList($data);
        $vehicleData = $vehicleData[0];
        $form->setData($vehicleData);
        $form->get('id')->setValue($vehicleData['id']);
        $form->get('hotel_id')->setValue($vehicleData['id']);
        $form->get('hotel_id')->setAttribute("disabled", [$vehicleData['id']]);
        $form->getInputFilter()->get('hotel_id')->setRequired(false);
        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            //echo '<pre>';print_r($postData);die();
            $form->setData($postData);
            if ($form->isValid()) {
                //echo '<pre>';print_r($postData);die();
                $finalData = [];
                $finalData = [
                    'facility_name_id' => implode(",", $postData['facility_name_id']),
                    'sports_recreation_id' => implode(",", $postData['sports_recreation_id']),
                    'extra_info_id' => implode(",", $postData['extra_info_id']),
                    'payment_option_id' => implode(",", $postData['payment_option_id']),
                    'currency' => $postData['currency'],
                    'payment_description' => $postData['payment_description'],
                    'created_date' => date('Y-m-d'),
                    'user_id' => $userId,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'hotel_id' => $postData['id']
                ];
                //print_r($finalData); die;
                $responseData = $this->CommonModel->updateHotelPaymentFeatureDetails($finalData);
                if ($responseData['response']['status'] == 'success') {
                    $msg = "Details Updated Successfully!..";
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Details Could Not Upated!..";
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
                //$this->redirect()->toRoute('hotel', ['action' => 'index']);
                //$this->redirect()->toRoute('hotel', ['action' => 'payment-feature-hotel']);
                return $this->redirect()->toUrl('contact-hotel?id=' . $postData['id']);
            }
        }
        $hotelData = ['hotel_id' => $id];
        $hotelFacilityData = $this->CommonModel->getHotelFacilityList($hotelData);
        $hotelSportsData = $this->CommonModel->getHotelSportsRecreationList($hotelData);
        $hotelExtraInfoData = $this->CommonModel->getHotelExtraInfoList($hotelData);
        $hotelPaymentOptionData = $this->CommonModel->getHotelPaymentOptionList($hotelData);
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        $packageListing = $this->CommonModel->getHotelDetailsList($data);
        $viewModel = new ViewModel([
            'form' => $form,
            'tab' => 'payment-feature-hotel',
            'packageListing' => $packageListing,
            'hotelFacilityData' => $hotelFacilityData,
            'hotelSportsData' => $hotelSportsData,
            'hotelExtraInfoData' => $hotelExtraInfoData,
            'hotelPaymentOptionData' => $hotelPaymentOptionData
        ]);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 10-JANUARY-2022
     * @description : FUNCTION TO ADD HOTEL ROOM DETAILS
     */

    public function roomHotelAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        HotelRoomForm::$hotel_list = $this->CommonModel->getHotelList($data);
        HotelRoomForm::$roomCategoryList = $this->CommonModel->getRoomCategoryList();
        HotelRoomForm::$roomTypeList = $this->CommonModel->getRoomTypeList();
        HotelRoomForm::$facilityList = $this->CommonModel->getRoomFacilityList();
        $form = new HotelRoomForm();
        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            //echo '<pre>';print_r($postData);die();
            $form->setData($postData);
            if ($form->isValid()) {
                $finalData = [];
                $finalData = [
                    'category_id' => $postData['category_id'],
                    'room_type_id' => $postData['room_type_id'],
                    'facility_type_id' => implode(",", $postData['facility_type_id']),
                    'name' => $postData['name'],
                    'minimum_staying' => $postData['minimum_staying'],
                    'maximum_adult' => $postData['maximum_adult'],
                    'maximum_children' => $postData['maximum_children'],
                    'extra_bed' => $postData['extra_bed'],
                    'description' => $postData['description'],
                    'created_date' => date('Y-m-d'),
                    'user_id' => $userId,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'hotel_id' => $postData['hotel_id']
                ];
                $responseData = $this->CommonModel->insertHotelRoomDetails($finalData);
                if ($responseData['response']['status'] == 'success') {
                    $msg = "Details Updated Successfully!..";
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Details Could Not Upated!..";
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
                //$this->redirect()->toRoute('hotel', ['action' => 'index']);
                $this->redirect()->toRoute('hotel', ['action' => 'room-hotel']);
            }
            /* else{
              $msg = $form->getMessages();
              print_r($msg); die;
              } */
        }
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        $packageListing = $this->CommonModel->getHotelRoomDetailsList($data);
        $viewModel = new ViewModel([
            'form' => $form,
            'tab' => 'room-hotel',
            'packageListing' => $packageListing
        ]);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 10-JANUARY-2022
     * @description : FUNCTION TO EDIT HOTEL ROOM DETAILS
     */

    public function editRoomHotelAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        HotelRoomForm::$hotel_list = $this->CommonModel->getHotelList($data);
        HotelRoomForm::$roomCategoryList = $this->CommonModel->getRoomCategoryList();
        HotelRoomForm::$roomTypeList = $this->CommonModel->getRoomTypeList();
        HotelRoomForm::$facilityList = $this->CommonModel->getRoomFacilityList();
        $form = new HotelRoomForm();
        $documentListing = [];
        $id = $this->params()->fromQuery('id');
        if (!empty($id)) {
            $sessionHotelContainer = new Container('addHotelData');
            $hotelId = $sessionHotelContainer->hotel_id;
            if ($hotelId == $id) {
                $data = [
                    'hotel_id' => $id,
                    'company_id' => $this->config()->getConfig()->company->companyId
                ];
            } else {
                $data = [
                    'auto_id' => $id,
                    'company_id' => $this->config()->getConfig()->company->companyId
                ];
            }
            $vehicleData = $this->CommonModel->getHotelRoomDetailsList($data);
            $vehicleData = $vehicleData[0];
            $form->setData($vehicleData);
            $form->get('id')->setValue($vehicleData['id']);
            $form->get('module_id')->setValue($vehicleData['id']);            
            $form->get('hotel_id')->setValue($vehicleData['hotel_id']);
            $form->get('hotel_id')->setAttribute("disabled", [$vehicleData['hotel_id']]);
            
        } else {
            $this->redirect()->toRoute('hotel', ['action' => 'room-hotel']);
        }
        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            //echo '<pre>';print_r($postData);die();
            $form->setData($postData);
            $form->getInputFilter()->get('hotel_id')->setRequired(false);  
            if ($form->isValid()) {
                $finalData = [];
                $finalData = [
                    'category_id' => $postData['category_id'],
                    'room_type_id' => $postData['room_type_id'],
                    'facility_type_id' => implode(",", $postData['facility_type_id']),
                    'name' => $postData['name'],
                    'minimum_staying' => $postData['minimum_staying'],
                    'maximum_adult' => $postData['maximum_adult'],
                    'maximum_children' => $postData['maximum_children'],
                    'extra_bed' => $postData['extra_bed'],
                    'description' => $postData['description'],
                    'created_date' => date('Y-m-d'),
                    'user_id' => $userId,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'hotel_id' => $vehicleData['hotel_id'],
                    'auto_id' => $postData['id']
                ];
                //echo "<pre>";print_r($finalData); die;
                $responseData = $this->CommonModel->updateHotelRoomDetails($finalData);
                if ($responseData['response']['status'] == 'success') {
                    $msg = "Details Updated Successfully!..";
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Details Could Not Upated!..";
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
                //$this->redirect()->toRoute('hotel', ['action' => 'room-hotel']);
                //return $this->redirect()->toUrl('room-hotel?id='.$postData['id']);
                return $this->redirect()->toUrl('allocation-hotel?id=' . $postData['id']);
            }
//             else{
//              $msg = $form->getMessages();
//              print_r($msg); die;
//              } 
        }
        $hotelData = ['room_id' => $id];
        $hotelRoomFacilityData = $this->CommonModel->getHotelRoomFacilityList($hotelData);
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        $packageListing = $this->CommonModel->getHotelRoomDetailsList($data);
        $documentListing = $this->CommonModel->getHotelRoomUploadImages($hotelData);
        $viewModel = new ViewModel([
            'form' => $form,
            'tab' => 'room-hotel',
            'packageListing' => $packageListing,
            'hotelRoomFacilityData' => $hotelRoomFacilityData,
            'documentListing' => $documentListing,
        ]);
        return $viewModel;
    }

    public function roomRateActionOld() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        $dataVendor = ['booking_type_id' => $this->config()->getConfig()->masterBookingType->hotelId];
        HotelRoomRateForm::$hotel_list = $this->CommonModel->getHotelList($data);
        HotelRoomRateForm::$vendorTypeList = $this->CommonModel->getHotelVendorTypeList($dataVendor);
        HotelRoomRateForm::$currenyList = $this->CommonModel->getCurrencyList();
        HotelRoomRateForm::$mealPlanList = $this->CommonModel->getMealPlanList($data);
        HotelRoomRateForm::$hotelRateTypeList = $this->CommonModel->getHotelRateTypeList($data);
        HotelRoomRateForm::$hotelSeasonNameList = $this->CommonModel->getHotelSeasonNameList($data);
        HotelRoomRateForm::$hotelRateNameList = $this->CommonModel->getHotelRateNameList($data);
        HotelRoomRateForm::$weekDaysList = $this->userModel->getWeekDaysList();
        HotelRoomRateForm::$promotionRateTypeList = $this->CommonModel->getPromotionRateTypeList($data);
        $mealPlanList = $this->CommonModel->getMealPlanListData($data);
        $rateTypeList = $this->CommonModel->getHotelRateTypeListData($data);
        $form = new HotelRoomRateForm();

        $id = $this->params()->fromQuery('id');
        if (!empty($id)) {
            $data = [
                'auto_id' => $id
            ];

            $dataRooms = [
                'company_id' => $this->config()->getConfig()->company->companyId,
                'hotel_id' => $id
            ];
            $roomList = $this->CommonModel->getHotelRoomList($dataRooms);
            //var_dump($roomList); die;
            $form->get('room_id')->setValueOptions($roomList);
            $vehicleData = $this->CommonModel->getHotelDetailsList($data);

            $vehicleData = $vehicleData[0];
            $form->setData($vehicleData);
            $form->getInputFilter()->get('hotel_id')->setRequired(false);
            $form->get('id')->setValue($vehicleData['id']);
            $form->get('hotel_id')->setValue($vehicleData['id']);
            $form->get('hotel_id')->setAttribute("disabled", [$vehicleData['id']]);
        }
        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            echo '<pre>';
            print_r($postData); //die();
            $form->setData($postData);


            //echo "Mohit";
            //echo "<pre>";print_r($normalRateMealPlandetails); die;
            //if ($form->isValid()) {
            $finalData = [];
            $normalRateMealPlandetails = [];
            $normalRateExtraMealDetails = [];
            if (isset($postData['meal_plan_id']) && !empty($postData['meal_plan_id'])) {
                $meal_plan_id = array_values($postData['meal_plan_id']);
                for ($i = 0; $i < count($meal_plan_id); $i++) {
                    $mealPlanName = $this->CommonModel->getMealPlanTypeName($meal_plan_id[$i]);
                    $normalRateMealPlandetails['meal_plan_type_id'][$i] = $meal_plan_id[$i];
                    $normalRateMealPlandetails['sgl_rate'][$i] = $postData['sgl_rate_' . $mealPlanName];
                    $normalRateMealPlandetails['dbl_rate'][$i] = $postData['dbl_rate_' . $mealPlanName];
                    $normalRateMealPlandetails['tbl_rate'][$i] = $postData['tbl_rate_' . $mealPlanName];
                    $normalRateMealPlandetails['child_rate'][$i] = $postData['child_rate_' . $mealPlanName];
                    $normalRateMealPlandetails['child1_rate'][$i] = $postData['child1_rate_' . $mealPlanName];
                    $normalRateMealPlandetails['extra_bed_rate'][$i] = $postData['extra_bed_rate_' . $mealPlanName];
                }
            }
            if (isset($postData['extra_meal_adult_sgl']) && !empty($postData['extra_meal_adult_sgl'])) {
                $normalRateExtraMealDetails['sgl_ext_adult_breakfast_rate'] = $postData['extra_meal_adult_sgl'];
                $normalRateExtraMealDetails['dbl_ext_adult_lunch_rate'] = $postData['extra_meal_adult_dbl'];
                $normalRateExtraMealDetails['tbl_ext_adult_dinner_rate'] = $postData['extra_meal_adult_tbl'];
                $normalRateExtraMealDetails['child2to12_ext_breakfast_rate'] = $postData['extra_meal_child_child'];
                $normalRateExtraMealDetails['child12to16_ext_lunch_rate'] = $postData['extra_meal_child_child1'];
                $normalRateExtraMealDetails['extra_with_bed_ext_dinner_rate'] = $postData['extra_meal_child_child1'];
            }

            //Stay More Get More Discount
            $stayingdetails = [];
            if (isset($postData['stay_get_mor_dis']) && !empty($postData['stay_get_mor_dis'])) {
                $staying_days = array_values($postData['staying_days']);
                $more_discount_from = array_values($postData['more_discount_from']);
                $more_discount_to = array_values($postData['more_discount_to']);
                $stay_more_discount_type = array_values($postData['stay_more_discount_type']);
                $staying_amount = array_values($postData['staying_amount']);

                for ($i = 0; $i < count($staying_days); $i++) {
                    $stayingdetails['stay_more_week_days'][$i] = $staying_days[$i];
                    $stayingdetails['stay_more_from_date'][$i] = date('Y-m-d', strtotime($more_discount_from[$i]));
                    $stayingdetails['stay_more_to_date'][$i] = date('Y-m-d', strtotime($more_discount_to[$i]));
                    $stayingdetails['stay_more_type'][$i] = $stay_more_discount_type[$i];
                    $stayingdetails['stay_more_value'][$i] = $staying_amount[$i];
                }
            }


            //Last Minute Booking
            if (isset($postData['last_minute_booking_hour']) && !empty($postData['last_minute_booking_hour'])) {
                $lastBookingDetails = [];
                $last_minute_booking_hour = array_values($postData['last_minute_booking_hour']);
                $last_booking_from = array_values($postData['last_booking_from']);
                $last_booking_to = array_values($postData['last_booking_to']);
                $last_minute_booking_type = array_values($postData['last_minute_booking_type']);
                $last_minute_booking_amount = array_values($postData['last_minute_booking_amount']);


                for ($i = 0; $i < count($last_minute_booking_hour); $i++) {
                    $lastBookingDetails['last_min_hour'][$i] = $last_minute_booking_hour[$i];
                    $lastBookingDetails['last_min_from_date'][$i] = date('Y-m-d', strtotime($last_booking_from[$i]));
                    $lastBookingDetails['last_min_to_date'][$i] = date('Y-m-d', strtotime($last_booking_to[$i]));
                    $lastBookingDetails['last_min_discount_type'][$i] = $last_minute_booking_type[$i];
                    $lastBookingDetails['last_min_discount_value'][$i] = $last_minute_booking_amount[$i];
                }
            }

            //Early Booking
            if (isset($postData['early_booking']) && !empty($postData['early_booking'])) {
                $earlyBookingDetails = [];
                $early_booking_days = array_values($postData['early_booking_days']);
                $early_booking_from = array_values($postData['early_booking_from']);
                $early_booking_to = array_values($postData['early_booking_to']);
                $early_booking_type = array_values($postData['early_booking_type']);
                $early_booking_amount = array_values($postData['early_booking_amount']);


                for ($i = 0; $i < count($early_booking_days); $i++) {
                    $earlyBookingDetails['early_week_days'][$i] = $early_booking_days[$i];
                    $earlyBookingDetails['early_from_date'][$i] = date('Y-m-d', strtotime($early_booking_from[$i]));
                    $earlyBookingDetails['early_to_date'][$i] = date('Y-m-d', strtotime($early_booking_to[$i]));
                    $earlyBookingDetails['early_discount_type'][$i] = $early_booking_type[$i];
                    $earlyBookingDetails['early_discount_value'][$i] = $early_booking_amount[$i];
                }
            }

            //Day Wise Discount
            if (isset($postData['day_wise_discount']) && !empty($postData['day_wise_discount'])) {
                $dayWiseDetails = [];
                $dis_days = array_values($postData['dis_days']);
                $day_wise_from = array_values($postData['day_wise_from']);
                $day_wise_to = array_values($postData['day_wise_to']);
                $day_wise_dis_type = array_values($postData['day_wise_dis_type']);
                $day_wise_discount_amount = array_values($postData['day_wise_discount_amount']);

                if (!empty($dis_days)) {
                    for ($i = 0; $i < count($dis_days); $i++) {
                        $dayWiseDetails['daywise_week_days'][$i] = $dis_days[$i];
                        $dayWiseDetails['daywise_from_date'][$i] = date('Y-m-d', strtotime($day_wise_from[$i]));
                        $dayWiseDetails['daywise_to_date'][$i] = date('Y-m-d', strtotime($day_wise_to[$i]));
                        $dayWiseDetails['daywise_discount_type'][$i] = $day_wise_dis_type[$i];
                        $dayWiseDetails['daywise_discount_value'][$i] = $day_wise_discount_amount[$i];
                    }
                }
            }


            //Kids Free Offers
            if (isset($postData['kids_mor_dis']) && !empty($postData['kids_mor_dis'])) {
                $kidsBookingDetails = [];
                $kids_package_name = array_values($postData['kids_package_name']);
                $kids_rooms = array_values($postData['kids_rooms']);
                $kids_nights = array_values($postData['kids_nights']);
                $kids_discount_from = array_values($postData['kids_discount_from']);
                $kids_discount_to = array_values($postData['kids_discount_to']);

                for ($i = 0; $i < count($kids_package_name); $i++) {
                    $kidsBookingDetails['package_name'][$i] = $kids_package_name[$i];
                    $kidsBookingDetails['rooms'][$i] = $kids_rooms[$i];
                    $kidsBookingDetails['nights'][$i] = $kids_nights[$i];
                    $kidsBookingDetails['from_date'][$i] = date('Y-m-d', strtotime($kids_discount_from[$i]));
                    $kidsBookingDetails['to_date'][$i] = date('Y-m-d', strtotime($kids_discount_to[$i]));
                    $kidsBookingDetails['type'][$i] = 'kids';
                }
            }

            //Free Night Offers
            if (isset($postData['night_mor_dis']) && !empty($postData['night_mor_dis'])) {
                $nightBookingDetails = [];
                $night_package_name = array_values($postData['night_package_name']);
                $night_rooms = array_values($postData['night_rooms']);
                $night_nights = array_values($postData['night_nights']);
                $night_discount_from = array_values($postData['night_discount_from']);
                $night_discount_to = array_values($postData['night_discount_to']);

                for ($i = 0; $i < count($night_package_name); $i++) {
                    $nightBookingDetails['package_name'][$i] = $night_package_name[$i];
                    $nightBookingDetails['rooms'][$i] = $night_rooms[$i];
                    $nightBookingDetails['nights'][$i] = $night_nights[$i];
                    $nightBookingDetails['from_date'][$i] = date('Y-m-d', strtotime($night_discount_from[$i]));
                    $nightBookingDetails['to_date'][$i] = date('Y-m-d', strtotime($night_discount_to[$i]));
                    $nightBookingDetails['type'][$i] = 'nights';
                }
            }


            //Free Room Offers
            if (isset($postData['room_mor_dis']) && !empty($postData['room_mor_dis'])) {
                $roomBookingDetails = [];
                $room_package_name = array_values($postData['room_package_name']);
                $room_rooms = array_values($postData['room_rooms']);
                $room_nights = array_values($postData['room_nights']);
                $room_discount_from = array_values($postData['room_discount_from']);
                $room_discount_to = array_values($postData['room_discount_to']);

                for ($i = 0; $i < count($room_package_name); $i++) {
                    $roomBookingDetails['package_name'][$i] = $room_package_name[$i];
                    $roomBookingDetails['rooms'][$i] = $room_rooms[$i];
                    $roomBookingDetails['nights'][$i] = $room_nights[$i];
                    $roomBookingDetails['from_date'][$i] = date('Y-m-d', strtotime($room_discount_from[$i]));
                    $roomBookingDetails['to_date'][$i] = date('Y-m-d', strtotime($room_discount_to[$i]));
                    $roomBookingDetails['type'][$i] = 'rooms';
                }
            }

            /* $finalData['room_rate'] = [                    
              'normal_rate' => $postData['normal_rate'],
              'hotel_id' => $postData['hotel_id'],
              'room_id' => $postData['room_id'],
              'currency_id' => $postData['currency'],
              'vendor_type' => $postData['vendor_type'],
              'vendor_id' => $postData['vendor_name'],
              'rate_type' => 'Normal Rate',
              'rate_name_id' => $postData['hotel_rate_name'],
              'season_id' => $postData['hotel_rate_season'],
              'week_days' => implode(',',$postData['weekdays']),
              'valid_from' => date('Y-m-d',strtotime($postData['valid_from'])),
              'valid_to' => date('Y-m-d',strtotime($postData['valid_to'])),
              'netrate_commissionrate' => $postData['typeofcommission'],
              'commission_rate_type' => $postData['commissiontype'],
              'commission_rate_value' => $postData['commission_value'],
              'description' => $postData['contract_rate_desc'],
              "normal_rate_meal_plan_details" => $normalRateMealPlandetails,
              "normal_rate_extra_meal_details" => $normalRateExtraMealDetails,
              "price_plan_name" => $postData['name_of_price_plan'],
              "stay_more_status" => $postData['stay_get_mor_dis'],
              "stay_more_discount_value" => $stayingdetails,
              "last_min_booking_status" => $postData['last_minute_booking'],
              "last_min_booking_value" => $lastBookingDetails,
              "early_booking_status" => $postData['early_booking'],
              "early_booking_value" => $earlyBookingDetails,
              "daywise_discount_status" => $postData['day_wise_discount'],
              "daywise_discount_value" => $dayWiseDetails,
              "kids_discount_status" => $postData['kids_mor_dis'],
              "kids_discount_value" => $kidsBookingDetails,
              "night_discount_status" => $postData['night_mor_dis'],
              "night_discount_value" => $nightBookingDetails,
              "room_discount_status" => $postData['room_mor_dis'],
              "room_discount_value" => $roomBookingDetails,
              'user_id' => $userId,
              'ip' => $_SERVER['REMOTE_ADDR'],
              'bkg_type_id' => $this->config()->getConfig()->masterBookingType->hotelId
              ]; */



            //////////////Package Rate Code Starts Here //////////////////////////
            if (isset($postData['hotel_rate_type']) && !empty($postData['hotel_rate_type'])) {
                $hotel_rate_type = array_values($postData['hotel_rate_type']);
                $package_rate_season = array_values($postData['package_rate_season']);
                $pacakge_room_id = array_values($postData['pacakge_room_id']);
                $hotel_package_name = array_values($postData['hotel_package_name']);
                $package_minimum_nights = array_values($postData['package_minimum_nights']);
                //$package_rate_weekdays = array_values($postData['package_rate_weekdays']);
                $package_valid_from = array_values($postData['package_valid_from']);
                $package_valid_to = array_values($postData['package_valid_to']);
                $package_type_of_commission = array_values($postData['packagetypeofcommission']);
                $package_commission_type = array_values($postData['packagecommissiontype']);
                $package_commission_value = array_values($postData['package_commission_value']);
                $package_rate_desc = array_values($postData['package_rate_desc']);
                $package_name_of_price_plan = array_values($postData['package_name_of_price_plan']);
                if (isset($postData['extra_meal_adult_sgl_package']) && !empty($postData['extra_meal_adult_sgl_package'])) {
                    $package_extra_meal_adult_sgl_package = array_values($postData['extra_meal_adult_sgl_package']);
                }
                if (isset($postData['extra_meal_adult_dbl_package']) && !empty($postData['extra_meal_adult_dbl_package'])) {
                    $package_extra_meal_adult_dbl_package = array_values($postData['extra_meal_adult_dbl_package']);
                }
                if (isset($postData['extra_meal_adult_tbl_package']) && !empty($postData['extra_meal_adult_tbl_package'])) {
                    $package_extra_meal_adult_tbl_package = array_values($postData['extra_meal_adult_tbl_package']);
                }
                if (isset($postData['extra_meal_child_child_package']) && !empty($postData['extra_meal_child_child_package'])) {
                    $package_extra_meal_child_child_package = array_values($postData['extra_meal_child_child_package']);
                }
                if (isset($postData['extra_meal_child_child1_package']) && !empty($postData['extra_meal_child_child1_package'])) {
                    $package_extra_meal_child_child1_package = array_values($postData['extra_meal_child_child1_package']);
                }
                if (isset($postData['extra_meal_child_extra_bed_package']) && !empty($postData['extra_meal_child_extra_bed_package'])) {
                    $package_extra_meal_child_extra_bed_package = array_values($postData['extra_meal_child_extra_bed_package']);
                }



                $packageBookingDetails = [];
                $packageBookingDetails['hotel_id'] = $postData['hotel_id'];
                $packageBookingDetails['currency_id'] = $postData['currency'];
                $packageBookingDetails['vendor_type'] = $postData['vendor_type'];
                $packageBookingDetails['vendor_id'] = $postData['vendor_name'];
                $packageBookingDetails['rate_name_id'] = $postData['hotel_rate_name'];
                $packageBookingDetails['rate_type'] = 'Package Rate';
                $packageBookingDetails['user_id'] = $userId;
                $packageBookingDetails['ip'] = $_SERVER['REMOTE_ADDR'];
                $packageBookingDetails['bkg_type_id'] = $this->config()->getConfig()->masterBookingType->hotelId;

                //var_dump($package_rate_desc); //die;

                /* if(!empty($hotel_rate_type)){

                  for ($i = 0; $i < count($hotel_rate_type); $i++) {
                  echo $val;
                  echo "Mohit";
                  $packageBookingDetails['rate_type_id'][$i] = $hotel_rate_type[$i];
                  $packageBookingDetails['room_id'][$i] = $pacakge_room_id[$i];
                  $packageBookingDetails['season_id'][$i] = $package_rate_season[$i];
                  $package_rate_weekdays[$i] = array_values($postData['package_rate_weekdays'.$i]);
                  $packageBookingDetails['week_days'][$i] =  implode(',',$package_rate_weekdays[$i]);
                  $packageBookingDetails['valid_from'][$i] = date('Y-m-d',strtotime($package_valid_from[$i]));
                  $packageBookingDetails['valid_to'][$i] = date('Y-m-d',strtotime($package_valid_to[$i]));
                  $packageBookingDetails['netrate_commissionrate'][$i] = $package_type_of_commission[$i];
                  $packageBookingDetails['commission_rate_type'][$i] = $package_commission_type[$i];
                  $packageBookingDetails['commission_rate_value'][$i] = $package_commission_value[$i];
                  $packageBookingDetails['description'][$i] = $package_rate_desc[$i];
                  if (isset($postData['package_meal_plan_id']) && !empty($postData['package_meal_plan_id'])) {
                  $package_meal_plan_id = array_values($postData['package_meal_plan_id']);
                  var_dump($package_meal_plan_id);
                  }
                  }
                  }
                  die; */
                $arr = array();
                for ($i = 1; $i <= count($hotel_rate_type); $i++) {
                    echo "Mohit";
                    //$packageBookingDetails['rate_type_id'] = $hotel_rate_type[$i-1];
                    //$packageBookingDetails['room_id'] = $pacakge_room_id[$i-1];                        
                    //$packageBookingDetails['season_id'][$i-1] = $package_rate_season[$i-1];
                    $package_rate_weekdays[$i] = array_values($postData['package_rate_weekdays' . $i]);
                    $package_promotion_rate_type[$i] = array_values($postData['package_promotion_rate_type' . $i]);
                    //$packageBookingDetails['week_days'][$i] =  implode(',',$package_rate_weekdays[$i]);
                    //$packageBookingDetails['package_name'][$i-1] = $hotel_package_name[$i-1];
                    //$packageBookingDetails['minimum_nights'][$i-1] = $package_minimum_nights[$i-1];
                    //$packageBookingDetails['valid_from'][$i-1] = date('Y-m-d',strtotime($package_valid_from[$i-1]));
                    //$packageBookingDetails['valid_to'][$i-1] = date('Y-m-d',strtotime($package_valid_to[$i-1]));
                    //$packageBookingDetails['netrate_commissionrate'][$i] = $package_type_of_commission[$i];
                    //$packageBookingDetails['commission_rate_type'][$i] = $package_commission_type[$i];
                    //$packageBookingDetails['commission_rate_value'][$i] = $package_commission_value[$i];
                    //$packageBookingDetails['description'][$i-1] = $package_rate_desc[$i-1];
                    //$packageBookingDetails['price_plan_name'][$i] = $package_name_of_price_plan[$i];                  
                    if (isset($postData['package_meal_plan_id' . $i]) && !empty($postData['package_meal_plan_id' . $i])) {
                        $package_meal_plan_id = array_values($postData['package_meal_plan_id' . $i]);
                        //var_dump($package_meal_plan_id);

                        for ($j = 0; $j < count($package_meal_plan_id); $j++) {
                            //echo $package_meal_plan_id[$j];
                            $packagemealPlanName = $this->CommonModel->getMealPlanTypeName($package_meal_plan_id[$j]);
                            $packageBookingDetails['meal_plan_type_id'][$i][$j] = $package_meal_plan_id[$j];
                            $packageBookingDetails['sgl_rate'][$i][$j] = $postData['package_sgl_rate_' . $packagemealPlanName . $i];
                            $packageBookingDetails['dbl_rate'][$i][$j] = $postData['package_dbl_rate_' . $packagemealPlanName . $i];
                            $packageBookingDetails['tbl_rate'][$i][$j] = $postData['package_tbl_rate_' . $packagemealPlanName . $i];
                            $packageBookingDetails['child_rate'][$i][$j] = $postData['package_child_rate_' . $packagemealPlanName . $i];
                            $packageBookingDetails['child1_rate'][$i][$j] = $postData['package_child1_rate_' . $packagemealPlanName . $i];
                            $packageBookingDetails['extra_bed_rate'][$i][$j] = $postData['package_extra_bed_rate_' . $packagemealPlanName . $i];
                        }
                    }
                    $packageBookingDetails['sgl_ext_adult_breakfast_rate'][$i - 1] = $package_extra_meal_adult_sgl_package[$i - 1];
                    $packageBookingDetails['dbl_ext_adult_lunch_rate'][$i - 1] = $package_extra_meal_adult_dbl_package[$i - 1];
                    $packageBookingDetails['tbl_ext_adult_dinner_rate'][$i - 1] = $package_extra_meal_adult_tbl_package[$i - 1];
                    $packageBookingDetails['child2to12_ext_breakfast_rate'][$i - 1] = $package_extra_meal_child_child_package[$i - 1];
                    $packageBookingDetails['child12to16_ext_lunch_rate'][$i - 1] = $package_extra_meal_child_child1_package[$i - 1];
                    $packageBookingDetails['extra_with_bed_ext_dinner_rate'][$i - 1] = $package_extra_meal_child_extra_bed_package[$i - 1];

                    $stayingPackageDetails = [];
                    if (isset($postData['package_stay_get_mor_dis']) && !empty($postData['package_stay_get_mor_dis'])) {
                        $package_staying_days = array_values($postData['package_staying_days'][$i]);
                        //$package_more_discount_from = array_values($postData['package_more_discount_from']);
                        //$package_more_discount_to = array_values($postData['package_more_discount_to']);
                        //$package_stay_more_discount_type = array_values($postData['package_stay_more_discount_type']);
                        //$package_staying_amount = array_values($postData['package_staying_amount']);

                        for ($k = 0; $k < count($package_staying_days); $k++) {
                            $stayingPackageDetails['stay_more_week_days'][$i][$k] = $package_staying_days[$i];
                            //$stayingPackageDetails['stay_more_from_date'][$i][$k] = date('Y-m-d',strtotime($package_more_discount_from[$i]));
                            //$stayingPackageDetails['stay_more_to_date'][$i][$k] = date('Y-m-d',strtotime($package_more_discount_to[$i]));
                            //$stayingPackageDetails['stay_more_type'][$i][$k] = $package_stay_more_discount_type[$i];
                            //$stayingPackageDetails['stay_more_value'][$i][$k] = $package_staying_amount[$i];
                        }
                    }

                    $packageRateMealPlandetails = [];
                    if (isset($postData['package_meal_plan_id' . $i]) && !empty($postData['package_meal_plan_id' . $i])) {
                        $package_meal_plan_id = array_values($postData['package_meal_plan_id' . $i]);
                        //var_dump($package_meal_plan_id);

                        for ($j = 0; $j < count($package_meal_plan_id); $j++) {
                            //echo $package_meal_plan_id[$j];
                            $packagemealPlanName = $this->CommonModel->getMealPlanTypeName($package_meal_plan_id[$j]);
                            $packageRateMealPlandetails['meal_plan_type_id'][$i] = $package_meal_plan_id[$j];
                            $packageRateMealPlandetails['sgl_rate'][$i][$j] = $postData['package_sgl_rate_' . $packagemealPlanName . $i];
                            $packageRateMealPlandetails['dbl_rate'][$i][$j] = $postData['package_dbl_rate_' . $packagemealPlanName . $i];
                            $packageRateMealPlandetails['tbl_rate'][$i][$j] = $postData['package_tbl_rate_' . $packagemealPlanName . $i];
                            $packageRateMealPlandetails['child_rate'][$i][$j] = $postData['package_child_rate_' . $packagemealPlanName . $i];
                            $packageRateMealPlandetails['child1_rate'][$i][$j] = $postData['package_child1_rate_' . $packagemealPlanName . $i];
                            $packageRateMealPlandetails['extra_bed_rate'][$i][$j] = $postData['package_extra_bed_rate_' . $packagemealPlanName . $i];
                        }
                    }


                    $finalData['room_rate'] = [
                        'normal_rate' => 1,
                        'hotel_id' => $postData['hotel_id'],
                        'room_id' => $pacakge_room_id[$i],
                        'currency_id' => $postData['currency'],
                        'vendor_type' => $postData['vendor_type'],
                        'vendor_id' => $postData['vendor_name'],
                        'rate_type' => 'Package Rate',
                        'rate_type_id' => $hotel_rate_type[$i],
                        'rate_name_id' => $postData['hotel_rate_name'],
                        'season_id' => $package_rate_season[$i],
                        'package_name' => $hotel_package_name[$i],
                        'minimum_nights' => $package_minimum_nights[$i],
                        'week_days' => implode(',', $package_rate_weekdays[$i]),
                        'valid_from' => date('Y-m-d', strtotime($package_valid_from[$i])),
                        'valid_to' => date('Y-m-d', strtotime($package_valid_to[$i])),
                        'netrate_commissionrate' => $package_type_of_commission[$i],
                        'commission_rate_type' => $package_commission_type[$i],
                        'commission_rate_value' => $package_commission_value[$i],
                        'description' => $package_rate_desc[$i],
                        "normal_rate_meal_plan_details" => $packageRateMealPlandetails[$i],
                        "normal_rate_extra_meal_details" => $normalRateExtraMealDetails,
                        'promotion_plan' => implode(',', $package_promotion_rate_type[$i]),
                        "price_plan_name" => $package_name_of_price_plan[$i],
                        //"stay_more_status" => !empty($stayingdetails)? $postData['stay_get_mor_dis']:0,
                        //"stay_more_discount_value" => $stayingdetails,
                        //"last_min_booking_status" => !empty($lastBookingDetails)? $postData['last_minute_booking']:0,
                        //"last_min_booking_value" => $lastBookingDetails,
                        //"early_booking_status" => !empty($earlyBookingDetails)? $postData['early_booking']:0,
                        //"early_booking_value" => $earlyBookingDetails,
                        //"daywise_discount_status" => !empty($dayWiseDetails)? $postData['day_wise_discount']:0,
                        //"daywise_discount_value" => $dayWiseDetails,
                        //"kids_discount_status" => !empty($kidsBookingDetails)? $postData['kids_mor_dis']:0,
                        //"kids_discount_value" => $kidsBookingDetails,
                        //"night_discount_status" => !empty($nightBookingDetails)? $postData['night_mor_dis']:0,
                        //"night_discount_value" => $nightBookingDetails,
                        //"room_discount_status" => !empty($roomBookingDetails)? $postData['room_mor_dis']:0,
                        //"room_discount_value" => $roomBookingDetails,
                        'user_id' => $userId,
                        'ip' => $_SERVER['REMOTE_ADDR'],
                        'bkg_type_id' => $this->config()->getConfig()->masterBookingType->hotelId
                    ];

                    echo "<pre>";
                    print_r($finalData);
                }
            }

            die;

            /* if (isset($postData['hotel_rate_type']) && !empty($postData['hotel_rate_type'])) {
              $packageBookingDetails = [];
              $hotel_rate_type = array_values($postData['hotel_rate_type']);
              $package_rate_season = array_values($postData['package_rate_season']);
              $pacakge_room_id = array_values($postData['pacakge_room_id']);
              $hotel_package_name = array_values($postData['hotel_package_name']);
              $package_minimum_nights = array_values($postData['package_minimum_nights']);
              $package_rate_weekdays = array_values($postData['package_rate_weekdays']);
              $package_valid_from = array_values($postData['package_valid_from']);
              $package_valid_to = array_values($postData['package_valid_to']);
              $package_type_of_commission = array_values($postData['packagetypeofcommission']);
              $package_commission_type = array_values($postData['packagecommissiontype']);
              $package_commission_value = array_values($postData['package_commission_value']);
              $package_rate_desc = array_values($postData['package_rate_desc']);
              $package_name_of_price_plan = array_values($postData['package_name_of_price_plan']);

              $packageRateMealPlandetails = [];
              if (isset($postData['package_meal_plan_id']) && !empty($postData['package_meal_plan_id'])) {
              $package_meal_plan_id = array_values($postData['package_meal_plan_id']);
              for ($j = 0; $j < count($package_meal_plan_id); $j++) {
              $packagemealPlanName = $this->CommonModel->getMealPlanTypeName($package_meal_plan_id[$j]);
              $packageRateMealPlandetails['meal_plan_type_id'][$j] = $package_meal_plan_id[$j];
              $packageRateMealPlandetails['sgl_rate'][$j] = $postData['package_sgl_rate_'.$packagemealPlanName];
              $packageRateMealPlandetails['dbl_rate'][$j] = $postData['package_dbl_rate_'.$packagemealPlanName];
              $packageRateMealPlandetails['tbl_rate'][$j] = $postData['package_tbl_rate_'.$packagemealPlanName];
              $packageRateMealPlandetails['child_rate'][$j] = $postData['package_child_rate_'.$packagemealPlanName];
              $packageRateMealPlandetails['child1_rate'][$j] = $postData['package_child1_rate_'.$packagemealPlanName];
              $packageRateMealPlandetails['extra_bed_rate'][$j] = $postData['package_extra_bed_rate_'.$packagemealPlanName];
              }
              }

              for ($i = 0; $i < count($hotel_rate_type); $i++) {
              $packageBookingDetails['hotel_id'][$i] = $postData['hotel_id'];
              $packageBookingDetails['room_id'][$i] = $pacakge_room_id[$i];
              $packageBookingDetails['currency_id'][$i] = $postData['currency'];
              $packageBookingDetails['vendor_type'][$i] = $postData['vendor_type'];
              $packageBookingDetails['vendor_id'][$i] = $postData['vendor_name'];
              $packageBookingDetails['rate_type'][$i] = 'Package Rate';
              $packageBookingDetails['rate_name_id'][$i] = $postData['hotel_rate_name'];
              $packageBookingDetails['season_id'][$i] = $package_rate_season[$i];
              $packageBookingDetails['week_days'][$i] =  implode(',',$package_rate_weekdays[$i]);
              $packageBookingDetails['valid_from'][$i] = date('Y-m-d',strtotime($package_valid_from[$i]));
              $packageBookingDetails['valid_to'][$i] = date('Y-m-d',strtotime($package_valid_to[$i]));
              $packageBookingDetails['netrate_commissionrate'][$i] = $package_type_of_commission[$i];
              $packageBookingDetails['commission_rate_type'][$i] = $package_commission_type[$i];
              $packageBookingDetails['commission_rate_value'][$i] = $package_commission_value[$i];
              $packageBookingDetails['description'][$i] = $package_rate_desc[$i];
              $packageBookingDetails['price_plan_name'][$i] = $package_name_of_price_plan[$i];
              $packageBookingDetails['package_rate_meal_plan_details'][$i] = $packageRateMealPlandetails[$i];
              $packageBookingDetails['user_id'][$i] = $userId;
              $packageBookingDetails['ip'][$i] = $_SERVER['REMOTE_ADDR'];
              $packageBookingDetails['bkg_type_id'][$i] = $this->config()->getConfig()->masterBookingType->hotelId;
              }

              } */


            //////////////Package Rate Code Starts Here //////////////////////////


            $finalData['package_room_rate'] = [
                'package_booking_details' => $packageBookingDetails,
                "package_stay_more_discount_value" => $stayingPackageDetails,
            ];

            //echo json_encode($finalData); die;
            echo '<pre>';
            print_r($finalData);
            die;
            $responseData = $this->CommonModel->insertHotelRoomRateDetails($finalData);
            echo '<pre>';
            print_r($responseData);
            die;
            if ($responseData['response']['status'] == 'success') {
                $msg = "Details Updated Successfully!..";
                $this->flashMessenger()->addMessage(array('success' => $msg));
            } else {
                $msg = "Details Could Not Upated!..";
                $this->flashMessenger()->addMessage(array('danger' => $msg));
            }
            $this->redirect()->toRoute('hotel', ['action' => 'index']);
            //}
            /* else{
              $msg = $form->getMessages();
              print_r($msg); die;
              } */
        }
        $week_days = $this->userModel->getWeekDaysList();
        $data = [
            'company_id' => $this->config()->getConfig()->company->companyId,
            'rate_type' => 'Package Rate'
        ];
        $packageListing = $this->CommonModel->getHotelRoomRateDetailsList($data);
        $viewModel = new ViewModel([
            'form' => $form,
            'tab' => 'room-rate',
            'packageListing' => $packageListing,
            'week_days' => $week_days,
            'mealPlanList' => $mealPlanList,
            'rateTypeList' => $rateTypeList,
        ]);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 10-JANUARY-2022
     * @description : FUNCTION TO ADD ROOM RATE DETAILS
     */

    public function roomRateAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        $dataVendor = ['booking_type_id' => $this->config()->getConfig()->masterBookingType->hotelId];
        HotelRoomRateForm::$hotel_list = $this->CommonModel->getHotelList($data);
        HotelRoomRateForm::$vendorTypeList = $this->CommonModel->getHotelVendorTypeList($dataVendor);
        HotelRoomRateForm::$currenyList = $this->CommonModel->getCurrencyList();
        HotelRoomRateForm::$mealPlanList = $this->CommonModel->getMealPlanList($data);
        HotelRoomRateForm::$hotelRateTypeList = $this->CommonModel->getHotelRateTypeList($data);
        HotelRoomRateForm::$hotelSeasonNameList = $this->CommonModel->getHotelSeasonNameList($data);
        HotelRoomRateForm::$hotelRateNameList = $this->CommonModel->getHotelRateNameList($data);
        HotelRoomRateForm::$weekDaysList = $this->userModel->getWeekDaysList();
        HotelRoomRateForm::$promotionRateTypeList = $this->CommonModel->getPromotionRateTypeList($data);
        $mealPlanList = $this->CommonModel->getMealPlanListData($data);
        $rateTypeList = $this->CommonModel->getHotelRateTypeListData($data);
        $form = new HotelRoomRateForm();
        $rateType = $this->params()->fromQuery('rate_type');
        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            //echo '<pre>';print_r($postData);//die();
            $form->setData($postData);
            //echo "Mohit";
            //echo "<pre>";print_r($normalRateMealPlandetails); die;
            //if ($form->isValid()) {
            $stayingdetails = "";
            $lastBookingDetails = "";
            $earlyBookingDetails = "";
            $dayWiseDetails = "";
            $kidsBookingDetails = "";
            $nightBookingDetails = "";
            $roomBookingDetails = "";
            $finalData = [];
            $normalRateMealPlandetails = [];
            $normalRateExtraMealDetails = [];
            if (isset($postData['meal_plan_id']) && !empty($postData['meal_plan_id'])) {
                $meal_plan_id = array_values($postData['meal_plan_id']);
                for ($i = 0; $i < count($meal_plan_id); $i++) {
                    $mealPlanName = $this->CommonModel->getMealPlanTypeName($meal_plan_id[$i]);
                    $normalRateMealPlandetails['meal_plan_type_id'][$i] = $meal_plan_id[$i];
                    $normalRateMealPlandetails['sgl_rate'][$i] = $postData['sgl_rate_' . $mealPlanName];
                    $normalRateMealPlandetails['dbl_rate'][$i] = $postData['dbl_rate_' . $mealPlanName];
                    $normalRateMealPlandetails['tbl_rate'][$i] = $postData['tbl_rate_' . $mealPlanName];
                    $normalRateMealPlandetails['child_rate'][$i] = $postData['child_rate_' . $mealPlanName];
                    $normalRateMealPlandetails['child1_rate'][$i] = $postData['child1_rate_' . $mealPlanName];
                    $normalRateMealPlandetails['extra_bed_rate'][$i] = $postData['extra_bed_rate_' . $mealPlanName];
                }
            }
            if (isset($postData['extra_meal_adult_sgl']) && !empty($postData['extra_meal_adult_sgl'])) {
                $normalRateExtraMealDetails['sgl_ext_adult_breakfast_rate'] = $postData['extra_meal_adult_sgl'];
                $normalRateExtraMealDetails['dbl_ext_adult_lunch_rate'] = $postData['extra_meal_adult_dbl'];
                $normalRateExtraMealDetails['tbl_ext_adult_dinner_rate'] = $postData['extra_meal_adult_tbl'];
                $normalRateExtraMealDetails['child2to12_ext_breakfast_rate'] = $postData['extra_meal_child_child'];
                $normalRateExtraMealDetails['child12to16_ext_lunch_rate'] = $postData['extra_meal_child_child1'];
                $normalRateExtraMealDetails['extra_with_bed_ext_dinner_rate'] = $postData['extra_meal_child_child1'];
            }

            //Stay More Get More Discount


            if (isset($postData['staying_days']) && !empty($postData['staying_days'])) {
                $stayingdetails = [];
                $staying_days = array_values(array_filter($postData['staying_days']));
                $more_discount_from = array_values(array_filter($postData['more_discount_from']));
                $more_discount_to = array_values(array_filter($postData['more_discount_to']));
                $stay_more_discount_type = array_values(array_filter($postData['stay_more_discount_type']));
                $staying_amount = array_values(array_filter($postData['staying_amount']));
                for ($i = 0; $i < count($staying_days); $i++) {
                    $stayingdetails['stay_more_week_days'][$i] = $staying_days[$i];
                    $stayingdetails['stay_more_from_date'][$i] = date('Y-m-d', strtotime($more_discount_from[$i]));
                    $stayingdetails['stay_more_to_date'][$i] = date('Y-m-d', strtotime($more_discount_to[$i]));
                    $stayingdetails['stay_more_type'][$i] = $stay_more_discount_type[$i];
                    $stayingdetails['stay_more_value'][$i] = $staying_amount[$i];
                }
            }


            //Last Minute Booking
            if (isset($postData['last_minute_booking_hour']) && !empty($postData['last_minute_booking_hour'])) {
                $lastBookingDetails = [];
                $last_minute_booking_hour = array_values(array_filter($postData['last_minute_booking_hour']));
                $last_booking_from = array_values(array_filter($postData['last_booking_from']));
                $last_booking_to = array_values(array_filter($postData['last_booking_to']));
                $last_minute_booking_type = array_values(array_filter($postData['last_minute_booking_type']));
                $last_minute_booking_amount = array_values(array_filter($postData['last_minute_booking_amount']));
                for ($i = 0; $i < count($last_minute_booking_hour); $i++) {
                    $lastBookingDetails['last_min_hour'][$i] = $last_minute_booking_hour[$i];
                    $lastBookingDetails['last_min_from_date'][$i] = date('Y-m-d', strtotime($last_booking_from[$i]));
                    $lastBookingDetails['last_min_to_date'][$i] = date('Y-m-d', strtotime($last_booking_to[$i]));
                    $lastBookingDetails['last_min_discount_type'][$i] = $last_minute_booking_type[$i];
                    $lastBookingDetails['last_min_discount_value'][$i] = $last_minute_booking_amount[$i];
                }
            }

            //Early Booking
            if (isset($postData['early_booking_days']) && !empty($postData['early_booking_days'])) {
                $earlyBookingDetails = [];
                $early_booking_days = array_values(array_filter($postData['early_booking_days']));
                $early_booking_from = array_values(array_filter($postData['early_booking_from']));
                $early_booking_to = array_values(array_filter($postData['early_booking_to']));
                $early_booking_type = array_values(array_filter($postData['early_booking_type']));
                $early_booking_amount = array_values(array_filter($postData['early_booking_amount']));
                for ($i = 0; $i < count($early_booking_days); $i++) {
                    $earlyBookingDetails['early_week_days'][$i] = $early_booking_days[$i];
                    $earlyBookingDetails['early_from_date'][$i] = date('Y-m-d', strtotime($early_booking_from[$i]));
                    $earlyBookingDetails['early_to_date'][$i] = date('Y-m-d', strtotime($early_booking_to[$i]));
                    $earlyBookingDetails['early_discount_type'][$i] = $early_booking_type[$i];
                    $earlyBookingDetails['early_discount_value'][$i] = $early_booking_amount[$i];
                }
            }

            //Day Wise Discount
            if (isset($postData['dis_days']) && !empty($postData['dis_days'])) {
                $dayWiseDetails = [];
                $dis_days = array_values(array_filter($postData['dis_days']));
                $day_wise_from = array_values(array_filter($postData['day_wise_from']));
                $day_wise_to = array_values(array_filter($postData['day_wise_to']));
                $day_wise_dis_type = array_values(array_filter($postData['day_wise_dis_type']));
                $day_wise_discount_amount = array_values(array_filter($postData['day_wise_discount_amount']));
                for ($i = 0; $i < count($dis_days); $i++) {
                    $dayWiseDetails['daywise_week_days'][$i] = $dis_days[$i];
                    $dayWiseDetails['daywise_from_date'][$i] = date('Y-m-d', strtotime($day_wise_from[$i]));
                    $dayWiseDetails['daywise_to_date'][$i] = date('Y-m-d', strtotime($day_wise_to[$i]));
                    $dayWiseDetails['daywise_discount_type'][$i] = $day_wise_dis_type[$i];
                    $dayWiseDetails['daywise_discount_value'][$i] = $day_wise_discount_amount[$i];
                }
            }


            //Kids Free Offers
            if (isset($postData['kids_package_name']) && !empty($postData['kids_package_name'])) {
                $kidsBookingDetails = [];
                $kids_package_name = array_values(array_filter($postData['kids_package_name']));
                $kids_rooms = array_values(array_filter($postData['kids_rooms']));
                $kids_nights = array_values(array_filter($postData['kids_nights']));
                $kids_discount_from = array_values(array_filter($postData['kids_discount_from']));
                $kids_discount_to = array_values(array_filter($postData['kids_discount_to']));
                for ($i = 0; $i < count($kids_package_name); $i++) {
                    $kidsBookingDetails['package_name'][$i] = $kids_package_name[$i];
                    $kidsBookingDetails['rooms'][$i] = $kids_rooms[$i];
                    $kidsBookingDetails['nights'][$i] = $kids_nights[$i];
                    $kidsBookingDetails['from_date'][$i] = date('Y-m-d', strtotime($kids_discount_from[$i]));
                    $kidsBookingDetails['to_date'][$i] = date('Y-m-d', strtotime($kids_discount_to[$i]));
                    $kidsBookingDetails['type'][$i] = 'kids';
                }
            }

            //Free Night Offers
            if (isset($postData['night_package_name']) && !empty($postData['night_package_name'])) {
                $nightBookingDetails = [];
                $night_package_name = array_values(array_filter($postData['night_package_name']));
                $night_rooms = array_values(array_filter($postData['night_rooms']));
                $night_nights = array_values(array_filter($postData['night_nights']));
                $night_discount_from = array_values(array_filter($postData['night_discount_from']));
                $night_discount_to = array_values(array_filter($postData['night_discount_to']));
                for ($i = 0; $i < count($night_package_name); $i++) {
                    $nightBookingDetails['package_name'][$i] = $night_package_name[$i];
                    $nightBookingDetails['rooms'][$i] = $night_rooms[$i];
                    $nightBookingDetails['nights'][$i] = $night_nights[$i];
                    $nightBookingDetails['from_date'][$i] = date('Y-m-d', strtotime($night_discount_from[$i]));
                    $nightBookingDetails['to_date'][$i] = date('Y-m-d', strtotime($night_discount_to[$i]));
                    $nightBookingDetails['type'][$i] = 'nights';
                }
            }


            //Free Room Offers
            if (isset($postData['room_package_name']) && !empty($postData['room_package_name'])) {
                $roomBookingDetails = [];
                $room_package_name = array_values(array_filter($postData['room_package_name']));
                $room_rooms = array_values(array_filter($postData['room_rooms']));
                $room_nights = array_values(array_filter($postData['room_nights']));
                $room_discount_from = array_values(array_filter($postData['room_discount_from']));
                $room_discount_to = array_values(array_filter($postData['room_discount_to']));

                for ($i = 0; $i < count($room_package_name); $i++) {
                    $roomBookingDetails['package_name'][$i] = $room_package_name[$i];
                    $roomBookingDetails['rooms'][$i] = $room_rooms[$i];
                    $roomBookingDetails['nights'][$i] = $room_nights[$i];
                    $roomBookingDetails['from_date'][$i] = date('Y-m-d', strtotime($room_discount_from[$i]));
                    $roomBookingDetails['to_date'][$i] = date('Y-m-d', strtotime($room_discount_to[$i]));
                    $roomBookingDetails['type'][$i] = 'rooms';
                }
            }
            
            if (isset($postData['typeofcommission']) && !empty($postData['typeofcommission'])) {
                if($postData['typeofcommission']=="Commissionable Rate"){
                    $comissionType = $postData['commissiontype'];
                    $comissionValue = $postData['commission_value'];                    
                }else{
                    $comissionType = "";
                    $comissionValue = "";
                }
            }
            
          if(isset($postData['service_charge']) && !empty($postData['service_charge'])) {
                if($postData['service_charge']=="Yes"){
                    $serviceChargeType = $postData['service_charge_type'];
                    $serviceChargeValue = $postData['service_charge_value'];                    
                }else{
                    $serviceChargeType = "";
                    $serviceChargeValue = "";
                }
          }
            
            if(isset($postData['tax_charge']) && !empty($postData['tax_charge'])) {
                if($postData['tax_charge']=="Yes"){
                    $taxType = '%';
                    $sgst = $postData['sgst'];
                    $cgst = $postData['cgst'];
                    $igst = $postData['igst'];
                }else{
                    $taxType = "";
                    $sgst = "";
                    $cgst = "";
                    $igst = "";
                }
            }
            
            
       if (isset($postData['discounttypeofcommission']) && !empty($postData['discounttypeofcommission'])) {
                if($postData['discounttypeofcommission']=="Commissionable Rate"){
    $discountcommissiontype = $postData['discountcommissiontype'];
    $discountcomissionValue = $postData['discount_commission_value'];
    if($postData['discount_valid_from']!=""){
    $discountvalidFrom = date('Y-m-d', strtotime($postData['discount_valid_from']));
    }else{
    $discountvalidFrom = date('Y-m-d', strtotime($postData['valid_from']));    
    }
    
    if($postData['discount_valid_to']!=""){
      $discountvalidTo = date('Y-m-d', strtotime($postData['discount_valid_to']));
    }else{
      $discountvalidTo = date('Y-m-d', strtotime($postData['valid_to']));
    }
                }else{
                    $discountcommissiontype = "";
                    $discountcomissionValue = "";
                    $discountvalidFrom = "";
                    $discountvalidTo = "";
                }
            }

            $finalData['room_rate'] = [
                'normal_rate' => 1,
                'hotel_id' => $postData['hotel_id'],
                'room_id' => $postData['room_id'],
                'currency_id' => $postData['currency'],
                'vendor_type' => $postData['vendor_type'],
                'vendor_id' => $postData['vendor_name'],
                'rate_type' => 'Package Rate',
                'rate_type_id' => $rateType,
                'rate_name_id' => $postData['hotel_rate_name'],
                'season_id' => $postData['hotel_rate_season'],
                'week_days' => implode(',', $postData['weekdays']),
                'package_name' => $postData['hotel_package_name'],
                'minimum_nights' => $postData['package_minimum_nights'],
                'valid_from' => date('Y-m-d', strtotime($postData['valid_from'])),
                'valid_to' => date('Y-m-d', strtotime($postData['valid_to'])),
                
                'tax_charge' => $postData['tax_charge'],
                'tax_type' => $taxType,
                'sgst' => $sgst,
                'cgst' => $cgst,
                'igst' => $igst,
                
                'netrate_commissionrate' => $postData['typeofcommission'],
                'commission_rate_type' => $comissionType,
                'commission_rate_value' => $comissionValue,
                
                'service_charge' => $postData['service_charge'],
                'service_charge_type' => $serviceChargeType,
                'service_charge_value' => $serviceChargeValue,
                
        'discount_netrate_commissionrate' => $postData['discounttypeofcommission'],
        'discount_commission_rate_type' => $discountcommissiontype,
        'discount_commission_rate_value' => $discountcomissionValue,
        'discount_valid_from' => $discountvalidFrom,
        'discount_valid_to' => $discountvalidTo,
                
                'description' => $postData['contract_rate_desc'],
                "normal_rate_meal_plan_details" => $normalRateMealPlandetails,
                "normal_rate_extra_meal_details" => $normalRateExtraMealDetails,
                'promotion_plan' => implode(',', $postData['promotion_rate_type']),
                "price_plan_name" => $postData['name_of_price_plan'],
                "stay_more_status" => !empty($stayingdetails) ? $postData['stay_get_mor_dis'] : 0,
                "stay_more_discount_value" => $stayingdetails,
                "last_min_booking_status" => !empty($lastBookingDetails) ? $postData['last_minute_booking'] : 0,
                "last_min_booking_value" => $lastBookingDetails,
                "early_booking_status" => !empty($earlyBookingDetails) ? $postData['early_booking'] : 0,
                "early_booking_value" => $earlyBookingDetails,
                "daywise_discount_status" => !empty($dayWiseDetails) ? $postData['day_wise_discount'] : 0,
                "daywise_discount_value" => $dayWiseDetails,
                "kids_discount_status" => !empty($kidsBookingDetails) ? $postData['kids_mor_dis'] : 0,
                "kids_discount_value" => $kidsBookingDetails,
                "night_discount_status" => !empty($nightBookingDetails) ? $postData['night_mor_dis'] : 0,
                "night_discount_value" => $nightBookingDetails,
                "room_discount_status" => !empty($roomBookingDetails) ? $postData['room_mor_dis'] : 0,
                "room_discount_value" => $roomBookingDetails,
                'user_id' => $userId,
                'ip' => $_SERVER['REMOTE_ADDR'],
                'bkg_type_id' => $this->config()->getConfig()->masterBookingType->hotelId
            ];

            //echo json_encode($finalData); die;
            //echo '<pre>';print_r($finalData); die;
            $responseData = $this->CommonModel->insertHotelRoomRateDetails($finalData);
            //echo '<pre>';print_r($responseData);  die;
            if ($responseData['response']['status'] == 'success') {
                $msg = "Details Updated Successfully!..";
                $this->flashMessenger()->addMessage(array('success' => $msg));
            } else {
                $msg = "Details Could Not Upated!..";
                $this->flashMessenger()->addMessage(array('danger' => $msg));
            }
            $this->redirect()->toRoute('hotel', ['action' => 'room-rate'], ['query' => array('rate_type' => $rateType)]);
            //}
            /* else{
              $msg = $form->getMessages();
              print_r($msg); die;
              } */
        }
        $week_days = $this->userModel->getWeekDaysList();
        $data = [
            'company_id' => $this->config()->getConfig()->company->companyId,
            'rate_type' => 'Package Rate'
        ];
        $packageListing = $this->CommonModel->getHotelRoomRateDetailsList($data);
        $viewModel = new ViewModel([
            'form' => $form,
            'tab' => 'room-rate',
            'packageListing' => $packageListing,
            'week_days' => $week_days,
            'mealPlanList' => $mealPlanList,
            'rateTypeList' => $rateTypeList,
            'rateType' => $rateType
        ]);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 10-JANUARY-2022
     * @description : FUNCTION TO EDIT ROOM RATE DETAILS
     */

    public function editRoomRateAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        $dataVendor = ['booking_type_id' => $this->config()->getConfig()->masterBookingType->hotelId];
        HotelRoomRateForm::$hotel_list = $this->CommonModel->getHotelList($data);
        HotelRoomRateForm::$vendorTypeList = $this->CommonModel->getHotelVendorTypeList($dataVendor);
        HotelRoomRateForm::$currenyList = $this->CommonModel->getCurrencyList();
        HotelRoomRateForm::$mealPlanList = $this->CommonModel->getMealPlanList($data);
        HotelRoomRateForm::$hotelRateTypeList = $this->CommonModel->getHotelRateTypeList($data);
        HotelRoomRateForm::$hotelSeasonNameList = $this->CommonModel->getHotelSeasonNameList($data);
        HotelRoomRateForm::$hotelRateNameList = $this->CommonModel->getHotelRateNameList($data);
        HotelRoomRateForm::$weekDaysList = $this->userModel->getWeekDaysList();
        HotelRoomRateForm::$promotionRateTypeList = $this->CommonModel->getPromotionRateTypeList($data);
        $mealPlanList = $this->CommonModel->getMealPlanListData($data);
        $rateTypeList = $this->CommonModel->getHotelRateTypeListData($data);
        $form = new HotelRoomRateForm();

        $id = $this->params()->fromQuery('id');
        $rateType = $this->params()->fromQuery('rate_type');
        if (!empty($id)) {
            $data = [
                'auto_id' => $id,
                'company_id' => $this->config()->getConfig()->company->companyId,
                'rate_type' => 'Package Rate'
            ];
            $vehicleData = $this->CommonModel->getHotelRoomRateDetailsList($data);
            
            //echo "<pre>";            print_r($vehicleData); die;
            if(empty($vehicleData)){
                 $this->redirect()->toRoute('hotel', 
                         ['action' => 'room-rate'], 
                         ['query' => ['id'=>$id, 'rate_type' => $rateType]]);
            }
            $vehicleData = $vehicleData[0];
            
            $dataRooms = [
                'company_id' => $this->config()->getConfig()->company->companyId,
                'hotel_id' => $vehicleData['hotel_id']
            ];
            $roomList = $this->CommonModel->getHotelRoomList($dataRooms);
            $dataVendorList = [
                'company_id' => $this->config()->getConfig()->company->companyId,
                'user_type_id' => $vehicleData['vendor_type'],
            ];
            //var_dump($dataVendorList); die;
            $vendorUserData = $this->CommonModel->getHotelVendorListData($dataVendorList);
            //var_dump($vendorUserData); die;
            $form->setData($vehicleData);
            $form->getInputFilter()->get('hotel_id')->setRequired(false);
            $form->get('id')->setValue($vehicleData['id']);
            $form->get('hotel_id')->setValue($vehicleData['hotel_id']);
            //$form->get('hotel_id')->setAttribute("disabled", [$vehicleData['hotel_id']]);
            $form->get('hotel_rate_name')->setValue($vehicleData['rate_name_id']);
            $form->get('hotel_rate_season')->setValue($vehicleData['season_id']);
            $form->get('weekdays')->setValue(explode(',', $vehicleData['week_days']));
            $form->get('hotel_package_name')->setValue($vehicleData['package_name']);
            $form->get('package_minimum_nights')->setValue($vehicleData['minimum_nights']);
            $form->get('promotion_rate_type')->setValue(explode(',', $vehicleData['promotion_plan']));
            $form->get('vendor_name')->setValueOptions($vendorUserData);
            $form->get('vendor_name')->setValue($vehicleData['vendor_id']);
            $form->get('room_id')->setValueOptions($roomList);
            $form->get('room_id')->setValue($vehicleData['room_id']);
            $form->get('currency')->setValue($vehicleData['currency_id']);
            $form->get('contract_rate_desc')->setValue($vehicleData['description']);
            $form->get('valid_from')->setValue(date('d-m-Y', strtotime($vehicleData['valid_from'])));
            $form->get('valid_to')->setValue(date('d-m-Y', strtotime($vehicleData['valid_to'])));
            $form->get('name_of_price_plan')->setValue($vehicleData['price_plan_name']);
            $form->get('commission_value')->setValue($vehicleData['commission_rate_value']);
             
             if(!empty($vehicleData['discount_valid_from'])){
              $form->get('discount_valid_from')->setValue(date('d-m-Y', strtotime($vehicleData['discount_valid_from'])));
             }
             
             if(!empty($vehicleData['discount_valid_to'])){
             $form->get('discount_valid_to')->setValue(date('d-m-Y', strtotime($vehicleData['discount_valid_to'])));
             }
             
             $form->get('discount_commission_value')->setValue($vehicleData['discount_commission_rate_value']);
             
            $hotelData = ['bkg_type_id' => $this->config()->getConfig()->masterBookingType->hotelId, 'mapping_id' => $id];
            $hotelRoomExtraMealData = $this->CommonModel->getHotelRoomRateExtraMealList($hotelData);
            if (!empty($hotelRoomExtraMealData)) {
                $form->get('extra_meal_adult_sgl')->setValue($hotelRoomExtraMealData[0]['sgl_ext_adult_breakfast_rate']);
                $form->get('extra_meal_adult_dbl')->setValue($hotelRoomExtraMealData[0]['dbl_ext_adult_lunch_rate']);
                $form->get('extra_meal_adult_tbl')->setValue($hotelRoomExtraMealData[0]['tbl_ext_adult_dinner_rate']);
                $form->get('extra_meal_child_child')->setValue($hotelRoomExtraMealData[0]['child2to12_ext_breakfast_rate']);
                $form->get('extra_meal_child_child1')->setValue($hotelRoomExtraMealData[0]['child12to16_ext_lunch_rate']);
                $form->get('extra_meal_child_extra_bed')->setValue($hotelRoomExtraMealData[0]['extra_with_bed_ext_dinner_rate']);
            }
            $hotelRoomRateData = $this->CommonModel->getHotelRoomRateDataList($hotelData);
            $hotelStayMoreDiscountData = $this->CommonModel->getStayMoreDiscountList($hotelData);
            $hotelLastMinuteDiscountData = $this->CommonModel->getLastMinuteDiscountList($hotelData);
            $hotelEarlyDiscountData = $this->CommonModel->getEarlyDiscountList($hotelData);
            $hotelDayWiseDiscountData = $this->CommonModel->getDayWiseDiscountList($hotelData);
            $hotelKidsData = ['bkg_type_id' => $this->config()->getConfig()->masterBookingType->hotelId, 'mapping_id' => $id, 'type' => 'kids'];
            $hotelKidsDiscountData = $this->CommonModel->getHotelFreeOffersList($hotelKidsData);
            $hotelNightsData = ['bkg_type_id' => $this->config()->getConfig()->masterBookingType->hotelId, 'mapping_id' => $id, 'type' => 'nights'];
            $hotelNightsDiscountData = $this->CommonModel->getHotelFreeOffersList($hotelNightsData);
            $hotelRoomsData = ['bkg_type_id' => $this->config()->getConfig()->masterBookingType->hotelId, 'mapping_id' => $id, 'type' => 'rooms'];
            $hotelRoomDiscountData = $this->CommonModel->getHotelFreeOffersList($hotelRoomsData);
            $hotelTaxData = $this->CommonModel->getHotelBasicTax($hotelData);

            //echo "<pre>"; print_r($hotelLastMinuteDiscountData);die;
            //var_dump($hotelRoomRateData);die;
        }
        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            //echo '<pre>';print_r($postData);//die();
            $form->setData($postData);


            //echo "Mohit";
            //echo "<pre>";print_r($normalRateMealPlandetails); die;
            //if ($form->isValid()) {
            $stayingdetails = "";
            $lastBookingDetails = "";
            $earlyBookingDetails = "";
            $dayWiseDetails = "";
            $kidsBookingDetails = "";
            $nightBookingDetails = "";
            $roomBookingDetails = "";
            $finalData = [];
            $normalRateMealPlandetails = [];
            $normalRateExtraMealDetails = [];
            if (isset($postData['meal_plan_id']) && !empty($postData['meal_plan_id'])) {
                $meal_plan_id = array_values($postData['meal_plan_id']);
                for ($i = 0; $i < count($meal_plan_id); $i++) {
                    $mealPlanName = $this->CommonModel->getMealPlanTypeName($meal_plan_id[$i]);
                    $normalRateMealPlandetails['meal_plan_type_id'][$i] = $meal_plan_id[$i];
                    $normalRateMealPlandetails['sgl_rate'][$i] = $postData['sgl_rate_' . $mealPlanName];
                    $normalRateMealPlandetails['dbl_rate'][$i] = $postData['dbl_rate_' . $mealPlanName];
                    $normalRateMealPlandetails['tbl_rate'][$i] = $postData['tbl_rate_' . $mealPlanName];
                    $normalRateMealPlandetails['child_rate'][$i] = $postData['child_rate_' . $mealPlanName];
                    $normalRateMealPlandetails['child1_rate'][$i] = $postData['child1_rate_' . $mealPlanName];
                    $normalRateMealPlandetails['extra_bed_rate'][$i] = $postData['extra_bed_rate_' . $mealPlanName];
                }
            }
            if (isset($postData['extra_meal_adult_sgl']) && !empty($postData['extra_meal_adult_sgl'])) {
                $normalRateExtraMealDetails['sgl_ext_adult_breakfast_rate'] = $postData['extra_meal_adult_sgl'];
                $normalRateExtraMealDetails['dbl_ext_adult_lunch_rate'] = $postData['extra_meal_adult_dbl'];
                $normalRateExtraMealDetails['tbl_ext_adult_dinner_rate'] = $postData['extra_meal_adult_tbl'];
                $normalRateExtraMealDetails['child2to12_ext_breakfast_rate'] = $postData['extra_meal_child_child'];
                $normalRateExtraMealDetails['child12to16_ext_lunch_rate'] = $postData['extra_meal_child_child1'];
                $normalRateExtraMealDetails['extra_with_bed_ext_dinner_rate'] = $postData['extra_meal_child_child1'];
            }

            //Stay More Get More Discount


            if (isset($postData['staying_days']) && !empty($postData['staying_days'])) {
                $stayingdetails = [];
                $staying_days = array_values(array_filter($postData['staying_days']));
                $more_discount_from = array_values(array_filter($postData['more_discount_from']));
                $more_discount_to = array_values(array_filter($postData['more_discount_to']));
                $stay_more_discount_type = array_values(array_filter($postData['stay_more_discount_type']));
                $staying_amount = array_values(array_filter($postData['staying_amount']));
                for ($i = 0; $i < count($staying_days); $i++) {
                    $stayingdetails['stay_more_week_days'][$i] = $staying_days[$i];
                    $stayingdetails['stay_more_from_date'][$i] = date('Y-m-d', strtotime($more_discount_from[$i]));
                    $stayingdetails['stay_more_to_date'][$i] = date('Y-m-d', strtotime($more_discount_to[$i]));
                    $stayingdetails['stay_more_type'][$i] = $stay_more_discount_type[$i];
                    $stayingdetails['stay_more_value'][$i] = $staying_amount[$i];
                }
            }


            //Last Minute Booking
            if (isset($postData['last_minute_booking_hour']) && !empty($postData['last_minute_booking_hour'])) {
                $lastBookingDetails = [];
                $last_minute_booking_hour = array_values(array_filter($postData['last_minute_booking_hour']));
                $last_booking_from = array_values(array_filter($postData['last_booking_from']));
                $last_booking_to = array_values(array_filter($postData['last_booking_to']));
                $last_minute_booking_type = array_values(array_filter($postData['last_minute_booking_type']));
                $last_minute_booking_amount = array_values(array_filter($postData['last_minute_booking_amount']));
                for ($i = 0; $i < count($last_minute_booking_hour); $i++) {
                    $lastBookingDetails['last_min_hour'][$i] = $last_minute_booking_hour[$i];
                    $lastBookingDetails['last_min_from_date'][$i] = date('Y-m-d', strtotime($last_booking_from[$i]));
                    $lastBookingDetails['last_min_to_date'][$i] = date('Y-m-d', strtotime($last_booking_to[$i]));
                    $lastBookingDetails['last_min_discount_type'][$i] = $last_minute_booking_type[$i];
                    $lastBookingDetails['last_min_discount_value'][$i] = $last_minute_booking_amount[$i];
                }
            }

            //Early Booking
            if (isset($postData['early_booking_days']) && !empty($postData['early_booking_days'])) {
                $earlyBookingDetails = [];
                $early_booking_days = array_values(array_filter($postData['early_booking_days']));
                $early_booking_from = array_values(array_filter($postData['early_booking_from']));
                $early_booking_to = array_values(array_filter($postData['early_booking_to']));
                $early_booking_type = array_values(array_filter($postData['early_booking_type']));
                $early_booking_amount = array_values(array_filter($postData['early_booking_amount']));
                for ($i = 0; $i < count($early_booking_days); $i++) {
                    $earlyBookingDetails['early_week_days'][$i] = $early_booking_days[$i];
                    $earlyBookingDetails['early_from_date'][$i] = date('Y-m-d', strtotime($early_booking_from[$i]));
                    $earlyBookingDetails['early_to_date'][$i] = date('Y-m-d', strtotime($early_booking_to[$i]));
                    $earlyBookingDetails['early_discount_type'][$i] = $early_booking_type[$i];
                    $earlyBookingDetails['early_discount_value'][$i] = $early_booking_amount[$i];
                }
            }

            //Day Wise Discount
            if (isset($postData['dis_days']) && !empty($postData['dis_days'])) {
                $dayWiseDetails = [];
                $dis_days = array_values(array_filter($postData['dis_days']));
                $day_wise_from = array_values(array_filter($postData['day_wise_from']));
                $day_wise_to = array_values(array_filter($postData['day_wise_to']));
                $day_wise_dis_type = array_values(array_filter($postData['day_wise_dis_type']));
                $day_wise_discount_amount = array_values(array_filter($postData['day_wise_discount_amount']));
                for ($i = 0; $i < count($dis_days); $i++) {
                    $dayWiseDetails['daywise_week_days'][$i] = $dis_days[$i];
                    $dayWiseDetails['daywise_from_date'][$i] = date('Y-m-d', strtotime($day_wise_from[$i]));
                    $dayWiseDetails['daywise_to_date'][$i] = date('Y-m-d', strtotime($day_wise_to[$i]));
                    $dayWiseDetails['daywise_discount_type'][$i] = $day_wise_dis_type[$i];
                    $dayWiseDetails['daywise_discount_value'][$i] = $day_wise_discount_amount[$i];
                }
            }


            //Kids Free Offers
            if (isset($postData['kids_package_name']) && !empty($postData['kids_package_name'])) {
                $kidsBookingDetails = [];
                $kids_package_name = array_values(array_filter($postData['kids_package_name']));
                $kids_rooms = array_values(array_filter($postData['kids_rooms']));
                $kids_nights = array_values(array_filter($postData['kids_nights']));
                $kids_discount_from = array_values(array_filter($postData['kids_discount_from']));
                $kids_discount_to = array_values(array_filter($postData['kids_discount_to']));
                for ($i = 0; $i < count($kids_package_name); $i++) {
                    $kidsBookingDetails['package_name'][$i] = $kids_package_name[$i];
                    $kidsBookingDetails['rooms'][$i] = $kids_rooms[$i];
                    $kidsBookingDetails['nights'][$i] = $kids_nights[$i];
                    $kidsBookingDetails['from_date'][$i] = date('Y-m-d', strtotime($kids_discount_from[$i]));
                    $kidsBookingDetails['to_date'][$i] = date('Y-m-d', strtotime($kids_discount_to[$i]));
                    $kidsBookingDetails['type'][$i] = 'kids';
                }
            }

            //Free Night Offers
            if (isset($postData['night_package_name']) && !empty($postData['night_package_name'])) {
                $nightBookingDetails = [];
                $night_package_name = array_values(array_filter($postData['night_package_name']));
                $night_rooms = array_values(array_filter($postData['night_rooms']));
                $night_nights = array_values(array_filter($postData['night_nights']));
                $night_discount_from = array_values(array_filter($postData['night_discount_from']));
                $night_discount_to = array_values(array_filter($postData['night_discount_to']));
                for ($i = 0; $i < count($night_package_name); $i++) {
                    $nightBookingDetails['package_name'][$i] = $night_package_name[$i];
                    $nightBookingDetails['rooms'][$i] = $night_rooms[$i];
                    $nightBookingDetails['nights'][$i] = $night_nights[$i];
                    $nightBookingDetails['from_date'][$i] = date('Y-m-d', strtotime($night_discount_from[$i]));
                    $nightBookingDetails['to_date'][$i] = date('Y-m-d', strtotime($night_discount_to[$i]));
                    $nightBookingDetails['type'][$i] = 'nights';
                }
            }


            //Free Room Offers
            if (isset($postData['room_package_name']) && !empty($postData['room_package_name'])) {
                $roomBookingDetails = [];
                $room_package_name = array_values(array_filter($postData['room_package_name']));
                $room_rooms = array_values(array_filter($postData['room_rooms']));
                $room_nights = array_values(array_filter($postData['room_nights']));
                $room_discount_from = array_values(array_filter($postData['room_discount_from']));
                $room_discount_to = array_values(array_filter($postData['room_discount_to']));

                for ($i = 0; $i < count($room_package_name); $i++) {
                    $roomBookingDetails['package_name'][$i] = $room_package_name[$i];
                    $roomBookingDetails['rooms'][$i] = $room_rooms[$i];
                    $roomBookingDetails['nights'][$i] = $room_nights[$i];
                    $roomBookingDetails['from_date'][$i] = date('Y-m-d', strtotime($room_discount_from[$i]));
                    $roomBookingDetails['to_date'][$i] = date('Y-m-d', strtotime($room_discount_to[$i]));
                    $roomBookingDetails['type'][$i] = 'rooms';
                }
            }
            
            if (isset($postData['typeofcommission']) && !empty($postData['typeofcommission'])) {
                if($postData['typeofcommission']=="Commissionable Rate"){
                    $comissionType = $postData['commissiontype'];
                    $comissionValue = $postData['commission_value'];                    
                }else{
                    $comissionType = "";
                    $comissionValue = "";
                }
            }
            
            
        if(isset($postData['service_charge']) && !empty($postData['service_charge'])) {
            if($postData['service_charge']=="Yes"){
                $serviceChargeType = $postData['service_charge_type'];
                $serviceChargeValue = $postData['service_charge_value'];                    
            }else{
                $serviceChargeType = "";
                $serviceChargeValue = "";
            }
        }
            
        if(isset($postData['tax_charge']) && !empty($postData['tax_charge'])) {
            if($postData['tax_charge']=="Yes"){
                $taxType = '%';
                $sgst = $postData['sgst'];
                $cgst = $postData['cgst'];
                $igst = $postData['igst'];
            }else{
                $taxType = "";
                $sgst = "";
                $cgst = "";
                $igst = "";
            }
        }
        
        if (isset($postData['discounttypeofcommission']) && !empty($postData['discounttypeofcommission'])) {
                if($postData['discounttypeofcommission']=="Commissionable Rate"){
    $discountcommissiontype = $postData['discountcommissiontype'];
    $discountcomissionValue = $postData['discount_commission_value'];
    if($postData['discount_valid_from']!=""){
    $discountvalidFrom = date('Y-m-d', strtotime($postData['discount_valid_from']));
    }else{
    $discountvalidFrom = date('Y-m-d', strtotime($postData['valid_from']));    
    }
    
    if($postData['discount_valid_to']!=""){
      $discountvalidTo = date('Y-m-d', strtotime($postData['discount_valid_to']));
    }else{
      $discountvalidTo = date('Y-m-d', strtotime($postData['valid_to']));
    }
                }else{
                    $discountcommissiontype = "";
                    $discountcomissionValue = "";
                    $discountvalidFrom = "";
                    $discountvalidTo = "";
                }
            }
            


            $finalData['room_rate'] = [
                'normal_rate' => 1,
                'hotel_id' => $postData['hotel_id'],
                'room_id' => $postData['room_id'],
                'currency_id' => $postData['currency'],
                'vendor_type' => $postData['vendor_type'],
                'vendor_id' => $postData['vendor_name'],
                'rate_type' => 'Package Rate',
                'rate_type_id' => $rateType,
                'rate_name_id' => $postData['hotel_rate_name'],
                'season_id' => $postData['hotel_rate_season'],
                'week_days' => implode(',', $postData['weekdays']),
                'package_name' => $postData['hotel_package_name'],
                'minimum_nights' => $postData['package_minimum_nights'],
                'valid_from' => date('Y-m-d', strtotime($postData['valid_from'])),
                'valid_to' => date('Y-m-d', strtotime($postData['valid_to'])),
                
                'netrate_commissionrate' => $postData['typeofcommission'],
                'commission_rate_type' => $comissionType,
                'commission_rate_value' => $comissionValue,
                
                'service_charge' => $postData['service_charge'],
                'service_charge_type' => $serviceChargeType,
                'service_charge_value' => $serviceChargeValue,
                
    'discount_netrate_commissionrate' => $postData['discounttypeofcommission'],
    'discount_commission_rate_type' => $discountcommissiontype,
    'discount_commission_rate_value' => $discountcomissionValue,
    'discount_valid_from' => $discountvalidFrom,
    'discount_valid_to' => $discountvalidTo,
                
                
                'tax_charge' => $postData['tax_charge'],
                'tax_type' => $taxType,
                'sgst' => $sgst,
                'cgst' => $cgst,
                'igst' => $igst,
                
                'description' => $postData['contract_rate_desc'],
                "normal_rate_meal_plan_details" => $normalRateMealPlandetails,
                "normal_rate_extra_meal_details" => $normalRateExtraMealDetails,
                'promotion_plan' => implode(',', $postData['promotion_rate_type']),
                "price_plan_name" => $postData['name_of_price_plan'],
                "stay_more_status" => !empty($stayingdetails) ? $postData['stay_get_mor_dis'] : 0,
                "stay_more_discount_value" => $stayingdetails,
                "last_min_booking_status" => !empty($lastBookingDetails) ? $postData['last_minute_booking'] : 0,
                "last_min_booking_value" => $lastBookingDetails,
                "early_booking_status" => !empty($earlyBookingDetails) ? $postData['early_booking'] : 0,
                "early_booking_value" => $earlyBookingDetails,
                "daywise_discount_status" => !empty($dayWiseDetails) ? $postData['day_wise_discount'] : 0,
                "daywise_discount_value" => $dayWiseDetails,
                "kids_discount_status" => !empty($kidsBookingDetails) ? $postData['kids_mor_dis'] : 0,
                "kids_discount_value" => $kidsBookingDetails,
                "night_discount_status" => !empty($nightBookingDetails) ? $postData['night_mor_dis'] : 0,
                "night_discount_value" => $nightBookingDetails,
                "room_discount_status" => !empty($roomBookingDetails) ? $postData['room_mor_dis'] : 0,
                "room_discount_value" => $roomBookingDetails,
            'user_id' => $userId,
            'ip' => $_SERVER['REMOTE_ADDR'],
            'bkg_type_id' => $this->config()->getConfig()->masterBookingType->hotelId,
            'auto_id' => $postData['id']
            ];

            //echo json_encode($finalData); die;
            //echo '<pre>';print_r($finalData); die;
            $responseData = $this->CommonModel->updateHotelRoomRateDetails($finalData);
            //echo '<pre>';print_r($responseData);  die;
            if ($responseData['response']['status'] == 'success') {
                $msg = "Details Updated Successfully!..";
                $this->flashMessenger()->addMessage(array('success' => $msg));
            } else {
                $msg = "Details Could Not Upated!..";
                $this->flashMessenger()->addMessage(array('danger' => $msg));
            }
            $this->redirect()->toRoute('hotel', ['action' => 'room-rate']);
            //}
            /* else{
              $msg = $form->getMessages();
              print_r($msg); die;
              } */
        }
        $week_days = $this->userModel->getWeekDaysList();
        $data = [
            'company_id' => $this->config()->getConfig()->company->companyId,
            'rate_type' => 'Package Rate'
        ];
        $packageListing = $this->CommonModel->getHotelRoomRateDetailsList($data);
        $viewModel = new ViewModel([
            'form' => $form,
            'tab' => 'room-rate',
            'packageListing' => $packageListing,
            'week_days' => $week_days,
            'mealPlanList' => $mealPlanList,
            'vehicleData' => $vehicleData,
            'hotelRoomRateData' => $hotelRoomRateData,
            'hotelStayMoreDiscountData' => $hotelStayMoreDiscountData,
            'hotelLastMinuteDiscountData' => $hotelLastMinuteDiscountData,
            'hotelEarlyDiscountData' => $hotelEarlyDiscountData,
            'hotelDayWiseDiscountData' => $hotelDayWiseDiscountData,
            'hotelKidsDiscountData' => $hotelKidsDiscountData,
            'hotelNightsDiscountData' => $hotelNightsDiscountData,
            'hotelRoomDiscountData' => $hotelRoomDiscountData,
            'hotelTaxData' => $hotelTaxData,
            'rateTypeList' => $rateTypeList,
            'rateType' => $rateType
        ]);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 10-JANUARY-2022
     * @description : FUNCTION TO ADD NORMAL ROOM RATE DETAILS
     */

    public function normalRoomRateAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        $dataVendor = ['booking_type_id' => $this->config()->getConfig()->masterBookingType->hotelId];
        HotelRoomRateForm::$hotel_list = $this->CommonModel->getHotelList($data);
        HotelRoomRateForm::$vendorTypeList = $this->CommonModel->getHotelVendorTypeList($dataVendor);
        HotelRoomRateForm::$currenyList = $this->CommonModel->getCurrencyList();
        HotelRoomRateForm::$mealPlanList = $this->CommonModel->getMealPlanList($data);
        HotelRoomRateForm::$hotelRateTypeList = $this->CommonModel->getHotelRateTypeList($data);
        HotelRoomRateForm::$hotelSeasonNameList = $this->CommonModel->getHotelSeasonNameList($data);
        HotelRoomRateForm::$hotelRateNameList = $this->CommonModel->getHotelRateNameList($data);
        HotelRoomRateForm::$weekDaysList = $this->userModel->getWeekDaysList();
        HotelRoomRateForm::$promotionRateTypeList = $this->CommonModel->getPromotionRateTypeList($data);
        $mealPlanList = $this->CommonModel->getMealPlanListData($data);
        $form = new HotelRoomRateForm();
        $id = $this->params()->fromQuery('id');
        if (!empty($id)) {
             $form->get('hotel_id')->setValue($id);
        }
        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();           
            $form->setData($postData);
            //echo "<pre>";print_r($normalRateMealPlandetails); die;
            //if ($form->isValid()) {
            $stayingdetails = "";
            $lastBookingDetails = "";
            $earlyBookingDetails = "";
            $dayWiseDetails = "";
            $kidsBookingDetails = "";
            $nightBookingDetails = "";
            $roomBookingDetails = "";
            $finalData = [];
            $normalRateMealPlandetails = [];
            $normalRateExtraMealDetails = [];
            if (isset($postData['meal_plan_id']) && !empty($postData['meal_plan_id'])) {
                $meal_plan_id = array_values($postData['meal_plan_id']);
                for ($i = 0; $i < count($meal_plan_id); $i++) {
                    $mealPlanName = $this->CommonModel->getMealPlanTypeName($meal_plan_id[$i]);
                    $normalRateMealPlandetails['meal_plan_type_id'][$i] = $meal_plan_id[$i];
                    $normalRateMealPlandetails['sgl_rate'][$i] = $postData['sgl_rate_' . $mealPlanName];
                    $normalRateMealPlandetails['dbl_rate'][$i] = $postData['dbl_rate_' . $mealPlanName];
                    $normalRateMealPlandetails['tbl_rate'][$i] = $postData['tbl_rate_' . $mealPlanName];
                    $normalRateMealPlandetails['child_rate'][$i] = $postData['child_rate_' . $mealPlanName];
                    $normalRateMealPlandetails['child1_rate'][$i] = $postData['child1_rate_' . $mealPlanName];
                    $normalRateMealPlandetails['extra_bed_rate'][$i] = $postData['extra_bed_rate_' . $mealPlanName];
                }
            }
            if (isset($postData['extra_meal_adult_sgl']) && !empty($postData['extra_meal_adult_sgl'])) {
                $normalRateExtraMealDetails['sgl_ext_adult_breakfast_rate'] = $postData['extra_meal_adult_sgl'];
                $normalRateExtraMealDetails['dbl_ext_adult_lunch_rate'] = $postData['extra_meal_adult_dbl'];
                $normalRateExtraMealDetails['tbl_ext_adult_dinner_rate'] = $postData['extra_meal_adult_tbl'];
                $normalRateExtraMealDetails['child2to12_ext_breakfast_rate'] = $postData['extra_meal_child_child'];
                $normalRateExtraMealDetails['child12to16_ext_lunch_rate'] = $postData['extra_meal_child_child1'];
                $normalRateExtraMealDetails['extra_with_bed_ext_dinner_rate'] = $postData['extra_meal_child_child1'];
            }

            //Stay More Get More Discount


            if (isset($postData['staying_days']) && !empty($postData['staying_days'])) {
                $stayingdetails = [];
                $staying_days = array_values(array_filter($postData['staying_days']));
                $more_discount_from = array_values(array_filter($postData['more_discount_from']));
                $more_discount_to = array_values(array_filter($postData['more_discount_to']));
                $stay_more_discount_type = array_values(array_filter($postData['stay_more_discount_type']));
                $staying_amount = array_values(array_filter($postData['staying_amount']));
                for ($i = 0; $i < count($staying_days); $i++) {
                    $stayingdetails['stay_more_week_days'][$i] = $staying_days[$i];
                    $stayingdetails['stay_more_from_date'][$i] = date('Y-m-d', strtotime($more_discount_from[$i]));
                    $stayingdetails['stay_more_to_date'][$i] = date('Y-m-d', strtotime($more_discount_to[$i]));
                    $stayingdetails['stay_more_type'][$i] = $stay_more_discount_type[$i];
                    $stayingdetails['stay_more_value'][$i] = $staying_amount[$i];
                }
            }


            //Last Minute Booking
            if (isset($postData['last_minute_booking_hour']) && !empty($postData['last_minute_booking_hour'])) {
                $lastBookingDetails = [];
                $last_minute_booking_hour = array_values(array_filter($postData['last_minute_booking_hour']));
                $last_booking_from = array_values(array_filter($postData['last_booking_from']));
                $last_booking_to = array_values(array_filter($postData['last_booking_to']));
                $last_minute_booking_type = array_values(array_filter($postData['last_minute_booking_type']));
                $last_minute_booking_amount = array_values(array_filter($postData['last_minute_booking_amount']));
                for ($i = 0; $i < count($last_minute_booking_hour); $i++) {
                    $lastBookingDetails['last_min_hour'][$i] = $last_minute_booking_hour[$i];
                    $lastBookingDetails['last_min_from_date'][$i] = date('Y-m-d', strtotime($last_booking_from[$i]));
                    $lastBookingDetails['last_min_to_date'][$i] = date('Y-m-d', strtotime($last_booking_to[$i]));
                    $lastBookingDetails['last_min_discount_type'][$i] = $last_minute_booking_type[$i];
                    $lastBookingDetails['last_min_discount_value'][$i] = $last_minute_booking_amount[$i];
                }
            }

            //Early Booking
            if (isset($postData['early_booking_days']) && !empty($postData['early_booking_days'])) {
                $earlyBookingDetails = [];
                $early_booking_days = array_values(array_filter($postData['early_booking_days']));
                $early_booking_from = array_values(array_filter($postData['early_booking_from']));
                $early_booking_to = array_values(array_filter($postData['early_booking_to']));
                $early_booking_type = array_values(array_filter($postData['early_booking_type']));
                $early_booking_amount = array_values(array_filter($postData['early_booking_amount']));
                for ($i = 0; $i < count($early_booking_days); $i++) {
                    $earlyBookingDetails['early_week_days'][$i] = $early_booking_days[$i];
                    $earlyBookingDetails['early_from_date'][$i] = date('Y-m-d', strtotime($early_booking_from[$i]));
                    $earlyBookingDetails['early_to_date'][$i] = date('Y-m-d', strtotime($early_booking_to[$i]));
                    $earlyBookingDetails['early_discount_type'][$i] = $early_booking_type[$i];
                    $earlyBookingDetails['early_discount_value'][$i] = $early_booking_amount[$i];
                }
            }

            //Day Wise Discount
            if (isset($postData['dis_days']) && !empty($postData['dis_days'])) {
                $dayWiseDetails = [];
                $dis_days = array_values(array_filter($postData['dis_days']));
                $day_wise_from = array_values(array_filter($postData['day_wise_from']));
                $day_wise_to = array_values(array_filter($postData['day_wise_to']));
                $day_wise_dis_type = array_values(array_filter($postData['day_wise_dis_type']));
                $day_wise_discount_amount = array_values(array_filter($postData['day_wise_discount_amount']));
                for ($i = 0; $i < count($dis_days); $i++) {
                    $dayWiseDetails['daywise_week_days'][$i] = $dis_days[$i];
                    $dayWiseDetails['daywise_from_date'][$i] = date('Y-m-d', strtotime($day_wise_from[$i]));
                    $dayWiseDetails['daywise_to_date'][$i] = date('Y-m-d', strtotime($day_wise_to[$i]));
                    $dayWiseDetails['daywise_discount_type'][$i] = $day_wise_dis_type[$i];
                    $dayWiseDetails['daywise_discount_value'][$i] = $day_wise_discount_amount[$i];
                }
            }


            //Kids Free Offers
            if (isset($postData['kids_package_name']) && !empty($postData['kids_package_name'])) {
                $kidsBookingDetails = [];
                $kids_package_name = array_values(array_filter($postData['kids_package_name']));
                $kids_rooms = array_values(array_filter($postData['kids_rooms']));
                $kids_nights = array_values(array_filter($postData['kids_nights']));
                $kids_discount_from = array_values(array_filter($postData['kids_discount_from']));
                $kids_discount_to = array_values(array_filter($postData['kids_discount_to']));
                for ($i = 0; $i < count($kids_package_name); $i++) {
                    $kidsBookingDetails['package_name'][$i] = $kids_package_name[$i];
                    $kidsBookingDetails['rooms'][$i] = $kids_rooms[$i];
                    $kidsBookingDetails['nights'][$i] = $kids_nights[$i];
                    $kidsBookingDetails['from_date'][$i] = date('Y-m-d', strtotime($kids_discount_from[$i]));
                    $kidsBookingDetails['to_date'][$i] = date('Y-m-d', strtotime($kids_discount_to[$i]));
                    $kidsBookingDetails['type'][$i] = 'kids';
                }
            }

            //Free Night Offers
            if (isset($postData['night_package_name']) && !empty($postData['night_package_name'])) {
                $nightBookingDetails = [];
                $night_package_name = array_values(array_filter($postData['night_package_name']));
                $night_rooms = array_values(array_filter($postData['night_rooms']));
                $night_nights = array_values(array_filter($postData['night_nights']));
                $night_discount_from = array_values(array_filter($postData['night_discount_from']));
                $night_discount_to = array_values(array_filter($postData['night_discount_to']));
                for ($i = 0; $i < count($night_package_name); $i++) {
                    $nightBookingDetails['package_name'][$i] = $night_package_name[$i];
                    $nightBookingDetails['rooms'][$i] = $night_rooms[$i];
                    $nightBookingDetails['nights'][$i] = $night_nights[$i];
                    $nightBookingDetails['from_date'][$i] = date('Y-m-d', strtotime($night_discount_from[$i]));
                    $nightBookingDetails['to_date'][$i] = date('Y-m-d', strtotime($night_discount_to[$i]));
                    $nightBookingDetails['type'][$i] = 'nights';
                }
            }


            //Free Room Offers
            if (isset($postData['room_package_name']) && !empty($postData['room_package_name'])) {
                $roomBookingDetails = [];
                $room_package_name = array_values(array_filter($postData['room_package_name']));
                $room_rooms = array_values(array_filter($postData['room_rooms']));
                $room_nights = array_values(array_filter($postData['room_nights']));
                $room_discount_from = array_values(array_filter($postData['room_discount_from']));
                $room_discount_to = array_values(array_filter($postData['room_discount_to']));

                for ($i = 0; $i < count($room_package_name); $i++) {
                    $roomBookingDetails['package_name'][$i] = $room_package_name[$i];
                    $roomBookingDetails['rooms'][$i] = $room_rooms[$i];
                    $roomBookingDetails['nights'][$i] = $room_nights[$i];
                    $roomBookingDetails['from_date'][$i] = date('Y-m-d', strtotime($room_discount_from[$i]));
                    $roomBookingDetails['to_date'][$i] = date('Y-m-d', strtotime($room_discount_to[$i]));
                    $roomBookingDetails['type'][$i] = 'rooms';
                }
            }
            
            if (isset($postData['typeofcommission']) && !empty($postData['typeofcommission'])) {
                if($postData['typeofcommission']=="Commissionable Rate"){
                    $comissionType = $postData['commissiontype'];
                    $comissionValue = $postData['commission_value'];                    
                }else{
                    $comissionType = "";
                    $comissionValue = "";
                }
            }
            
            if (isset($postData['service_charge']) && !empty($postData['service_charge'])) {
                if($postData['service_charge']=="Yes"){
                    $serviceChargeType = $postData['service_charge_type'];
                    $serviceChargeValue = $postData['service_charge_value'];                    
                }else{
                    $serviceChargeType = "";
                    $serviceChargeValue = "";
                }
            }
            
            if(isset($postData['tax_charge']) && !empty($postData['tax_charge'])) {
                if($postData['tax_charge']=="Yes"){
                    $taxType = '%';
                    $sgst = $postData['sgst'];
                    $cgst = $postData['cgst'];
                    $igst = $postData['igst'];
                }else{
                    $taxType = "";
                    $sgst = "";
                    $cgst = "";
                    $igst = "";
                }
            }
            
            if (isset($postData['discounttypeofcommission']) && !empty($postData['discounttypeofcommission'])) {
                if($postData['discounttypeofcommission']=="Commissionable Rate"){
    $discountcommissiontype = $postData['discountcommissiontype'];
    $discountcomissionValue = $postData['discount_commission_value'];
    if($postData['discount_valid_from']!=""){
    $discountvalidFrom = date('Y-m-d', strtotime($postData['discount_valid_from']));
    }else{
    $discountvalidFrom = date('Y-m-d', strtotime($postData['valid_from']));    
    }
    
    if($postData['discount_valid_to']!=""){
      $discountvalidTo = date('Y-m-d', strtotime($postData['discount_valid_to']));
    }else{
      $discountvalidTo = date('Y-m-d', strtotime($postData['valid_to']));
    }
                }else{
                    $discountcommissiontype = "";
                    $discountcomissionValue = "";
                    $discountvalidFrom = "";
                    $discountvalidTo = "";
                }
            }

            $finalData['room_rate'] = [
                'normal_rate' => 1,
                'hotel_id' => $postData['hotel_id'],
                'room_id' => $postData['room_id'],
                'currency_id' => $postData['currency'],
                'vendor_type' => $postData['vendor_type'],
                'vendor_id' => $postData['vendor_name'],
                'rate_type' => 'Normal Rate',
                'rate_name_id' => $postData['hotel_rate_name'],
                'season_id' => $postData['hotel_rate_season'],
                'week_days' => implode(',', $postData['weekdays']),
                'valid_from' => date('Y-m-d', strtotime($postData['valid_from'])),
                'valid_to' => date('Y-m-d', strtotime($postData['valid_to'])),
                
                'tax_charge' => $postData['tax_charge'],
                'tax_type' => $taxType,
                'sgst' => $sgst,
                'cgst' => $cgst,
                'igst' => $igst,
                
                'netrate_commissionrate' => $postData['typeofcommission'],
                'commission_rate_type' => $comissionType,
                'commission_rate_value' => $comissionValue,
                
                'service_charge' => $postData['service_charge'],
                'service_charge_type' => $serviceChargeType,
                'service_charge_value' => $serviceChargeValue,
                
        'discount_netrate_commissionrate' => $postData['discounttypeofcommission'],
        'discount_commission_rate_type' => $discountcommissiontype,
        'discount_commission_rate_value' => $discountcomissionValue,
        'discount_valid_from' => $discountvalidFrom,
        'discount_valid_to' => $discountvalidTo,
                
                'description' => $postData['contract_rate_desc'],
                "normal_rate_meal_plan_details" => $normalRateMealPlandetails,
                "normal_rate_extra_meal_details" => $normalRateExtraMealDetails,
                'promotion_plan' => implode(',', $postData['promotion_rate_type']),
                "price_plan_name" => $postData['name_of_price_plan'],
                "stay_more_status" => !empty($stayingdetails) ? $postData['stay_get_mor_dis'] : 0,
                "stay_more_discount_value" => $stayingdetails,
                "last_min_booking_status" => !empty($lastBookingDetails) ? $postData['last_minute_booking'] : 0,
                "last_min_booking_value" => $lastBookingDetails,
                "early_booking_status" => !empty($earlyBookingDetails) ? $postData['early_booking'] : 0,
                "early_booking_value" => $earlyBookingDetails,
                "daywise_discount_status" => !empty($dayWiseDetails) ? $postData['day_wise_discount'] : 0,
                "daywise_discount_value" => $dayWiseDetails,
                "kids_discount_status" => !empty($kidsBookingDetails) ? $postData['kids_mor_dis'] : 0,
                "kids_discount_value" => $kidsBookingDetails,
                "night_discount_status" => !empty($nightBookingDetails) ? $postData['night_mor_dis'] : 0,
                "night_discount_value" => $nightBookingDetails,
                "room_discount_status" => !empty($roomBookingDetails) ? $postData['room_mor_dis'] : 0,
                "room_discount_value" => $roomBookingDetails,
                'user_id' => $userId,
                'ip' => $_SERVER['REMOTE_ADDR'],               
                'bkg_type_id' => $this->config()->getConfig()->masterBookingType->hotelId
            ];

            //echo json_encode($finalData); die;
            //echo '<pre>';print_r($finalData); //die;
            $responseData = $this->CommonModel->insertHotelRoomRateDetails($finalData);
            //echo '<pre>';print_r($responseData);  die;
            if ($responseData['response']['status'] == 'success') {
                $msg = "Details Updated Successfully!..";
                $this->flashMessenger()->addMessage(array('success' => $msg));
            } else {
                $msg = "Details Could Not Upated!..";
                $this->flashMessenger()->addMessage(array('danger' => $msg));
            }
            $this->redirect()->toRoute('hotel', ['action' => 'normal-room-rate']);
            //}
            /* else{
              $msg = $form->getMessages();
              print_r($msg); die;
              } */
        }
        $week_days = $this->userModel->getWeekDaysList();
        $data = [
            'company_id' => $this->config()->getConfig()->company->companyId,
            'rate_type' => 'Normal Rate'
        ];
        $packageListing = $this->CommonModel->getHotelRoomRateDetailsList($data);
        $viewModel = new ViewModel([
            'form' => $form,
            'tab' => 'normal-room-rate',
            'packageListing' => $packageListing,
            'week_days' => $week_days,
            'mealPlanList' => $mealPlanList,
        ]);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 10-JANUARY-2022
     * @description : FUNCTION TO EDIT NORMAL ROOM RATE DETAILS
     */

    public function editNormalRoomRateAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        $dataVendor = ['booking_type_id' => $this->config()->getConfig()->masterBookingType->hotelId];
        HotelRoomRateForm::$hotel_list = $this->CommonModel->getHotelList($data);
        HotelRoomRateForm::$vendorTypeList = $this->CommonModel->getHotelVendorTypeList($dataVendor);
        HotelRoomRateForm::$currenyList = $this->CommonModel->getCurrencyList();
        HotelRoomRateForm::$mealPlanList = $this->CommonModel->getMealPlanList($data);
        HotelRoomRateForm::$hotelRateTypeList = $this->CommonModel->getHotelRateTypeList($data);
        HotelRoomRateForm::$hotelSeasonNameList = $this->CommonModel->getHotelSeasonNameList($data);
        HotelRoomRateForm::$hotelRateNameList = $this->CommonModel->getHotelRateNameList($data);
        HotelRoomRateForm::$weekDaysList = $this->userModel->getWeekDaysList();
        HotelRoomRateForm::$promotionRateTypeList = $this->CommonModel->getPromotionRateTypeList($data);
        $mealPlanList = $this->CommonModel->getMealPlanListData($data);
        $form = new HotelRoomRateForm();

        $id = $this->params()->fromQuery('id');
        $rateType = $this->params()->fromQuery('rate_type');
        if (!empty($id)) {
            $data = [
                'auto_id' => $id,
                'company_id' => $this->config()->getConfig()->company->companyId,
                'rate_type' => 'Normal Rate'
            ];
            $vehicleData = $this->CommonModel->getHotelRoomRateDetailsList($data);
            if(empty($vehicleData)){
                 $this->redirect()->toRoute('hotel', 
                         ['action' => 'normal-room-rate'], 
                          ['query' => ['id'=>$id, 'rate_type' => $rateType]]);
            }
            $vehicleData = $vehicleData[0];
            $dataRooms = [
                'company_id' => $this->config()->getConfig()->company->companyId,
                'hotel_id' => $vehicleData['hotel_id']
            ];
            $roomList = $this->CommonModel->getHotelRoomList($dataRooms);
            $dataVendorList = [
                'company_id' => $this->config()->getConfig()->company->companyId,
                'user_type_id' => $vehicleData['vendor_type'],
            ];
            //var_dump($dataVendorList); die;
            $vendorUserData = $this->CommonModel->getHotelVendorListData($dataVendorList);
            //var_dump($vehicleData); die;
            $form->setData($vehicleData);
            $form->getInputFilter()->get('hotel_id')->setRequired(false);
            $form->get('id')->setValue($vehicleData['id']);
            $form->get('hotel_id')->setValue($vehicleData['hotel_id']);
            //$form->get('hotel_id')->setAttribute("disabled", [$vehicleData['hotel_id']]);
            $form->get('hotel_rate_name')->setValue($vehicleData['rate_name_id']);
            $form->get('hotel_rate_season')->setValue($vehicleData['season_id']);
            $form->get('weekdays')->setValue(explode(',', $vehicleData['week_days']));
            $form->get('promotion_rate_type')->setValue(explode(',', $vehicleData['promotion_plan']));
            $form->get('vendor_name')->setValueOptions($vendorUserData);
            $form->get('vendor_name')->setValue($vehicleData['vendor_id']);
            $form->get('room_id')->setValueOptions($roomList);
            $form->get('room_id')->setValue($vehicleData['room_id']);
            $form->get('currency')->setValue($vehicleData['currency_id']);
            $form->get('commission_value')->setValue($vehicleData['commission_rate_value']);
            
            if(!empty($vehicleData['discount_valid_from'])){
              $form->get('discount_valid_from')->setValue(date('d-m-Y', strtotime($vehicleData['discount_valid_from'])));
             }
             
             if(!empty($vehicleData['discount_valid_to'])){
             $form->get('discount_valid_to')->setValue(date('d-m-Y', strtotime($vehicleData['discount_valid_to'])));
             }
             
             $form->get('discount_commission_value')->setValue($vehicleData['discount_commission_rate_value']);
             
            $form->get('contract_rate_desc')->setValue($vehicleData['description']);
            $form->get('valid_from')->setValue(date('d-m-Y', strtotime($vehicleData['valid_from'])));
            $form->get('valid_to')->setValue(date('d-m-Y', strtotime($vehicleData['valid_to'])));
            $form->get('name_of_price_plan')->setValue($vehicleData['price_plan_name']);
            $hotelData = ['bkg_type_id' => $this->config()->getConfig()->masterBookingType->hotelId, 'mapping_id' => $id];
            $hotelRoomExtraMealData = $this->CommonModel->getHotelRoomRateExtraMealList($hotelData);
            if (!empty($hotelRoomExtraMealData)) {
            $form->get('extra_meal_adult_sgl')->setValue($hotelRoomExtraMealData[0]['sgl_ext_adult_breakfast_rate']);
            $form->get('extra_meal_adult_dbl')->setValue($hotelRoomExtraMealData[0]['dbl_ext_adult_lunch_rate']);
            $form->get('extra_meal_adult_tbl')->setValue($hotelRoomExtraMealData[0]['tbl_ext_adult_dinner_rate']);
            $form->get('extra_meal_child_child')->setValue($hotelRoomExtraMealData[0]['child2to12_ext_breakfast_rate']);
            $form->get('extra_meal_child_child1')->setValue($hotelRoomExtraMealData[0]['child12to16_ext_lunch_rate']);
            $form->get('extra_meal_child_extra_bed')->setValue($hotelRoomExtraMealData[0]['extra_with_bed_ext_dinner_rate']);
            }
            $hotelRoomRateData = $this->CommonModel->getHotelRoomRateDataList($hotelData);
            $hotelStayMoreDiscountData = $this->CommonModel->getStayMoreDiscountList($hotelData);
            $hotelLastMinuteDiscountData = $this->CommonModel->getLastMinuteDiscountList($hotelData);
            $hotelEarlyDiscountData = $this->CommonModel->getEarlyDiscountList($hotelData);
            $hotelDayWiseDiscountData = $this->CommonModel->getDayWiseDiscountList($hotelData);
            $hotelKidsData = ['bkg_type_id' => $this->config()->getConfig()->masterBookingType->hotelId, 'mapping_id' => $id, 'type' => 'kids'];
            $hotelKidsDiscountData = $this->CommonModel->getHotelFreeOffersList($hotelKidsData);
            $hotelNightsData = ['bkg_type_id' => $this->config()->getConfig()->masterBookingType->hotelId, 'mapping_id' => $id, 'type' => 'nights'];
            $hotelNightsDiscountData = $this->CommonModel->getHotelFreeOffersList($hotelNightsData);
            $hotelRoomsData = ['bkg_type_id' => $this->config()->getConfig()->masterBookingType->hotelId, 'mapping_id' => $id, 'type' => 'rooms'];
            $hotelRoomDiscountData = $this->CommonModel->getHotelFreeOffersList($hotelRoomsData);
            $hotelTaxData = $this->CommonModel->getHotelBasicTax($hotelData);
            //echo "<pre>"; print_r($hotelLastMinuteDiscountData);die;
            //var_dump($hotelRoomRateData);die;
        }
        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            //echo '<pre>';print_r($postData);//die();
            $form->setData($postData);


            //echo "Mohit";
            //echo "<pre>";print_r($normalRateMealPlandetails); die;
            //if ($form->isValid()) {
            $stayingdetails = "";
            $lastBookingDetails = "";
            $earlyBookingDetails = "";
            $dayWiseDetails = "";
            $kidsBookingDetails = "";
            $nightBookingDetails = "";
            $roomBookingDetails = "";
            $finalData = [];
            $normalRateMealPlandetails = [];
            $normalRateExtraMealDetails = [];
            if (isset($postData['meal_plan_id']) && !empty($postData['meal_plan_id'])) {
                $meal_plan_id = array_values($postData['meal_plan_id']);
                for ($i = 0; $i < count($meal_plan_id); $i++) {
                    $mealPlanName = $this->CommonModel->getMealPlanTypeName($meal_plan_id[$i]);
                    $normalRateMealPlandetails['meal_plan_type_id'][$i] = $meal_plan_id[$i];
                    $normalRateMealPlandetails['sgl_rate'][$i] = $postData['sgl_rate_' . $mealPlanName];
                    $normalRateMealPlandetails['dbl_rate'][$i] = $postData['dbl_rate_' . $mealPlanName];
                    $normalRateMealPlandetails['tbl_rate'][$i] = $postData['tbl_rate_' . $mealPlanName];
                    $normalRateMealPlandetails['child_rate'][$i] = $postData['child_rate_' . $mealPlanName];
                    $normalRateMealPlandetails['child1_rate'][$i] = $postData['child1_rate_' . $mealPlanName];
                    $normalRateMealPlandetails['extra_bed_rate'][$i] = $postData['extra_bed_rate_' . $mealPlanName];
                }
            }
            if (isset($postData['extra_meal_adult_sgl']) && !empty($postData['extra_meal_adult_sgl'])) {
                $normalRateExtraMealDetails['sgl_ext_adult_breakfast_rate'] = $postData['extra_meal_adult_sgl'];
                $normalRateExtraMealDetails['dbl_ext_adult_lunch_rate'] = $postData['extra_meal_adult_dbl'];
                $normalRateExtraMealDetails['tbl_ext_adult_dinner_rate'] = $postData['extra_meal_adult_tbl'];
                $normalRateExtraMealDetails['child2to12_ext_breakfast_rate'] = $postData['extra_meal_child_child'];
                $normalRateExtraMealDetails['child12to16_ext_lunch_rate'] = $postData['extra_meal_child_child1'];
                $normalRateExtraMealDetails['extra_with_bed_ext_dinner_rate'] = $postData['extra_meal_child_child1'];
            }

            //Stay More Get More Discount


            if (isset($postData['staying_days']) && !empty($postData['staying_days'])) {
                $stayingdetails = [];
                $staying_days = array_values(array_filter($postData['staying_days']));
                $more_discount_from = array_values(array_filter($postData['more_discount_from']));
                $more_discount_to = array_values(array_filter($postData['more_discount_to']));
                $stay_more_discount_type = array_values(array_filter($postData['stay_more_discount_type']));
                $staying_amount = array_values(array_filter($postData['staying_amount']));
                for ($i = 0; $i < count($staying_days); $i++) {
                    $stayingdetails['stay_more_week_days'][$i] = $staying_days[$i];
                    $stayingdetails['stay_more_from_date'][$i] = date('Y-m-d', strtotime($more_discount_from[$i]));
                    $stayingdetails['stay_more_to_date'][$i] = date('Y-m-d', strtotime($more_discount_to[$i]));
                    $stayingdetails['stay_more_type'][$i] = $stay_more_discount_type[$i];
                    $stayingdetails['stay_more_value'][$i] = $staying_amount[$i];
                }
            }


            //Last Minute Booking
            if (isset($postData['last_minute_booking_hour']) && !empty($postData['last_minute_booking_hour'])) {
                $lastBookingDetails = [];
                $last_minute_booking_hour = array_values(array_filter($postData['last_minute_booking_hour']));
                $last_booking_from = array_values(array_filter($postData['last_booking_from']));
                $last_booking_to = array_values(array_filter($postData['last_booking_to']));
                $last_minute_booking_type = array_values(array_filter($postData['last_minute_booking_type']));
                $last_minute_booking_amount = array_values(array_filter($postData['last_minute_booking_amount']));
                for ($i = 0; $i < count($last_minute_booking_hour); $i++) {
                    $lastBookingDetails['last_min_hour'][$i] = $last_minute_booking_hour[$i];
                    $lastBookingDetails['last_min_from_date'][$i] = date('Y-m-d', strtotime($last_booking_from[$i]));
                    $lastBookingDetails['last_min_to_date'][$i] = date('Y-m-d', strtotime($last_booking_to[$i]));
                    $lastBookingDetails['last_min_discount_type'][$i] = $last_minute_booking_type[$i];
                    $lastBookingDetails['last_min_discount_value'][$i] = $last_minute_booking_amount[$i];
                }
            }

            //Early Booking
            if (isset($postData['early_booking_days']) && !empty($postData['early_booking_days'])) {
                $earlyBookingDetails = [];
                $early_booking_days = array_values(array_filter($postData['early_booking_days']));
                $early_booking_from = array_values(array_filter($postData['early_booking_from']));
                $early_booking_to = array_values(array_filter($postData['early_booking_to']));
                $early_booking_type = array_values(array_filter($postData['early_booking_type']));
                $early_booking_amount = array_values(array_filter($postData['early_booking_amount']));
                for ($i = 0; $i < count($early_booking_days); $i++) {
                    $earlyBookingDetails['early_week_days'][$i] = $early_booking_days[$i];
                    $earlyBookingDetails['early_from_date'][$i] = date('Y-m-d', strtotime($early_booking_from[$i]));
                    $earlyBookingDetails['early_to_date'][$i] = date('Y-m-d', strtotime($early_booking_to[$i]));
                    $earlyBookingDetails['early_discount_type'][$i] = $early_booking_type[$i];
                    $earlyBookingDetails['early_discount_value'][$i] = $early_booking_amount[$i];
                }
            }

            //Day Wise Discount
            if (isset($postData['dis_days']) && !empty($postData['dis_days'])) {
                $dayWiseDetails = [];
                $dis_days = array_values(array_filter($postData['dis_days']));
                $day_wise_from = array_values(array_filter($postData['day_wise_from']));
                $day_wise_to = array_values(array_filter($postData['day_wise_to']));
                $day_wise_dis_type = array_values(array_filter($postData['day_wise_dis_type']));
                $day_wise_discount_amount = array_values(array_filter($postData['day_wise_discount_amount']));
                for ($i = 0; $i < count($dis_days); $i++) {
                    $dayWiseDetails['daywise_week_days'][$i] = $dis_days[$i];
                    $dayWiseDetails['daywise_from_date'][$i] = date('Y-m-d', strtotime($day_wise_from[$i]));
                    $dayWiseDetails['daywise_to_date'][$i] = date('Y-m-d', strtotime($day_wise_to[$i]));
                    $dayWiseDetails['daywise_discount_type'][$i] = $day_wise_dis_type[$i];
                    $dayWiseDetails['daywise_discount_value'][$i] = $day_wise_discount_amount[$i];
                }
            }


            //Kids Free Offers
            if (isset($postData['kids_package_name']) && !empty($postData['kids_package_name'])) {
                $kidsBookingDetails = [];
                $kids_package_name = array_values(array_filter($postData['kids_package_name']));
                $kids_rooms = array_values(array_filter($postData['kids_rooms']));
                $kids_nights = array_values(array_filter($postData['kids_nights']));
                $kids_discount_from = array_values(array_filter($postData['kids_discount_from']));
                $kids_discount_to = array_values(array_filter($postData['kids_discount_to']));
                for ($i = 0; $i < count($kids_package_name); $i++) {
                    $kidsBookingDetails['package_name'][$i] = $kids_package_name[$i];
                    $kidsBookingDetails['rooms'][$i] = $kids_rooms[$i];
                    $kidsBookingDetails['nights'][$i] = $kids_nights[$i];
                    $kidsBookingDetails['from_date'][$i] = date('Y-m-d', strtotime($kids_discount_from[$i]));
                    $kidsBookingDetails['to_date'][$i] = date('Y-m-d', strtotime($kids_discount_to[$i]));
                    $kidsBookingDetails['type'][$i] = 'kids';
                }
            }

            //Free Night Offers
            if (isset($postData['night_package_name']) && !empty($postData['night_package_name'])) {
                $nightBookingDetails = [];
                $night_package_name = array_values(array_filter($postData['night_package_name']));
                $night_rooms = array_values(array_filter($postData['night_rooms']));
                $night_nights = array_values(array_filter($postData['night_nights']));
                $night_discount_from = array_values(array_filter($postData['night_discount_from']));
                $night_discount_to = array_values(array_filter($postData['night_discount_to']));
                for ($i = 0; $i < count($night_package_name); $i++) {
                    $nightBookingDetails['package_name'][$i] = $night_package_name[$i];
                    $nightBookingDetails['rooms'][$i] = $night_rooms[$i];
                    $nightBookingDetails['nights'][$i] = $night_nights[$i];
                    $nightBookingDetails['from_date'][$i] = date('Y-m-d', strtotime($night_discount_from[$i]));
                    $nightBookingDetails['to_date'][$i] = date('Y-m-d', strtotime($night_discount_to[$i]));
                    $nightBookingDetails['type'][$i] = 'nights';
                }
            }


            //Free Room Offers
            if (isset($postData['room_package_name']) && !empty($postData['room_package_name'])) {
                $roomBookingDetails = [];
                $room_package_name = array_values(array_filter($postData['room_package_name']));
                $room_rooms = array_values(array_filter($postData['room_rooms']));
                $room_nights = array_values(array_filter($postData['room_nights']));
                $room_discount_from = array_values(array_filter($postData['room_discount_from']));
                $room_discount_to = array_values(array_filter($postData['room_discount_to']));

                for ($i = 0; $i < count($room_package_name); $i++) {
                    $roomBookingDetails['package_name'][$i] = $room_package_name[$i];
                    $roomBookingDetails['rooms'][$i] = $room_rooms[$i];
                    $roomBookingDetails['nights'][$i] = $room_nights[$i];
                    $roomBookingDetails['from_date'][$i] = date('Y-m-d', strtotime($room_discount_from[$i]));
                    $roomBookingDetails['to_date'][$i] = date('Y-m-d', strtotime($room_discount_to[$i]));
                    $roomBookingDetails['type'][$i] = 'rooms';
                }
            }         
            
            
            if (isset($postData['typeofcommission']) && !empty($postData['typeofcommission'])) {
                if($postData['typeofcommission']=="Commissionable Rate"){
                    $comissionType = $postData['commissiontype'];
                    $comissionValue = $postData['commission_value'];                    
                }else{
                    $comissionType = "";
                    $comissionValue = "";
                }
            }
            
            
            if (isset($postData['service_charge']) && !empty($postData['service_charge'])) {
                if($postData['service_charge']=="Yes"){
                    $serviceChargeType = $postData['service_charge_type'];
                    $serviceChargeValue = $postData['service_charge_value'];                    
                }else{
                    $serviceChargeType = "";
                    $serviceChargeValue = "";
                }
            }
            
            
            if (isset($postData['tax_charge']) && !empty($postData['tax_charge'])) {
                if($postData['tax_charge']=="Yes"){
                    $taxType = '%';
                    $sgst = $postData['sgst'];
                    $cgst = $postData['cgst'];
                    $igst = $postData['igst'];
                }else{
                    $taxType = "";
                    $sgst = "";
                    $cgst = "";
                    $igst = "";
                }
            }
            
            if (isset($postData['discounttypeofcommission']) && !empty($postData['discounttypeofcommission'])) {
                if($postData['discounttypeofcommission']=="Commissionable Rate"){
    $discountcommissiontype = $postData['discountcommissiontype'];
    $discountcomissionValue = $postData['discount_commission_value'];
    if($postData['discount_valid_from']!=""){
    $discountvalidFrom = date('Y-m-d', strtotime($postData['discount_valid_from']));
    }else{
    $discountvalidFrom = date('Y-m-d', strtotime($postData['valid_from']));    
    }
    
    if($postData['discount_valid_to']!=""){
      $discountvalidTo = date('Y-m-d', strtotime($postData['discount_valid_to']));
    }else{
      $discountvalidTo = date('Y-m-d', strtotime($postData['valid_to']));
    }
                }else{
                    $discountcommissiontype = "";
                    $discountcomissionValue = "";
                    $discountvalidFrom = "";
                    $discountvalidTo = "";
                }
            }
            

            $finalData['room_rate'] = [
                'normal_rate' => 1,
                'hotel_id' => $postData['hotel_id'],
                'room_id' => $postData['room_id'],
                'currency_id' => $postData['currency'],
                'vendor_type' => $postData['vendor_type'],
                'vendor_id' => $postData['vendor_name'],
                'rate_type' => 'Normal Rate',
                'rate_type_id' => 0,
                'rate_name_id' => $postData['hotel_rate_name'],
                'season_id' => $postData['hotel_rate_season'],
                'week_days' => implode(',', $postData['weekdays']),
                'promotion_plan' => implode(',', $postData['promotion_rate_type']),
                'valid_from' => date('Y-m-d', strtotime($postData['valid_from'])),
                'valid_to' => date('Y-m-d', strtotime($postData['valid_to'])),
                
                'tax_charge' => $postData['tax_charge'],
                'tax_type' => $taxType,
                'sgst' => $sgst,
                'cgst' => $cgst,
                'igst' => $igst,
                
                'netrate_commissionrate' => $postData['typeofcommission'],
                'commission_rate_type' => $comissionType,
                'commission_rate_value' => $comissionValue,
                
                'service_charge' => $postData['service_charge'],
                'service_charge_type' => $serviceChargeType,
                'service_charge_value' => $serviceChargeValue,
                
'discount_netrate_commissionrate' => $postData['discounttypeofcommission'],
'discount_commission_rate_type' => $discountcommissiontype,
'discount_commission_rate_value' => $discountcomissionValue,
'discount_valid_from' => $discountvalidFrom,
'discount_valid_to' => $discountvalidTo,
                
                'description' => $postData['contract_rate_desc'],
                "normal_rate_meal_plan_details" => $normalRateMealPlandetails,
                "normal_rate_extra_meal_details" => $normalRateExtraMealDetails,
                "price_plan_name" => $postData['name_of_price_plan'],
                "stay_more_status" => !empty($stayingdetails) ? $postData['stay_get_mor_dis'] : 0,
                "stay_more_discount_value" => $stayingdetails,
                "last_min_booking_status" => !empty($lastBookingDetails) ? $postData['last_minute_booking'] : 0,
                "last_min_booking_value" => $lastBookingDetails,
                "early_booking_status" => !empty($earlyBookingDetails) ? $postData['early_booking'] : 0,
                "early_booking_value" => $earlyBookingDetails,
                "daywise_discount_status" => !empty($dayWiseDetails) ? $postData['day_wise_discount'] : 0,
                "daywise_discount_value" => $dayWiseDetails,
                "kids_discount_status" => !empty($kidsBookingDetails) ? $postData['kids_mor_dis'] : 0,
                "kids_discount_value" => $kidsBookingDetails,
                "night_discount_status" => !empty($nightBookingDetails) ? $postData['night_mor_dis'] : 0,
                "night_discount_value" => $nightBookingDetails,
                "room_discount_status" => !empty($roomBookingDetails) ? $postData['room_mor_dis'] : 0,
                "room_discount_value" => $roomBookingDetails,
                'user_id' => $userId,
                'ip' => $_SERVER['REMOTE_ADDR'],
               'bkg_type_id' => $this->config()->getConfig()->masterBookingType->hotelId,
               'auto_id' => $postData['id']
            ];

            //echo json_encode($finalData); die;
            //echo '<pre>';print_r($finalData); die;
           $responseData = $this->CommonModel->updateHotelRoomRateDetails($finalData);
            //echo '<pre>';print_r($responseData);  die;
            if ($responseData['response']['status'] == 'success') {
                $msg = "Details Updated Successfully!..";
                $this->flashMessenger()->addMessage(array('success' => $msg));
            } else {
                $msg = "Details Could Not Upated!..";
                $this->flashMessenger()->addMessage(array('danger' => $msg));
            }
            $this->redirect()->toRoute('hotel', ['action' => 'normal-room-rate']);
            //}
            /* else{
              $msg = $form->getMessages();
              print_r($msg); die;
              } */
        }
        $week_days = $this->userModel->getWeekDaysList();
        $data = [
            'company_id' => $this->config()->getConfig()->company->companyId,
            'rate_type' => 'Normal Rate'
        ];
        $packageListing = $this->CommonModel->getHotelRoomRateDetailsList($data);
        $viewModel = new ViewModel([
            'form' => $form,
            'tab' => 'normal-room-rate',
            'packageListing' => $packageListing,
            'week_days' => $week_days,
            'mealPlanList' => $mealPlanList,
            'vehicleData' => $vehicleData,
            'hotelRoomRateData' => $hotelRoomRateData,
            'hotelStayMoreDiscountData' => $hotelStayMoreDiscountData,
            'hotelLastMinuteDiscountData' => $hotelLastMinuteDiscountData,
            'hotelEarlyDiscountData' => $hotelEarlyDiscountData,
            'hotelDayWiseDiscountData' => $hotelDayWiseDiscountData,
            'hotelKidsDiscountData' => $hotelKidsDiscountData,
            'hotelNightsDiscountData' => $hotelNightsDiscountData,
            'hotelRoomDiscountData' => $hotelRoomDiscountData,
            'hotelTaxData' => $hotelTaxData
        ]);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 10-JANUARY-2022
     * @description : FUNCTION TO GET HOTEL CONTACT DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function getHotelContactDetailsAction() {
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $userId = $userData['user_id'];
        $postData = $this->getRequest()->getPost();
        if ($postData['id'] != "") {
            $val = [
                'auto_id' => $postData['id'],
                'company_id' => $this->config()->getConfig()->company->companyId
            ];
            $data = $this->CommonModel->getHotelDetails($val);

            //var_dump($data); die;
            if (!empty($data[0])) {
                $data[0]['allocation_from_date'] = date('d-m-Y', strtotime($data[0]['allocation_from_date']));
                $data[0]['allocation_to_date'] = date('d-m-Y', strtotime($data[0]['allocation_to_date']));
                if (!empty($data[0]['realted_tours'])) {
                    $tours = [];
                    $toursArray = explode(',', $data[0]['realted_tours']);
                    foreach ($toursArray as $realtedTours) {
                        $tours[] = $realtedTours;
                    }
                    //var_dump($tours); die;
                    $data[0]['realted_tours'] = $tours;
                }


                $response = ["status" => true, "data" => $data[0]];
            } else {
                $response = ["status" => false];
            }
        } else {
            $response = ["status" => false];
        }
        $view = new JsonModel($response);
        return $view;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 10-JANUARY-2022
     * @description : FUNCTION TO CHANGE THE HOTEL ROOM STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function hotelRoomStatusAction() {
        $data1 = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $data = $this->getRequest()->getPost();
        $id = implode(',', $data['selected']);
        $status = $data['status'];
        $data = ['user_id' => $user_id, 'id' => $id, 'status' => $status];
        $this->CommonModel->updateHotelRoomStatus($data);
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        $packageListing = $this->CommonModel->getHotelRoomDetailsList($data);
        $viewModel = new ViewModel(['packageListing' => $packageListing]);
        $viewModel->setTemplate('/dashboard/hotel/hotel-room-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 10-JANUARY-2022
     * @description : FUNCTION TO CHANGE ROOM RECORD STATUS
     * @param $data
     * @returns $responsedata
     */

    public function changeRoomRecordStatusAction() {
        $status = 0;
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status'] == 0 || $postData['status'] == 2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->CommonModel->updateHotelRoomStatus($data);
        }
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        $packageListing = $this->CommonModel->getHotelRoomDetailsList($data);
        $viewModel = new ViewModel(['packageListing' => $packageListing]);
        $viewModel->setTemplate('/dashboard/hotel/hotel-room-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 10-JANUARY-2022
     * @description : FUNCTION TO DELETE THE HOTEL ROOM DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function deleteHotelRoomDetailsAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id' => $userId, 'status' => 2];
        $this->CommonModel->updateHotelRoomStatus($data);
        $this->redirect()->toRoute('hotel', ['action' => 'room-hotel']);
        $this->flashMessenger()->addMessage(array('success' => 'Details Delete Successfully'));
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 10-JANUARY-2022
     * @description : FUNCTION TO GEENERATE HOTEL CODE
     * @param $data
     * @returns $responsedata
     */

    public function generateHotelCode($data) {
        $code = "";
        $cityData = $this->CommonModel->getStateCountry($data);
        $code = 'H' . $cityData['counrty_code'];
        return $code;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 10-JANUARY-2022
     * @description : FUNCTION TO FETCH THE WEEK DAYS LIST DATA
     * @param $data
     * @returns $responsedata
     */

    public function getWeekDaysList() {
        $data = [];
        $url = $this->apiUrl() . "/week-days-list";
        $resp = $this->get($url);
        $weekTypeJsonData = Json::decode($resp->getBody(), true);
        if (!empty($weekTypeJsonData)) {
            foreach ($weekTypeJsonData as $value) {
                $data[] = ["id" => $value['id'], "name" => $value['name']];
            }
            $response = ["status" => true, "data" => $data];
        } else {
            $response = ["status" => false];
        }
        return $response;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 10-JANUARY-2022
     * @description : FUNCTION FOR FETCH ROOM DETAILS USING AJAX
     * @param $data
     * @returns $responsedata
     */

    public function getAjaxRoomListAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $data = [];
        $postData = $this->getRequest()->getPost();
        $company_id = $this->config()->getConfig()->company->companyId;
        $hotel_id = $postData['hotel_id'];
        $data = [
            'company_id' => $company_id,
            'hotel_id' => $hotel_id,
        ];
        $data = array_filter($data);
        $roomJsonData = $this->CommonModel->getHotelRoomDetailsList($data);
        if (!empty($roomJsonData)) {
            foreach ($roomJsonData as $value) {
                $roomName = $value['name'] . ' (' . $value['room_category_name'] . ')';
                $data1[] = ["id" => $value['id'], "name" => $roomName];
            }
            $response = ["status" => true, "data" => $data1];
        } else {
            $response = ["status" => false];
        }
        $view = new JsonModel($response);
        return $view;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 10-JANUARY-2022
     * @description : FUNCTION FOR ADD HOTEL BROCHURE META DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function brochureMetaAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        HotelMetaTagForm::$hotel_list = $this->CommonModel->getHotelList($data);
        $form = new HotelMetaTagForm();

        $id = $this->params()->fromQuery('id');


        if (!empty($id)) {
            $sessionHotelContainer = new Container('addHotelData');
            $hotelId = $sessionHotelContainer->hotel_id;
            if ($hotelId == $id) {
                $data = [
                    'hotel_id' => $id,
                    'company_id' => $this->config()->getConfig()->company->companyId
                ];
            } else {
                $data = [
                    'auto_id' => $id,
                    'company_id' => $this->config()->getConfig()->company->companyId
                ];
            }
            $vehicleData = $this->CommonModel->getHotelDetailsList($data);
            $vehicleData = $vehicleData[0];
            $form->setData($vehicleData);
            $form->get('id')->setValue($vehicleData['id']);
            $form->get('hotel_id')->setValue($vehicleData['id']);
            //$form->get('hotel_id')->setAttribute("disabled",[$vehicleData['id']]);
            $form->getInputFilter()->get('hotel_id')->setRequired(false);
            if (!empty($vehicleData['realted_tours'])) {
                $tours = [];
                $toursArray = explode(',', $vehicleData['realted_tours']);
                foreach ($toursArray as $realtedTours) {
                    $tours[] = $realtedTours;
                }
                $form->get('realted_tours')->setValue($tours);
            }
        }

        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            $form->setData($postData);
            if ($form->isValid()) {
                $finalData = [];
                if (isset($postData['id']) && !empty($postData['id'])) {
                    $autoId = $postData['id'];
                    $url = 'allocation-hotel?id=' . $postData['id'];
                } else {
                    $autoId = $postData['hotel_id'];
                    $url = 'allocation-hotel';
                }
                $finalData = [
                    'realted_tours' => implode(",", $postData['realted_tours']),
                    'brochure_title' => $postData['brochure_title'],
                    'brochure_description' => $postData['brochure_description'],
                    'meta_keywords' => $postData['meta_keywords'],
                    'meta_title' => $postData['meta_title'],
                    'meta_description' => $postData['meta_description'],
                    'user_id' => $userId,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'auto_id' => $autoId
                ];
                $responseData = $this->CommonModel->updateHotelMetaDetails($finalData);
                if ($responseData['responsedata']['status'] == 'success') {
                    $msg = "Details Updated Successfully!..";
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Details Could Not Upated!..";
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
                return $this->redirect()->toUrl($url);
            }
        }
        $viewModel = new ViewModel(['form' => $form, 'tab' => 'brochure-meta']);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 10-JANUARY-2022
     * @description : FUNCTION FOR ADD HOTEL ALLOCATION DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function allocationHotelAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        HotelAllocationForm::$hotel_list = $this->CommonModel->getHotelList($data);
        HotelAllocationForm::$roomCategoryList = $this->CommonModel->getRoomCategoryList();
        $form = new HotelAllocationForm();

        $id = $this->params()->fromQuery('id');

        if (!empty($id)) {
            $sessionHotelContainer = new Container('addHotelData');
            $hotelId = $sessionHotelContainer->hotel_id;
            if ($hotelId == $id) {
                $data = [
                    'hotel_id' => $id,
                    'company_id' => $this->config()->getConfig()->company->companyId
                ];
            } else {
                $data = [
                    'auto_id' => $id,
                    'company_id' => $this->config()->getConfig()->company->companyId
                ];
            }
            $vehicleData = $this->CommonModel->getHotelDetailsList($data);
            $vehicleData = $vehicleData[0];
            $form->setData($vehicleData);
            $form->get('id')->setValue($vehicleData['id']);
            $form->get('hotel_id')->setValue($vehicleData['id']);
            if ($vehicleData['allocation_from_date'] != '0000-00-00') {
                $form->get('allocation_from_date')->setValue(date('Y-m-d', strtotime($vehicleData['allocation_from_date'])));
            }
            if ($vehicleData['allocation_to_date'] != '0000-00-00') {
                $form->get('allocation_to_date')->setValue(date('Y-m-d', strtotime($vehicleData['allocation_to_date'])));
            }
            //$form->get('hotel_id')->setAttribute("disabled",[$vehicleData['id']]);
            $form->getInputFilter()->get('hotel_id')->setRequired(false);
        }

        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            $form->setData($postData);
            if ($form->isValid()) {
                if (isset($postData['id']) && !empty($postData['id'])) {
                    $autoId = $postData['id'];
                    $url = 'terms-policy?id=' . $postData['id'];
                } else {
                    $autoId = $postData['hotel_id'];
                    $url = 'terms-policy';
                }
                $finalData = [];
                $finalData = [
                    'allocation_from_date' => date('Y-m-d', strtotime($postData['allocation_from_date'])),
                    'allocation_to_date' => date('Y-m-d', strtotime($postData['allocation_to_date'])),
                    'allocation_name' => $postData['allocation_name'],
                    'allocation_cut_off_days' => $postData['allocation_cut_off_days'],
                    'allocation_room_category' => $postData['allocation_room_category'],
                    'user_id' => $userId,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'auto_id' => $autoId
                ];
                $responseData = $this->CommonModel->updateHotelAllocationDetails($finalData);
                if ($responseData['responsedata']['status'] == 'success') {
                    $msg = "Details Updated Successfully!..";
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Details Could Not Upated!..";
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
                return $this->redirect()->toUrl($url);
            }
        }
        $viewModel = new ViewModel(['form' => $form, 'tab' => 'allocation-hotel']);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 10-JANUARY-2022
     * @description : FUNCTION FOR TERMS AND POLICY
     * @param $data
     * @returns $responsedata
     */

    public function termsPolicyAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        HotelTermsPolicyForm::$hotel_list = $this->CommonModel->getHotelList($data);
        HotelTermsPolicyForm::$country = $this->userModel->getCountryList();
        HotelTermsPolicyForm::$payment_structure = $this->CommonModel->getPaymentStructureList();
        HotelTermsPolicyForm::$documentation = $this->CommonModel->getDocumentationList();
        HotelTermsPolicyForm::$cancellation_policy = $this->CommonModel->getCancellationPolicyList();
        HotelTermsPolicyForm::$refund_policy = $this->CommonModel->getRefundPolicyList();
        HotelTermsPolicyForm::$term_policy = $this->CommonModel->getTermConditionsPolicyList();
        $form = new HotelTermsPolicyForm();

        $id = $this->params()->fromQuery('id');

        if (!empty($id)) {
            $sessionHotelContainer = new Container('addHotelData');
            $hotelId = $sessionHotelContainer->hotel_id;
            if ($hotelId == $id) {
                $data = [
                    'hotel_id' => $id,
                    'company_id' => $this->config()->getConfig()->company->companyId
                ];
            } else {
                $data = [
                    'hotel_id' => $id,
                    'company_id' => $this->config()->getConfig()->company->companyId
                ];
            }
            $vehicleData = $this->CommonModel->getHotelDetailsList($data);
            $vehicleData = $vehicleData[0];
            $form->setData($vehicleData);
            $form->get('id')->setValue($vehicleData['id']);
            $form->get('hotel_id')->setValue($vehicleData['id']);
            if ($vehicleData['available_start_date'] != '0000-00-00') {
                $form->get('available_start_date')->setValue(date('Y-m-d', strtotime($vehicleData['available_start_date'])));
            }
            if ($vehicleData['available_end_date'] != '0000-00-00') {
                $form->get('available_end_date')->setValue(date('Y-m-d', strtotime($vehicleData['available_end_date'])));
            }
            //$form->get('hotel_id')->setAttribute("disabled",[$vehicleData['id']]);
            $form->getInputFilter()->get('hotel_id')->setRequired(false);
        }
        $request = $this->getRequest();
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $postData = $request->getPost()->toArray();
                $finalData = [];
                if (isset($postData['id']) && !empty($postData['id'])) {
                    $autoId = $postData['id'];
                } else {
                    $autoId = $postData['hotel_id'];
                }
                $finalData = [
                    'hotel_id' => $autoId,
                    'available_start_date' => date('Y-m-d', strtotime($postData['available_start_date'])),
                    'available_end_date' => date('Y-m-d', strtotime($postData['available_end_date'])),
                    'feature_google_map' => $postData['feature_google_map'],
                    'hotel_highlights' => $postData['hotel_highlights'],
                    'payment_structure_id' => $postData['payment_structure_id'],
                    'payment_structure_content' => $postData['payment_structure_content'],
                    'document_id' => $postData['document_id'],
                    'documentation_content' => $postData['documentation_content'],
                    'cancellation_policy' => $postData['cancellation_policy'],
                    'cancellation_policy_content' => $postData['cancellation_policy_content'],
                    'refund_policy' => $postData['refund_policy'],
                    'refund_policy_content' => $postData['refund_policy_content'],
                    'term_policy' => $postData['term_policy'],
                    'term_policy_content' => $postData['term_policy_content'],
                    'user_id' => $userId,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];
                $responseData = $this->CommonModel->updateTermsPolicyDetails($finalData);
                if ($responseData['response']['status'] == 'success') {
                    $msg = "Details Added Successfully!..";
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Details Could Not Added!..";
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
                $this->redirect()->toRoute('hotel', ['action' => 'index']);
            }
        }
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        $packageListing = $this->CommonModel->getHotelDetailsList($data);
        $viewModel = new ViewModel([
            'form' => $form,
            'tab' => 'terms-policy',
            'packageListing' => $packageListing,
        ]);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-JANUARY-2022
     * @description : FUNCTION FOR UPLOAD IMAGES
     * @param $data
     * @returns $responsedata
     */

    public function uploadImagesAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $form = new HotelImageForm();
        $documentListing = [];
        $id = $this->params()->fromQuery('id');
        if (!empty($id)) {
            $sessionHotelContainer = new Container('addHotelData');
            $hotelId = $sessionHotelContainer->hotel_id;
            if ($hotelId == $id) {
                $data = [
                    'hotel_id' => $id,
                    'company_id' => $this->config()->getConfig()->company->companyId
                ];
            } else {
                $data = [
                    'hotel_id' => $id,
                    'company_id' => $this->config()->getConfig()->company->companyId
                ];
            }
            $vehicleData = $this->CommonModel->getHotelDetailsList($data);
            $vehicleData = $vehicleData[0];
            $form->setData($vehicleData);
            $form->get('module_id')->setValue($vehicleData['id']);
            $data = [
                'mapping_id' => $vehicleData['id'],
                'bkg_type_id' => $this->config()->getConfig()->masterBookingType->hotelId
            ];
            $documentListing = $this->CommonModel->getUploadImages($data);
        }
        $viewModel = new ViewModel([
            'form' => $form,
            'tab' => 'upload-images',
            'documentListing' => $documentListing,
        ]);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-JANUARY-2022
     * @description : FUNCTION FOR UPLOAD IMAGE FILE
     * @param $data
     * @returns $responsedata
     */

    public function uploadfileAction() {
        $sessionuserData = new Container('userlogin');
        $userId = $sessionuserData->user_id;

        $postData = $this->getRequest()->getPost()->toArray();
        $fileName = $postData['fileuploadname'];
        $type = $postData['type'];
        $module_id = $postData['module_id'];
        $bkg_type_id = $this->config()->getConfig()->masterBookingType->hotelId;

        if ($_FILES['file']['name'] != '') {
            $fileNameOfficeAdd = $_FILES['file']['name'];
            $fileTmpNameOfficeAdd = $_FILES['file']['tmp_name'];
            $documentName = $fileName . "_" . time();

            $folderpath = 'hotel_image';
            $uploaddir = $this->config()->getConfig()->base_url->file_path; //$_SERVER['DOCUMENT_ROOT'];

            $allowed = array('png', 'jpg', 'gif', 'zip', 'pdf', 'docx', 'doc', 'jpeg', '');
            $extension = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);

            if (!in_array(strtolower($extension), $allowed)) {
                $data = array("status" => "error", 'message' => 'Please upload (png,jpg,gif,zip,pdf,docx,doc,jpeg) file only.');
                $view = new JsonModel($data);
                return $view;
            }


            $filepath = $uploaddir . $folderpath;
            $fileUploadName = $documentName . '.' . $extension;
            $targetPath = $filepath . "/" . $fileUploadName;

            $kycFile = file_get_contents($fileTmpNameOfficeAdd);
            $base64string = base64_encode($kycFile);

            $finalData['base64image'] = $base64string;
            $finalData['filepath'] = $targetPath;
            $uploadresp = $this->uploadimageapi($finalData);
            if ($uploadresp['status'] == 'failed') {
                $data = array("status" => "error", "message" => $uploadresp['message']);
                return $view = new JsonModel($data);
            }


            $finalData2 = [
                'user_id' => $userId,
                'mapping_id' => $module_id,
                'bkg_type_id' => $bkg_type_id,
                'image_type' => $fileName,
                'doc_file_upload' => $fileUploadName,
                'status' => 1
            ];
            $responseData = $this->CommonModel->uploadImage($finalData2);
            if ($responseData['response']['status'] == 'success') {
                $data = array("status" => "success", 'message' => "File uploaded successfully", "fileUploadName" => $base64string);
            } else {
                $data = array("status" => "error", 'message' => "File not uploaded", "fileUploadName" => $base64string);
            }
        }
        $view = new JsonModel($data);
        return $view;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-JANUARY-2022
     * @description : API FOR UPLOAD IMAGE
     * @param $data
     * @returns $responsedata
     */

    public function uploadimageapi($arrval = array()) {
        $url = $this->apiUrl() . "/user/uploadImg";
        $val = $this->post($url, $arrval);
        $JsonData = $val->getBody();
        $JsonData = Json::decode($JsonData, true);
        return $JsonData['responsedata'];
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-JANUARY-2022
     * @description : FUNCTION FOR UPDATE IMAGE DEFAULT ROOM STATUS
     * @param $data
     * @returns $responsedata
     */

    public function updateImageStatusAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $data = $this->getRequest()->getPost();
        $id = $data['selected'];
        $doc_status = $data['status'];
        $userId = $data['user_id'];
        $data = ['user_id' => $user_id, 'id' => $id, 'status' => $doc_status, 'ip' => $_SERVER['REMOTE_ADDR']];
        $responseData = $this->CommonModel->updateImageStatus($data);
        if ($responseData['response']['status'] == 'success') {
            $data = array("status" => "success", 'message' => "Status Changed successfully");
        } else {
            $data = array("status" => "error", 'message' => "Status not Changed");
        }
        $view = new JsonModel($data);
        return $view;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-JANUARY-2022
     * @description : FUNCTION FOR UPDATE IMAGE DEFAULT ROOM STATUS
     * @param $data
     * @returns $responsedata
     */

    public function updateImageDefaultStatusAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $data = $this->getRequest()->getPost();
        //$id = implode(',', $data['selected']);
        $id = $data['selected'];
        $doc_status = $data['status'];
        $image_type = $data['image_type'];
        $mapping_id = $data['hotel_id'];

        $data2 = ['image_type' => $image_type, 'user_id' => $userId, 'mapping_id' => $mapping_id, 'ip' => $_SERVER['REMOTE_ADDR']];
        $this->CommonModel->resetDefaultImageStatus($data2);

        $data = ['user_id' => $userId, 'id' => $id, 'image_default_status' => $doc_status, 'image_type' => $image_type, 'mapping_id' => $mapping_id, 'ip' => $_SERVER['REMOTE_ADDR']];

        $responseData = $this->CommonModel->updateImageDefaultStatus($data);
        if ($responseData['response']['status'] == 'success') {
            $data = array("status" => "success", 'message' => "Status Changed successfully");
        } else {
            $data = array("status" => "error", 'message' => "Status not Changed");
        }
        $view = new JsonModel($data);
        return $view;
    }

    public function getAjaxVendorListAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $data = [];
        $postData = $this->getRequest()->getPost();
        $company_id = $this->config()->getConfig()->company->companyId;
        $user_type_id = $postData['vendor_type'];
        $data = [
            'company_id' => $company_id,
            'user_type_id' => $user_type_id,
        ];
        $data = array_filter($data);
        $vendorJsonData = $this->CommonModel->getHotelVendorList($data);
        if (!empty($vendorJsonData)) {
            foreach ($vendorJsonData as $value) {
                $userName = $value['username'] . ' (' . $value['mobile_no'] . ')';
                $data1[] = ["id" => $value['id'], "name" => $userName];
            }
            $response = ["status" => true, "data" => $data1];
        } else {
            $response = ["status" => false];
        }
        $view = new JsonModel($response);
        return $view;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-JANUARY-2022
     * @description : FUNCTION FOR NORMAL ROOM RATE
     * @param $data
     * @returns $responsedata
     */

    public function normalRateAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        HotelRoomRateForm::$mealPlanList = $this->CommonModel->getMealPlanList($data);
        HotelRoomRateForm::$hotelSeasonNameList = $this->CommonModel->getHotelSeasonNameList($data);
        HotelRoomRateForm::$weekDaysList = $this->userModel->getWeekDaysList();
        HotelRoomRateForm::$promotionRateTypeList = $this->CommonModel->getPromotionRateTypeList($data);
        $mealPlanList = $this->CommonModel->getMealPlanListData($data);
        $week_days = $this->userModel->getWeekDaysList();
        $form = new HotelRoomRateForm();
        $viewModel = new ViewModel([
            'form' => $form,
            'week_days' => $week_days,
            'mealPlanList' => $mealPlanList
        ]);
        $viewModel->setTemplate('/dashboard/hotel/hotel-contract-rate');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-JANUARY-2022
     * @description : FUNCTION TO UPLOAD THE ROOM IMAGE
     * @param $data
     * @returns $responsedata
     */
    
    public function uploadImageAction() {
    $post = isset($_POST) ? $_POST : array();
        switch ($post['action']) {
            case 'save' :
                $this->saveAvatarTmp();
                break;
            default:
                $this->changeAvatar();
        }
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-JANUARY-2022
     * @description : FUNCTION TO CHANGE THE AVATAR
     * @param $data
     * @returns $responsedata
     */
    
    function changeAvatar() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $post = isset($_POST) ? $_POST : array();
        $max_width = "500";
        $path = 'images/tmp';
        $valid_formats = array("jpg", "png", "gif", "bmp", "jpeg", "pdf", "docx", "doc");
        $name = time() . $_FILES['photoimg']['name'];
        $size = $_FILES['photoimg']['size'];
        if (strlen($name)) {
            list($txt, $ext) = explode(".", $name);
            //Debug::dump($ext);
            //Debug::dump($valid_formats);
            //Debug::dump(in_array($ext, $valid_formats));exit;
            if (in_array($ext, $valid_formats)) {
                if ($size < (1024 * 1024)) { // Image size max 1 MB
                    $actual_image_name = 'avatar' . '_' . $user_id . '.' . $ext;
                    $tmp = $_FILES['photoimg']['tmp_name'];
                    $filePath = PUBLIC_PATH . '/temp/' . $name;
                    $filePreview = '/temp/' . $name;
                    if (move_uploaded_file($tmp, $filePath)) {
                        $width = $this->getWidth($filePath);
                        $height = $this->getHeight($filePath);
                        //Scale the image if it is greater than the width set above
                        if ($width > $max_width) {
                            $scale = $max_width / $width;
                            $uploaded = $this->resizeImage($filePath, $width, $height, $scale);
                        } else {
                            $scale = 1;
                            $uploaded = $this->resizeImage($filePath, $width, $height, $scale);
                        }
                        echo "<img class='photo' file-name='" . $name . "' class='' src='" . $filePreview . '?' . time() . "' class='preview'/>";
                    } else
                        echo "failed";
                } else
                    echo "Image file size max 1 MB";
            } else
                echo "Invalid file format..";
        } else
            echo "Please select image..!";
        exit;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-JANUARY-2022
     * @description : FUNCTION TO SAVE THE UPLOAD IMAGE IN TEMP
     * @param $data
     * @returns $responsedata
     */
    
    function saveAvatarTmp() {

        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $post = isset($_POST) ? $_POST : array();
        $path = '\\images\uploads\tmp';
        $t_width = 300; // Maximum thumbnail width
        $t_height = 300;    // Maximum thumbnail height

        if (isset($_POST['t']) and $_POST['t'] == "ajax") {
            extract($_POST);

            $crop_enabled = $_POST['crop_enabled'];
            $loc = $_POST['loc'];
            $module_id = $_POST['moduleId'];
            $bkg_type_id = $this->config()->getConfig()->masterBookingType->hotelId;
            if ($loc == "main-image" || $loc == "gallery-image") {
                $user_folder = "hotel_image";
            }
            $image_quality = '95';
            $imagePath = PUBLIC_PATH . '/upload/' . $user_folder . '/' . $_POST['image_name'];
            $new_image_thumb = PUBLIC_PATH . '/upload/thumb/100x100/' . $user_folder . '/' . $_POST['image_name'];

            $temp_path = PUBLIC_PATH . '/temp/' . $_POST['image_name'];

            if ($crop_enabled == "yes") {

                $ratio = ($t_width / $w1);
                $nw = ceil($w1 * $ratio);
                $nh = ceil($h1 * $ratio);
                $nimg = imagecreatetruecolor($nw, $nh);
                $im_src = imagecreatefromjpeg($temp_path);
                imagecopyresampled($nimg, $im_src, 0, 0, $x1, $y1, $nw, $nh, $w1, $h1);
                $result = imagejpeg($nimg, $imagePath, $image_quality);

                $crop_width = 30;
                $crop_height = 30;
                $thumbNew = imagecreatetruecolor($crop_width, $crop_height);
                imagecopyresampled($thumbNew, $im_src, 0, 0, $x1, $y1, $crop_width, $crop_height, $w1, $h1);
                $thumb = imagejpeg($thumbNew, $new_image_thumb, $image_quality);
            } elseif ($crop_enabled == "no") {
                //echo 'hello';exit;
                $result = copy($temp_path, $imagePath);
                $result1 = copy($temp_path, $new_image_thumb);
                $filename = $new_image_thumb;
                $image = imagecreatefromjpeg($filename);
                list($originalWidth, $originalHeight) = getimagesize($filename);

                // Size of image to create
                $width = 50;
                $height = 50;

                $background = imagecreatetruecolor($width, $height); //create the background 130x130
                $whiteBackground = imagecolorallocate($background, 255, 255, 255);
                imagefill($background, 0, 0, $whiteBackground); // fill the background with white
                imagecopyresampled($background, $image, 0, 0, 0, 0, $width, $height, $originalWidth, $originalHeight); // copy the image to the background
                header("Content-type: image/jpeg");
                ImageJpeg($background, $new_image_thumb, $image_quality); //display
            }
            //echo '<pre>';print_r();die();
            if ($result) {
                $finalData2 = [
                'user_id' => $userId,
                'mapping_id' => $module_id,
                'bkg_type_id' => $bkg_type_id,
                'image_type' => $loc,
                'doc_file_upload' => $_POST['image_name'],
                'status' => 1
                ];
                $responseData = $this->CommonModel->uploadHotelImage($finalData2);
                $image_path_sql = $user_folder . '/' . $_POST['image_name'];
                $response = '/upload/' . $image_path_sql;
            } else {
                $response = "error";
            }
        }
        //echo $imagePath.'?'.time();;
        echo $response;
        exit(0);
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-JANUARY-2022
     * @description : FUNCTION TO UPLOAD THE ROOM IMAGE
     * @param $data
     * @returns $responsedata
     */
    
    public function uploadRoomImageAction() {
        $post = isset($_POST) ? $_POST : array();
        switch ($post['action']) {
            case 'save' :
                $this->saveRoomAvatarTmp();
                break;
            default:
                $this->changeAvatar();
        }
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-JANUARY-2022
     * @description : FUNCTION TO SAVE THE ROOM IMAGE TEMP
     * @param $data
     * @returns $responsedata
     */
    
     function saveRoomAvatarTmp() {

        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $post = isset($_POST) ? $_POST : array();
        $path = '\\images\uploads\tmp';
        $t_width = 300; // Maximum thumbnail width
        $t_height = 300;    // Maximum thumbnail height

        if (isset($_POST['t']) and $_POST['t'] == "ajax") {
            extract($_POST);

            $crop_enabled = $_POST['crop_enabled'];
            $loc = $_POST['loc'];
            $module_id = $_POST['moduleId'];
            $bkg_type_id = $this->config()->getConfig()->masterBookingType->hotelId;
            if ($loc == "main-image" || $loc == "gallery-image") {
                $user_folder = "hotel_room_image";
            }
            $image_quality = '95';
            $imagePath = PUBLIC_PATH . '/upload/' . $user_folder . '/' . $_POST['image_name'];
            $new_image_thumb = PUBLIC_PATH . '/upload/thumb/100x100/' . $user_folder . '/' . $_POST['image_name'];

            $temp_path = PUBLIC_PATH . '/temp/' . $_POST['image_name'];

            if ($crop_enabled == "yes") {

                $ratio = ($t_width / $w1);
                $nw = ceil($w1 * $ratio);
                $nh = ceil($h1 * $ratio);
                $nimg = imagecreatetruecolor($nw, $nh);
                $im_src = imagecreatefromjpeg($temp_path);
                imagecopyresampled($nimg, $im_src, 0, 0, $x1, $y1, $nw, $nh, $w1, $h1);
                $result = imagejpeg($nimg, $imagePath, $image_quality);

                $crop_width = 30;
                $crop_height = 30;
                $thumbNew = imagecreatetruecolor($crop_width, $crop_height);
                imagecopyresampled($thumbNew, $im_src, 0, 0, $x1, $y1, $crop_width, $crop_height, $w1, $h1);
                $thumb = imagejpeg($thumbNew, $new_image_thumb, $image_quality);
            } elseif ($crop_enabled == "no") {
                //echo 'hello';exit;
                $result = copy($temp_path, $imagePath);
                $result1 = copy($temp_path, $new_image_thumb);
                $filename = $new_image_thumb;
                $image = imagecreatefromjpeg($filename);
                list($originalWidth, $originalHeight) = getimagesize($filename);

                // Size of image to create
                $width = 50;
                $height = 50;

                $background = imagecreatetruecolor($width, $height); //create the background 130x130
                $whiteBackground = imagecolorallocate($background, 255, 255, 255);
                imagefill($background, 0, 0, $whiteBackground); // fill the background with white
                imagecopyresampled($background, $image, 0, 0, 0, 0, $width, $height, $originalWidth, $originalHeight); // copy the image to the background
                header("Content-type: image/jpeg");
                ImageJpeg($background, $new_image_thumb, $image_quality); //display
            }
            //echo '<pre>';print_r();die();
            if ($result) {
                $finalData2 = [
                'user_id' => $userId,
                'room_id' => $module_id,
                'image_type' => $loc,
                'doc_file_upload' => $_POST['image_name'],
                'status' => 1
                ];
                $responseData = $this->CommonModel->uploadHotelRoomImage($finalData2);
                $image_path_sql = $user_folder . '/' . $_POST['image_name'];
                $response = '/upload/' . $image_path_sql;
            } else {
                $response = "error";
            }
        }
        //echo $imagePath.'?'.time();;
        echo $response;
        exit(0);
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-JANUARY-2022
     * @description : FUNCTION TO CHANGE THE ROOM IMAGE STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function updateRoomImageStatusAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $data = $this->getRequest()->getPost();
        $id = $data['selected'];
        $doc_status = $data['status'];
        $userId = $data['user_id'];
        $data = ['user_id' => $user_id, 'id' => $id, 'status' => $doc_status, 'ip' => $_SERVER['REMOTE_ADDR']];
        $responseData = $this->CommonModel->updateRoomImageStatus($data);
        if ($responseData['response']['status'] == 'success') {
            $data = array("status" => "success", 'message' => "Status Changed successfully");
        } else {
            $data = array("status" => "error", 'message' => "Status not Changed");
        }
        $view = new JsonModel($data);
        return $view;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-JANUARY-2022
     * @description : FUNCTION TO CHANGE THE ROOM IMAGE DEFAULT STATUS
     * @param $data
     * @returns $responsedata
     */

    public function updateRoomImageDefaultStatusAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $data = $this->getRequest()->getPost();
        //$id = implode(',', $data['selected']);
        $id = $data['selected'];
        $doc_status = $data['status'];
        $image_type = $data['image_type'];
        $mapping_id = $data['hotel_id'];

        $data2 = ['image_type' => $image_type, 'user_id' => $userId, 'mapping_id' => $mapping_id, 'ip' => $_SERVER['REMOTE_ADDR']];
        $this->CommonModel->resetRoomDefaultImageStatus($data2);

        $data = ['user_id' => $userId, 'id' => $id, 'image_default_status' => $doc_status, 'image_type' => $image_type, 'mapping_id' => $mapping_id, 'ip' => $_SERVER['REMOTE_ADDR']];

        $responseData = $this->CommonModel->updateRoomImageDefaultStatus($data);
        if ($responseData['response']['status'] == 'success') {
            $data = array("status" => "success", 'message' => "Status Changed successfully");
        } else {
            $data = array("status" => "error", 'message' => "Status not Changed");
        }
        $view = new JsonModel($data);
        return $view;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-JANUARY-2022
     * @description : FUNCTION TO CHANGE THE HOTEL PREFERRED DATA STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function changePreferredStatusAction() {
        $status = 0;
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status'] == 0) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->CommonModel->updateHotelPreferredStatus($data);
        }
        $val = ['company_id' => $this->config()->getConfig()->company->companyId];
        $packageListing = $this->CommonModel->getHotelDetailsList($val);
        $viewModel = new ViewModel(['packageListing' => $packageListing]);
        $viewModel->setTemplate('/dashboard/hotel/hotel-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
     /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-JANUARY-2022
     * @description : FUNCTION TO CHANGE THE HOTEL PREFERRED DATA STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function hotelPreferredStatusAction() {
        $data1 = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $data = $this->getRequest()->getPost();
        $id = implode(',', $data['selected']);
        $status = $data['status'];
        $data = ['user_id' => $user_id, 'id' => $id, 'status' => $status];
        $this->CommonModel->updateHotelPreferredStatus($data);
        $val = ['company_id' => $this->config()->getConfig()->company->companyId];
        $packageListing = $this->CommonModel->getHotelDetailsList($val);
        $viewModel = new ViewModel(['packageListing' => $packageListing]);
        $viewModel->setTemplate('/dashboard/hotel/hotel-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-JANUARY-2022
     * @description : FUNCTION TO ADD THE HOTEL DATA
     * @param $data
     * @returns $responsedata
     */
    
    public function getHotelDataAction() {
        $data = [];
        $postData = $this->getRequest()->getPost();
        $term = $postData['term'];
        $url = $this->apiUrl() . "/hotel-detail/getHotelDetailsList?hotel_name=" . $term;
        $resp = $this->get($url);
        $cityJsonData = Json::decode($resp->getBody(), true);
        $cityData = $cityJsonData['response']['data'];
        if ($cityJsonData['response']['status']=="success") {
            foreach ($cityData as $value) {
                $data[] = ["hotel_id" => $value['id'], "label" => $value['name']];
            }
        } else {
            $data[] = ["label" => 'Not Exist'];
        }
        $view = new JsonModel($data);
        return $view;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-JANUARY-2022
     * @description : FUNCTION TO ADD THE HOTEL VENDOR
     * @param $data
     * @returns $responsedata
     */
    
    
    public function addHotelVendorAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        HotelForm::$property_type = $this->CommonModel->getPropertyTypeList();
        HotelForm::$hotel_category = $this->CommonModel->getHotelCategoryList();
        $form = new HotelForm();
        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            //echo '<pre>';print_r($postData);
            $form->setData($postData);
            if ($form->isValid()) {
                $finalData = [];
                $mappingData = [];
                $finalData = [
                    'company_id' => $this->config()->getConfig()->company->companyId,
                    'code' => $this->generateHotelCode($postData['destination_city_id']),
                    'name' => $postData['name'],
                    'property_type' => $postData['property_type'],
                    'hotel_category' => $postData['hotel_category'],                  
                    'city_id' => $postData['destination_city_id'],                    
                    'hotel_id' => $postData['hotel_id'],                    
                    'created_date' => date('Y-m-d H:i:s'),
                    'user_id' => $userId,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];
              
                //echo'<pre>';print_r($finalData);//die();
                $responseData = $this->CommonModel->getHotelDataById($finalData);
                if($responseData['responsedata']['status'] != 'success'){
                    $response = $this->CommonModel->insertVendorHotelDetails($finalData);
                    if($response['responsedata']['status']== 'success'){
                        $hotelId = $response['responsedata']['data'];
                    }else{
                        $hotelId = $postData['hotel_id'];
                    }
                }else{
                    $hotelId = $postData['hotel_id'];
                }
                
                $mappingData = [
                    'hotel_id' => $hotelId,
                    'vendor_id' => $userId,
                    'created_date' => date('Y-m-d H:i:s'),
                    'user_id' => $userId,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];               
                
                $responseMappingData = $this->CommonModel->insertHotelVendorMapping($mappingData);            
                
                if ($responseMappingData['response']['status'] == 'success') {
                    $msg = "Details Added Successfully!..";
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Details Could Not Added!..";
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
                $this->redirect()->toRoute('hotel', ['action' => 'index']);
            } else {
                $msg = $form->getMessages();
                echo '<pre>';
                print_r($msg);
                die();
            }
        }
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        $packageListing = $this->CommonModel->getHotelDetailsList($data);
        $viewModel = new ViewModel(['form' => $form, 'tab' => 'add-hotel', 'packageListing' => $packageListing]);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 15-April-2022
     * @description : FUNCTION TO CHANGE THE NORAM CANCEL FEES FARE
     * @param $data
     * @returns $responsedata
     */
    
    public function addNormalCancelFareAction() {
        $cancellation_fare = "";
        $feesFareDetails = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        $id = $this->params()->fromQuery('id');
        $rate_type = $this->params()->fromQuery('rate_type');
        $room_id = $this->params()->fromQuery('room_id');
        $currency_id = $this->params()->fromQuery('currency_id');
        $vendor_type = $this->params()->fromQuery('vendor_type');
        $vendor_id = $this->params()->fromQuery('vendor_id');
        $rate_name_id = $this->params()->fromQuery('rate_name_id');
        $rate_type_id = $this->params()->fromQuery('rate_type_id');
        $cancel_date_from = $this->params()->fromQuery('cancel_date_from');
        $cancel_date_to = $this->params()->fromQuery('cancel_date_to');
        $request = $this->getRequest();
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        $dataVendor = ['booking_type_id' => $this->config()->getConfig()->masterBookingType->hotelId];
        $type = [
            'booking_type_id'=>$this->config()->getConfig()->masterBookingType->hotelId,
        ];
        HotelCancellationFeesForm::$cancellation_type = $this->CommonModel->getMasterCancellationTypeList($type);
        HotelCancellationFeesForm::$booking_type = $this->CommonModel->getHotelList($data);
        HotelCancellationFeesForm::$vendorTypeList = $this->CommonModel->getHotelVendorTypeList($dataVendor);
        HotelCancellationFeesForm::$currenyList = $this->CommonModel->getCurrencyList();
        HotelCancellationFeesForm::$hotelRateNameList = $this->CommonModel->getHotelRateNameList($data);

        $form = new HotelCancellationFeesForm();
        
        if(!empty($id)){
            $data = [
            'auto_id' => $id
            ];
            $vehicleData = $this->CommonModel->getHotelDetailsList($data);
            $vehicleData = $vehicleData[0];
            $dataRooms = [
                'company_id' => $this->config()->getConfig()->company->companyId,
                'hotel_id' => $vehicleData['id']
            ];
            $roomList = $this->CommonModel->getHotelRoomList($dataRooms);
            $dataCancel = [
                'hotel_id'=>$id,
                'rate_type'=> 'Normal Rate',
            ];
            
            $form->get('room_id')->setValueOptions($roomList);
            $form->get('hotel_id')->setValue($vehicleData['id']);
        }
        if(!empty($rate_type) && !empty($room_id)){
            
            $dataEditCancel = [
                'hotel_id'=>$id,
                'rate_type'=> $rate_type,
                'room_id'=> $room_id,
                'currency_id'=> $currency_id,
                'vendor_type'=> $vendor_type,
                'vendor_id'=> $vendor_id,
                'rate_name_id'=> $rate_name_id,
                'rate_type_id'=> $rate_type_id,
                'cancel_date_from'=> $cancel_date_from,
                'cancel_date_to'=> $cancel_date_to,
            ];
            $cancellation_fare = $this->CommonModel->getHotelCancellationFare($dataEditCancel);
            //echo "<pre>";            print_r($cancellation_fare); die;   
            //echo $cancellation_fare[0]['room_id']; die;
            $form->get('room_id')->setValue($cancellation_fare[0]['room_id']);
            $form->get('currency')->setValue($cancellation_fare[0]['currency_id']);
            $form->get('vendor_type')->setValue($cancellation_fare[0]['vendor_type']);
            //$form->setData($cancellation_fare[0]['room_id']);
            if ($cancellation_fare[0]['cancel_date_from'] != '0000-00-00') {
                $form->get('cancel_date_from')->setValue(date('d-m-Y', strtotime($cancellation_fare[0]['cancel_date_from'])));
            }
            if ($cancellation_fare[0]['cancel_date_to'] != '0000-00-00') {
                $form->get('cancel_date_to')->setValue(date('d-m-Y', strtotime($cancellation_fare[0]['cancel_date_to'])));
            }
            
            $dataVendorList = [
                'company_id' => $this->config()->getConfig()->company->companyId,
                'user_type_id' => $cancellation_fare[0]['vendor_type'],
            ];
            //var_dump($dataVendorList); die;
            $vendorUserData = $this->CommonModel->getHotelVendorListData($dataVendorList);
            $form->get('vendor_name')->setValueOptions($vendorUserData);
            $form->get('vendor_name')->setValue( $cancellation_fare[0]['vendor_id']);
            $form->get('hotel_rate_name')->setValue( $cancellation_fare[0]['rate_name_id']);
        }
        
        
        $feesFareDetails = $this->CommonModel->getHotelCancellationFare($dataCancel);        
        //$cancellation_fare = $this->CommonModel->getUserCancellationFare($login_id);
        $fareDetails = [
            'cancellation_fare' => $cancellation_fare,
        ];
        //$user_id = 6;
        if ($request->isPost()) {
            $postdata = $this->getRequest()->getPost()->toArray();
           //echo '<pre>';print_r($postdata);die();
            //$cancellation_fees_autoid = $postdata['cancellation_fees_id'];          

            $cancellation_master_id = array_values(array_filter($postdata['cancellation_master_id']));
            $cancellation_type = array_values(array_filter($postdata['cancellation_type']));
            $cancellation_fees = array_values(array_filter($postdata['cancellation_fees']));
            
            if (!empty($cancellation_master_id) && !empty($cancellation_type)) {
                if (count($cancellation_master_id) > 0) {
                    for ($i = 0; $i < count($cancellation_master_id); $i++) {
                        $cancelFeesArr[] = [
                            'user_id' => $login_id,
                            'cancellation_master_id' => $cancellation_master_id[$i],
                            'cancellation_type' => $cancellation_type[$i],
                            'cancellation_value' => $cancellation_fees[$i],
                            'created_by' => $login_id,
                            'status' => 1,
                            'ip' => $_SERVER['REMOTE_ADDR'],
                            'hotel_id' => $postdata['hotel_id'],
                            'room_id' => $postdata['room_id'],
                            'currency_id' => $postdata['currency'],
                            'vendor_type' => $postdata['vendor_type'],
                            'vendor_id' => $postdata['vendor_name'],
                            'rate_type' => "Normal Rate",
                            'rate_type_id' => 0,
                            'rate_name_id' => $postdata['hotel_rate_name'],
                            'cancel_date_from' => date('Y-m-d', strtotime($postdata['cancel_date_from'])),
                            'cancel_date_to' => date('Y-m-d', strtotime($postdata['cancel_date_to'])),
                        ];
                    }
                }
            }
            $cancelFeesArr1['cancelfaredata'] = $cancelFeesArr;
            $cancelFeesArr1['hotel_id'] = $postdata['hotel_id'];
            $cancelFeesArr1['room_id'] = $postdata['room_id'];
            $cancelFeesArr1['currency_id'] = $postdata['currency'];
            $cancelFeesArr1['vendor_type'] = $postdata['vendor_type'];
            $cancelFeesArr1['vendor_id'] = $postdata['vendor_name'];
            $cancelFeesArr1['rate_type'] = "Normal Rate";
            $cancelFeesArr1['rate_name_id'] = $postdata['hotel_rate_name'];
            $cancelFeesArr1['user_id'] = $login_id;
            $cancelFeesArr1['rate_type_id'] = 0;
            $cancelFeesArr1['cancel_date_from'] = date('Y-m-d', strtotime($postdata['cancel_date_from']));
            $cancelFeesArr1['cancel_date_to'] = date('Y-m-d', strtotime($postdata['cancel_date_to']));

            //echo '<pre>';print_r($cancelFeesArr1);die();
            $resp = $this->CommonModel->addHotelCancellationFareDetail($cancelFeesArr1);
            //echo '<pre>';print_r($resp);die();
            $this->redirect()->toRoute('hotel', ['action' => 'add-normal-cancel-fare'],['query' => array('id' => $postdata['hotel_id'])]);
            $msg = "Data Updated Successfully";
            $this->flashMessenger()->addMessage(array('success' => $msg));
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'normal_cancel_fees', 'fareDetails'=>$fareDetails, 'feesFareDetails'=>$feesFareDetails]);
        return $viewModel;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 15-April-2022
     * @description : FUNCTION TO ADD THE PACKAGE CANCEL FEES FARE
     * @param $data
     * @returns $responsedata
     */
    
    
    public function addPackageCancelFareAction() {
        $cancellation_fare = "";
        $feesFareDetails = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        $id = $this->params()->fromQuery('id');
        $rate_type = $this->params()->fromQuery('rate_type');
        $room_id = $this->params()->fromQuery('room_id');
        $currency_id = $this->params()->fromQuery('currency_id');
        $vendor_type = $this->params()->fromQuery('vendor_type');
        $vendor_id = $this->params()->fromQuery('vendor_id');
        $rate_name_id = $this->params()->fromQuery('rate_name_id');
        $rate_type_id = $this->params()->fromQuery('rate_type_id');
        $cancel_date_from = $this->params()->fromQuery('cancel_date_from');
        $cancel_date_to = $this->params()->fromQuery('cancel_date_to');
        $rate_type_name = $this->params()->fromQuery('rate_type_name');
        $request = $this->getRequest();
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        $dataVendor = ['booking_type_id' => $this->config()->getConfig()->masterBookingType->hotelId];
        $type = [
            'booking_type_id'=>$this->config()->getConfig()->masterBookingType->hotelId,
        ];
        HotelCancellationFeesForm::$cancellation_type = $this->CommonModel->getMasterCancellationTypeList($type);
        HotelCancellationFeesForm::$booking_type = $this->CommonModel->getHotelList($data);
        HotelCancellationFeesForm::$vendorTypeList = $this->CommonModel->getHotelVendorTypeList($dataVendor);
        HotelCancellationFeesForm::$currenyList = $this->CommonModel->getCurrencyList();
        HotelCancellationFeesForm::$hotelRateNameList = $this->CommonModel->getHotelRateNameList($data);

        $form = new HotelCancellationFeesForm();
        $rateType = $this->params()->fromQuery('rate_type');
        if(!empty($id)){
            $data = [
            'auto_id' => $id
            ];
            $vehicleData = $this->CommonModel->getHotelDetailsList($data);
            $vehicleData = $vehicleData[0];
            $dataRooms = [
                'company_id' => $this->config()->getConfig()->company->companyId,
                'hotel_id' => $vehicleData['id']
            ];
            $roomList = $this->CommonModel->getHotelRoomList($dataRooms);
            $dataCancel = [
                'hotel_id'=>$id,
                'rate_type'=> 'Package Rate',
                'rate_type_id'=>$rateType
            ];
            //$cancellation_fare = $this->CommonModel->getHotelCancellationFare($dataCancel);
            $form->get('room_id')->setValueOptions($roomList);
            $form->get('hotel_id')->setValue($vehicleData['id']);
            $form->get('rate_type_id')->setValue($rateType);
        }
        
         if(!empty($rate_type) && !empty($room_id)){
            
            $dataEditCancel = [
                'hotel_id'=>$id,
                'rate_type'=> $rate_type_name,
                'room_id'=> $room_id,
                'currency_id'=> $currency_id,
                'vendor_type'=> $vendor_type,
                'vendor_id'=> $vendor_id,
                'rate_name_id'=> $rate_name_id,
                'rate_type_id'=> $rate_type_id,
                'cancel_date_from'=> $cancel_date_from,
                'cancel_date_to'=> $cancel_date_to,
            ];
            //echo "<pre>"; print_r($dataEditCancel); die;
            $cancellation_fare = $this->CommonModel->getHotelCancellationFare($dataEditCancel);
            //echo "<pre>";            print_r($cancellation_fare); die;   
            //echo $cancellation_fare[0]['room_id']; die;
            $form->get('room_id')->setValue($cancellation_fare[0]['room_id']);
            $form->get('currency')->setValue($cancellation_fare[0]['currency_id']);
            $form->get('vendor_type')->setValue($cancellation_fare[0]['vendor_type']);
            //$form->setData($cancellation_fare[0]['room_id']);
            if ($cancellation_fare[0]['cancel_date_from'] != '0000-00-00') {
                $form->get('cancel_date_from')->setValue(date('d-m-Y', strtotime($cancellation_fare[0]['cancel_date_from'])));
            }
            if ($cancellation_fare[0]['cancel_date_to'] != '0000-00-00') {
                $form->get('cancel_date_to')->setValue(date('d-m-Y', strtotime($cancellation_fare[0]['cancel_date_to'])));
            }
            
            $dataVendorList = [
                'company_id' => $this->config()->getConfig()->company->companyId,
                'user_type_id' => $cancellation_fare[0]['vendor_type'],
            ];
            //var_dump($dataVendorList); die;
            $vendorUserData = $this->CommonModel->getHotelVendorListData($dataVendorList);
            $form->get('vendor_name')->setValueOptions($vendorUserData);
            $form->get('vendor_name')->setValue( $cancellation_fare[0]['vendor_id']);
            $form->get('hotel_rate_name')->setValue( $cancellation_fare[0]['rate_name_id']);
        }
        
        
        $feesFareDetails = $this->CommonModel->getHotelCancellationFare($dataCancel);        
        //$cancellation_fare = $this->CommonModel->getUserCancellationFare($login_id);
        $fareDetails = [
            'cancellation_fare' => $cancellation_fare,
        ];
        //$user_id = 6;
        if ($request->isPost()) {
            $postdata = $this->getRequest()->getPost()->toArray();
           //echo '<pre>';print_r($postdata);die();
            //$cancellation_fees_autoid = $postdata['cancellation_fees_id'];          

            $cancellation_master_id = array_values(array_filter($postdata['cancellation_master_id']));
            $cancellation_type = array_values(array_filter($postdata['cancellation_type']));
            $cancellation_fees = array_values(array_filter($postdata['cancellation_fees']));
            
            if (!empty($cancellation_master_id) && !empty($cancellation_type)) {
                if (count($cancellation_master_id) > 0) {
                    for ($i = 0; $i < count($cancellation_master_id); $i++) {
                        $cancelFeesArr[] = [
                            'user_id' => $login_id,
                            'cancellation_master_id' => $cancellation_master_id[$i],
                            'cancellation_type' => $cancellation_type[$i],
                            'cancellation_value' => $cancellation_fees[$i],
                            'created_by' => $login_id,
                            'status' => 1,
                            'ip' => $_SERVER['REMOTE_ADDR'],
                            'hotel_id' => $postdata['hotel_id'],
                            'room_id' => $postdata['room_id'],
                            'currency_id' => $postdata['currency'],
                            'vendor_type' => $postdata['vendor_type'],
                            'vendor_id' => $postdata['vendor_name'],
                            'rate_type' => "Package Rate",
                            'rate_type_id' => $postdata['rate_type_id'],
                            'rate_name_id' => $postdata['hotel_rate_name'],
                            'cancel_date_from' => date('Y-m-d', strtotime($postdata['cancel_date_from'])),
                            'cancel_date_to' => date('Y-m-d', strtotime($postdata['cancel_date_to'])),
                        ];
                    }
                }
            }
            $cancelFeesArr1['cancelfaredata'] = $cancelFeesArr;
            $cancelFeesArr1['hotel_id'] = $postdata['hotel_id'];
            $cancelFeesArr1['room_id'] = $postdata['room_id'];
            $cancelFeesArr1['currency_id'] = $postdata['currency'];
            $cancelFeesArr1['vendor_type'] = $postdata['vendor_type'];
            $cancelFeesArr1['vendor_id'] = $postdata['vendor_name'];
            $cancelFeesArr1['rate_type'] = "Package Rate";
            $cancelFeesArr1['rate_name_id'] = $postdata['hotel_rate_name'];
            $cancelFeesArr1['user_id'] = $login_id;
            $cancelFeesArr1['rate_type_id'] = $postdata['rate_type_id'];
            $cancelFeesArr1['cancel_date_from'] = date('Y-m-d', strtotime($postdata['cancel_date_from']));
            $cancelFeesArr1['cancel_date_to'] = date('Y-m-d', strtotime($postdata['cancel_date_to']));

            //echo '<pre>';print_r($cancelFeesArr1);die();
            $resp = $this->CommonModel->addHotelCancellationFareDetail($cancelFeesArr1);
            //echo '<pre>';print_r($resp);die();
            $this->redirect()->toRoute('hotel', ['action' => 'add-package-cancel-fare'],['query' => array('id' => $postdata['hotel_id'],'rate_type' => $postdata['rate_type_id'])]);
            $msg = "Data Updated Successfully";
            $this->flashMessenger()->addMessage(array('success' => $msg));
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'package_cancel_fees', 'rateType'=>$rateType, 'fareDetails'=>$fareDetails, 'feesFareDetails'=>$feesFareDetails]);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 15-April-2022
     * @description : FUNCTION TO CHANGE THE NORMAL CANCEL FEES STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function changeNormalCancelfeesStatusAction() {
        $status = 0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status']==0 || $postData['status']==2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->CommonModel->updateHotelCancelFeesStatus($data);
        }
        $dataCancel = [
                'hotel_id'=>$postData['value'],
                'rate_type'=> 'Normal Rate',
        ];
        $feesFareDetails = $this->CommonModel->getHotelCancellationFare($dataCancel);
        $viewModel = new ViewModel(['feesFareDetails' => $feesFareDetails]);
        $viewModel->setTemplate('/dashboard/hotel/fees-fare-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 15-April-2022
     * @description : FUNCTION TO CHANGE THE PACKAGE CANCEL FEES STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function changePackageCancelfeesStatusAction() {
        $status = 0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status']==0 || $postData['status']==2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->CommonModel->updateHotelCancelFeesStatus($data);
        }
        $dataCancel = [
                'hotel_id'=>$postData['value'],
                'rate_type'=> 'Package Rate',
                'rate_type_id'=>$postData['rateTypeId'],
        ];
        $feesFareDetails = $this->CommonModel->getHotelCancellationFare($dataCancel);
        $viewModel = new ViewModel(['feesFareDetails' => $feesFareDetails]);
        $viewModel->setTemplate('/dashboard/hotel/package-fees-fare-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 15-April-2022
     * @description : FUNCTION TO DELETE THE NORMAL CANCEL FEES STATUS
     * @param $data
     * @returns $responsedata
     */   
    
    public function deleteNormalCancelfeesStatusAction() {
        $status = 0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => 2];
            $this->CommonModel->updateHotelCancelFeesStatus($data);
        }
        $dataCancel = [
                'hotel_id'=>$postData['value'],
                'rate_type'=> 'Normal Rate',
        ];
        $feesFareDetails = $this->CommonModel->getHotelCancellationFare($dataCancel);
        $viewModel = new ViewModel(['feesFareDetails' => $feesFareDetails]);
        $viewModel->setTemplate('/dashboard/hotel/fees-fare-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 15-April-2022
     * @description : FUNCTION TO DELETE THE PACKAGE CANCEL FEES STATUS
     * @param $data
     * @returns $responsedata
     */    
    
    public function deletePackageCancelfeesStatusAction() {
        $status = 0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => 2];
            $this->CommonModel->updateHotelCancelFeesStatus($data);
        }
        $dataCancel = [
                'hotel_id'=>$postData['value'],
                'rate_type'=> 'Package Rate',
                'rate_type_id'=>$postData['rateTypeId'],
        ];
        $feesFareDetails = $this->CommonModel->getHotelCancellationFare($dataCancel);
        $viewModel = new ViewModel(['feesFareDetails' => $feesFareDetails]);
        $viewModel->setTemplate('/dashboard/hotel/package-fees-fare-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 15-April-2022
     * @description : FETCH THE ROOM RATE COMMISSION INFO DATA
     * @param $data
     * @returns $responsedata
     */
    
    public function roomRateCommissionInfoAction() {
        $post = $this->getRequest()->getPost();
        $id = $post['room_id'];
        $roomCommissionData = [];
        if(!empty($id)) {
            $data = [
            'mapping_id' => $id,
            'bkg_type_id'=> $this->config()->getConfig()->masterBookingType->hotelId
            ];
        $roomCommissionData = $this->CommonModel->getRoomRateCommissionFareList($data);
        $roomServiceData = $this->CommonModel->getRoomServiceChargeFareList($data);
        $roomTaxData = $this->CommonModel->getHotelBasicTax($data);
        $roomDiscountData = $this->CommonModel->getRoomRateDiscountFareList($data);
        }

        $viewModel = new ViewModel([
            'roomCommissionData' => $roomCommissionData, 
            'roomServiceData' => $roomServiceData, 
            'roomTaxData'=>$roomTaxData, 
            'roomDiscountData'=>$roomDiscountData
        ]);
        $viewModel->setTemplate('/dashboard/hotel/room-commission-info');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
}
