<?php

namespace Dashboard\Controller;

use Application\Controller\RestAPIClientController;
use Dashboard\Form\{
    CityPageForm
};
use Zend\View\Model\{
    ViewModel,
    JsonModel
};
use Zend\Json\Json;
use Zend\Session\Container;
use Zend\Debug\Debug;
use Dashboard\Model\CommonModel;

class CityPageController extends RestAPIClientController {

    public function __construct() {
        $this->CommonModel = new CommonModel();
    }

    public function indexAction() {
        $data = "";
        $status = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;

        CityPageForm::$booking_type = $this->getPackageTypeList();
        $form = new CityPageForm();
        $data = ['user_id' => $login_id];
        $mvehicleList = $this->CommonModel->getCityPageDetail($data);
        $viewModel = new ViewModel(['form' => $form, 'mvehicleList' => $mvehicleList, 'status' => $status]);
        return $viewModel;
    }

    public function searchCityPageAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $val = $this->getRequest()->getPost();
        $data = [
            'booking_type' => $val['booking_type'],
            'status' => $val['status'],
            'user_id' => $user_id,
        ];
        //Call API...
        $mvehicleList = $this->CommonModel->getCityPageDetail($data);
        //echo '<pre>';print_r($mvehicleList);die();
        $viewModel = new ViewModel(['mvehicleList' => $mvehicleList]);
        $viewModel->setTemplate('/dashboard/city-page/city-page-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    public function addCityPageAction() {
        $data = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        CityPageForm::$booking_type = $this->getPackageTypeList();
        $form = new CityPageForm();
        $request = $this->getRequest();
        if ($request->isPost()) {
            $post = $request->getPost()->toArray();
            $form->setData($post);
            if ($form->isValid()) {
                //echo '<pre>';print_r($post);die();
                $data = [];
                if (isset($_FILES['city_page_image']['name']) && $_FILES['city_page_image']['name'] != '') {
                    $file = $_FILES['city_page_image']['tmp_name'];
                    $file    = file_get_contents($file);
                    $base64string    = base64_encode($file);
                    $uploaddir = $_SERVER['DOCUMENT_ROOT'];
                    $file = '/upload/city_image/';
                    $fileName= time() .'-'. $_FILES['city_page_image']['name'];
                    $filepath = $uploaddir . $file . $fileName;
                    $data1['base64image']= $base64string;
                    $data1['filepath']= $filepath;
                    $this->CommonModel->uploadimageapi($data1);
                }else{
                    $base64string = "";
                }
                $data = [                    
                    'company_setup_id' => $this->config()->getConfig()->company->companyId,
                    'city_id' => $post['fare_city_id'],
                    'booking_type' => $post['booking_type'],
                    'page_title' => $post['page_title'],
                    'page_desc' => $post['page_desc'],
                    'meta_title' => $post['meta_title'],
                    'meta_keywords' => $post['meta_keywords'],
                    'meta_desc' => $post['meta_desc'],
                    'no_of_sightseeing' => $post['no_of_sightseeing'],
                    'no_of_hotels' => $post['no_of_hotels'],
                    'no_of_offers' => $post['no_of_offers'],
                    'image_path' => $fileName,
                    'status' => $post['status'],
                    'created_by' => $user_id,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];
                $insertStatus = $this->CommonModel->addCityPageDetail($data);
                //echo '<pre>';print_r($insertStatus);die();
                if ($insertStatus['responsedata']['status'] == "success") {
                    $this->flashMessenger()->addMessage(array('success' => 'City Pages Details added successfully...'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'Something Went Wrong ...'));
                }
                $this->redirect()->toRoute('city-page', ['action' => 'index']);
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }
    
    public function editCityPageAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        CityPageForm::$booking_type = $this->getPackageTypeList();
        $form = new CityPageForm();
        

        $request = $this->getRequest();
        $id = $this->params()->fromQuery('id');
        $data=[
            'auto_id'=>$id
        ];
        //echo '<pre>';print_r($data);//die();
        if($data!=""){
        $vehicleData = $this->CommonModel->getCityPageDetail($data);
        $vehicleData = $vehicleData[0];
        $city_name  =   $this->CommonModel->getCityName($vehicleData['city_id']);
        //Debug::dump($vehicleData); exit;
        $bookingType = isset($vehicleData['master_package_id'])?$vehicleData['master_package_id']:'';
        $vehicleTypeStatus = $vehicleData['status'];
        $form->setData($vehicleData);
        $form->get('fare_city')->setValue($city_name['name']);
        $form->get('fare_city_id')->setValue($vehicleData['city_id']);
        $form->get('booking_type')->setValue($bookingType);
        $form->get('vehicle_type_id')->setValue($vehicleData['id']);
        }
        $request = $this->getRequest();
        if ($request->isPost()) {
            $post = $request->getPost()->toArray();
            $form->setData($post);
            if ($form->isValid()) {
                $data1=[
                'auto_id'=>$post['vehicle_type_id']
                ];
                //echo '<pre>';print_r($data1);//die();
                $vehicleData1 = $this->CommonModel->getCityPageDetail($data1);
                $vehicleData1 = $vehicleData1[0];
                //echo '<pre>';print_r($vehicleData1);die();
                $data = [];
                if (isset($_FILES['city_page_image']['name']) && $_FILES['city_page_image']['name'] != '') {
                    $file = $_FILES['city_page_image']['tmp_name'];
                    $file    = file_get_contents($file);
                    $base64string    = base64_encode($file);
                    $uploaddir = $_SERVER['DOCUMENT_ROOT'];
                    $file = '/upload/city_image/';
                    $fileName= time() .'-'. $_FILES['city_page_image']['name'];
                    $filepath = $uploaddir . $file . $fileName;
                    $data1['base64image']= $base64string;
                    $data1['filepath']= $filepath;
                    $this->CommonModel->uploadimageapi($data1);
                }else{
                    $base64string = "";
                    $fileName = $vehicleData1['image_path'];
                }
                
                //die;
                $data = [
                    'auto_id' => $post['vehicle_type_id'],
                    'company_setup_id' => $this->config()->getConfig()->company->companyId,
                    'city_id' => $post['fare_city_id'],
                    'booking_type' => $post['booking_type'],
                    'page_title' => $post['page_title'],
                    'page_desc' => $post['page_desc'],
                    'meta_title' => $post['meta_title'],
                    'meta_keywords' => $post['meta_keywords'],
                    'meta_desc' => $post['meta_desc'],
                    'no_of_sightseeing' => $post['no_of_sightseeing'],
                    'no_of_hotels' => $post['no_of_hotels'],
                    'no_of_offers' => $post['no_of_offers'],
                    'image_path' => $fileName,
                    'status' => $post['status'],
                    'modified_by' => $user_id,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];               
                //echo '<pre>';print_r($data);die();
                $insertStatus = $this->CommonModel->updateCityPageDetail($data);
                if ($insertStatus['responsedata']['status'] == "success") {
                    $this->flashMessenger()->addMessage(array('success' => 'Conversion Details updated successfully...'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'No Duplicate Entry Please....'));
                }
                $this->redirect()->toRoute('city-page', ['action' => 'index']);
            }
        }


        $viewModel = new ViewModel(['form' => $form,  'vehicle_type_id' => $id, 'status' => $vehicleTypeStatus , 'image'=>$vehicleData['image_path']]);
        return $viewModel;
    }
    
    /** Function to change VEHICLE TYPE STATUS */
    public function cityPageStatusAction() {
        $data1 = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $data = $this->getRequest()->getPost();
        //print_r($data); die;
        $id = implode(',', $data['selected']);
        $page_status = $data['status'];
        $data = ['user_id' => $user_id, 'id' => $id, 'city_pages_status' => $page_status];
        $this->CommonModel->updateCityPageStatus($data);
        $val = ['user_id' => $user_id];
        $mvehicleList = $this->CommonModel->getCityPageDetail($val);
        $viewModel = new ViewModel(['mvehicleList' => $mvehicleList]);
        $viewModel->setTemplate('/dashboard/city-page/city-page-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function getPackageTypeList() {
        $packageTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/package";
        $resp = $this->get($url);
        $packageTypeJsonData = Json::decode($resp->getBody(), true);
        if (count($packageTypeJsonData['data']) > 0) {
            foreach ($packageTypeJsonData['data'] as $res) {
                $packageTypeJsonDataArray[$res['id']] = $res['name'];
            }
            $packageTypeJsonDataArray['100']='Main Page';
        }
        return $packageTypeJsonDataArray;
    }
    
    

}
