<?php

namespace Dashboard\Controller;

use Zend\Mvc\Controller\AbstractActionController;
use Application\Controller\RestAPIClientController;
use Dashboard\Form\CityInstructionForm;
use Zend\View\Model\{
    ViewModel,
    JsonModel
};
use Zend\Json\Json;
use Zend\Session\Container;
use Zend\Debug\Debug;
use Dashboard\Model\CommonModel;
use Dashboard\Model\User;

class CityInstructionController extends RestAPIClientController {

    public function __construct() {
        $this->CommonModel = new CommonModel();
        $this->userModel = new User();
    }

    /**
     * Index
     * @return ViewModel
     */
    public function indexAction() {
        $form = new CityInstructionForm();
        $data = [];
        $pStrtuctureList = $this->CommonModel->getCityIntroductionDetails($data);
        $viewModel = new ViewModel(['pStrtuctureList' => $pStrtuctureList]);
        return $viewModel;
    }

    public function addCityInstructionAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        CityInstructionForm::$booking_type = $this->CommonModel->getTourTypeList();
        $form = new CityInstructionForm();
        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();
                $data = [];
                if (isset($_FILES['thumb_image']['name']) && $_FILES['thumb_image']['name'] != '') {
                    $file = $_FILES['thumb_image']['tmp_name'];
                    $file    = file_get_contents($file);
                    $base64string    = base64_encode($file);
                    $uploaddir = $_SERVER['DOCUMENT_ROOT'];
                    $file = '/upload/city-instruction-image/';
                    $fileName= time() .'-'. $_FILES['thumb_image']['name'];
                    $filepath = $uploaddir . $file . $fileName;
                    $data1['base64image']= $base64string;
                    $data1['filepath']= $filepath;
                    $this->CommonModel->uploadimageapi($data1);
                }else{
                    $base64string = "";
                }
                $data = [
                    'city_id' => $post['destination_city_id'],
                    'booking_type' => $post['booking_type'],
                    'title' => $post['title'],
                    'description' => $post['description'],
                    'image_path' => $fileName,
                    'status' => 1,
                    'created_by' => $user_id,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];
                $insertStatus = $this->CommonModel->addCityIntroductionDetails($data);
                if ($insertStatus['responsedata']['status'] == "success") {
                    $this->flashMessenger()->addMessage(array('success' => 'Details added successfully...'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'Somet thing Went Wrong'));
                }
                $this->redirect()->toRoute('city-instruction', ['action' => 'index']);
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    public function editCityInstructionAction() {
        $sessionUser = new Container('userlogin');
        $user_id = $sessionUser->userData['user_id'];
        CityInstructionForm::$booking_type = $this->CommonModel->getTourTypeList();
        $form = new CityInstructionForm();
        $id = $this->params()->fromQuery('id');
        $data = [
            'auto_id' => $id
        ];
        $vehicleData = $this->CommonModel->getCityIntroductionDetails($data);
        $vehicleData = $vehicleData[0];
        $form->setData($vehicleData);
        $form->get('id')->setValue($vehicleData['id']);
        $form->get('destination_city')->setValue($vehicleData['city_name']);
        $form->get('destination_city_id')->setValue($vehicleData['city_id']);
        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();
                $data = [];
                if (isset($_FILES['thumb_image']['name']) && $_FILES['thumb_image']['name'] != '') {
                    $file = $_FILES['thumb_image']['tmp_name'];
                    $file    = file_get_contents($file);
                    $base64string    = base64_encode($file);
                    $uploaddir = $_SERVER['DOCUMENT_ROOT'];
                    $file = '/upload/city-instruction-image/';
                    $fileName= time() .'-'. $_FILES['thumb_image']['name'];
                    $filepath = $uploaddir . $file . $fileName;
                    $data1['base64image']= $base64string;
                    $data1['filepath']= $filepath;
                    $this->CommonModel->uploadimageapi($data1);
                }else{
                    $base64string = "";
                    $fileName = $vehicleData1['image_path'];
                }
                $data = [
                    'city_id' => $post['destination_city_id'],
                    'booking_type' => $post['booking_type'],
                    'title' => $post['title'],
                    'description' => $post['description'],
                    'image_path' => $fileName,
                    'modified_by' => $user_id,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'auto_id' => $post['id']
                ];
                $updateStatus = $this->CommonModel->updateCityIntroductionDetails($data);
                if ($updateStatus['responsedata']['status'] == "success") {
                    $this->flashMessenger()->addMessage(array('success' => 'Details Updated successfully...'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'Some thing Went Wrong'));
                }
                $this->redirect()->toRoute('city-instruction', ['action' => 'index']);
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }
    
      /** Function to change PAYMENT STRUCTURE STATUS */
    public function cityInstructionStatusAction() {
        $data1 = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $data = $this->getRequest()->getPost();
        $id = implode(',', $data['selected']);
        $status = $data['status'];
        $data = ['user_id' => $user_id, 'id' => $id, 'status' => $status];
        $this->CommonModel->updateCityIntroductionStatus($data);
        $val = [];
        $pStrtuctureList = $this->CommonModel->getCityIntroductionDetails($val);
        $viewModel = new ViewModel(['pStrtuctureList' => $pStrtuctureList]);
        $viewModel->setTemplate('/dashboard/city-instruction/city-instruction-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function changeRecordStatusAction() {
        $status=0;
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if($postData['status']==0 || $postData['status']==2){
                $status=1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->CommonModel->updateCityIntroductionStatus($data);
        }
        $val = [];
        $pStrtuctureList = $this->CommonModel->getCityIntroductionDetails($val);
        $viewModel = new ViewModel(['pStrtuctureList' => $pStrtuctureList]);
        $viewModel->setTemplate('/dashboard/city-instruction/city-instruction-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function deleteCityInstructionAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id'=>$userId, 'status'=>2];
        $this->CommonModel->updateCityIntroductionStatus($data);
        $this->redirect()->toRoute('city-instruction', ['action' => 'index']);
        $this->flashMessenger()->addMessage(array('success' => 'Details Delete Successfully'));
    }

}
