<?php

namespace Dashboard\Controller;

use Application\Controller\RestAPIClientController;
use Dashboard\Form\CancellationDeadlineForm;
use Zend\View\Model\ViewModel;
use Zend\Json\Json;
use Zend\Debug\Debug;
use Dashboard\Model\Booking;
use Dashboard\Model\CommonModel;

class CancellationDeadlineController extends RestAPIClientController {

    public function __construct() {
        $this->bookingModel = new Booking();
        $this->CommonModel = new CommonModel();
    }
    /**
     * index
     * @return ViewModel
     */
    public function indexAction(){
        $data=[];
        CancellationDeadlineForm::$bookingType = $this->CommonModel->getPackageTypeList();
        $form = new CancellationDeadlineForm();        
        $cancellationListing = $this->bookingModel->getCancelBookings($data);
        $viewModel = new ViewModel(['form'=>$form, 'cancellationListing'=>$cancellationListing]);
        return $viewModel;
    }
    
    public function searchCancellationRecordAction(){
          $data=[];
          $form = new CancellationDeadlineForm();
          //$sessionUser = new Container('userlogin');
         // $loginData = $sessionUser->userData;
        // $user_id = $loginData['user_id'];
       // $user_type_id = $loginData['user_type_id'];
        
           $val = $this->getRequest()->getPost();
           if($val=!''){
           $data = [
           'booking_id' => $val['booking_type'],
           'multi_status' => $val['start_date'],
           'agent_reference'=>$val['end_date'],
            ];
           }
           $data = array_filter($data);
        
        $cancellationListing = $this->bookingModel->getCancelBookings($data);
        $viewModel = new ViewModel(['form'=>$form, 'cancellationListing'=>$cancellationListing]);
        $viewModel->setTemplate('/dashboard/cancellation-deadline/cancellation-listing');
        $viewModel->setTerminal(true);
    }
    
            /* Release booking popup */
    public function releaseBookingAction(){
        $data = $this->params()->fromQuery();
        $viewModel = new ViewModel([
            'data' => $data
        ]);
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    
    public function editAutoReleaseDateAction(){
         $data = $this->params()->fromQuery();
         
         if ($this->getRequest()->isXmlHttpRequest()) {
             $viewModel = new ViewModel([
            'data' => $data
            ]);
            $viewModel->setTerminal(true);
            return $viewModel;
         }
         
         if($this->getRequest()->getPost()){
            $postdata =  $this->getRequest()->getPost();
            $postdata= $postdata->toArray();
            if($postdata['editdate']!='' && $postdata['booking_id']!=''){
                $arrParam  = [
                    'booking_id'=>$postdata['booking_id'],
                    'booking_release_date' =>$postdata['editdate']
                ];
                
                $resp = $this->bookingModel->updateAutoReleaseDate($arrParam);
                $this->redirect()->toRoute('cancellationdeadline', ['action' => 'index']);
            }
                        
         }
        
        
    }
    
    

}
