<?php

namespace Application\View\Helper;

use Zend\View\Helper\AbstractHelper;
use Application\Controller\RestAPIClientController;
use Zend\Json\Json;

class MyHelper extends AbstractHelper {

    public function test($messages) {
        echo $messages;
    }

    public function getMenu($group_name) {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $val = [
            'comp_id' => $config->company->companyId,
            'url' => $config->api->url,
            'group_name' => $group_name
        ];
        $data = $this->fetchMenu($val);
        return $data;
    }

    public function fetchMenu($val) {
        $api = new RestAPIClientController();
        $data = ['company_setup_id' => $val['comp_id'], 'group_name' => $val['group_name']];
        $url = $val['url'] . '/cms-pages/getCmsPages';
        $resp = $api->post($url, $data);
        $menuData = Json::decode($resp->getBody(), true);
        return $menuData;
    }

    public function getCompanyData() {
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $url = $config->api->url . "/company-setup/" . $config->company->companyId;
        $resp = $api->get($url);
        $compJsonData = Json::decode($resp->getBody(), true);
        return $compJsonData;
    }

    public function fetchUserName($user_id) {
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $val = '{"where": {"id": "' . $user_id . '"}}';
        $val = rawurlencode($val);
        $url = $config->api->url . "/user?&filter=" . $val;
        $resp = $api->get($url);
        $val = Json::decode($resp->getBody(), true);
        $data = isset($val[0]) ? $val[0] : 0;
        if ($data != "") {
            $val = $data['first_name'] . ' ' . $data['last_name'];
        } else {
            $val = "NA";
        }
        return $val;
    }
    
    public function fetchCurrencyCode($currencyId) {
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $val = '{"where": {"id": "' . $currencyId . '"}}';
        $val = rawurlencode($val);
        $url = $config->api->url . "/master-currency?&filter=" . $val;
        $resp = $api->get($url);
        $val = Json::decode($resp->getBody(), true);
        $data = isset($val[0]) ? $val[0] : 0;
        if ($data != "") {
            $val = $data['code'];
        } else {
            $val = "NA";
        }
        return $val;
    }
    
    public function fetchMasterPackaage($id) {
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $val = '{"where": {"id": "' . $id . '"}}';
        $val = rawurlencode($val);
        $url = $config->api->url . "/package?&filter=" . $val;
        $resp = $api->get($url);
        $data = Json::decode($resp->getBody(), true);
        if ($data!= "") {
            $val = isset($data['data'][0]['name']) ? $data['data'][0]['name']:'NA';
        } else {
            $val = "NA";
        }
        return $val;
    }
    
    public function fetchBookingModule($id) {
         $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $val = '{"where": {"id": "' . $id . '"}}';
        $val = rawurlencode($val);
        $url = $config->api->url . "/master-booking-type?&filter=" . $val;
        $resp = $api->get($url);
        $data = Json::decode($resp->getBody(), true);
        if ($data!= "") {
            $val = isset($data['data'][0]['booking_type']) ? $data['data'][0]['booking_type']:'NA';
        } else {
            $val = "NA";
        }
        return $val;
    }
    
    public function fetchCancellationType($id) {
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $val = '{"where": {"id": "' . $id . '"}}';
        $val = rawurlencode($val);
        $url = $config->api->url . "/cancellation-list?&filter=" . $val;
        $resp = $api->get($url);
        $data = Json::decode($resp->getBody(), true);
        if ($data!= "") {
            $val = isset($data['data'][0]['name']) ? $data['data'][0]['name']:'NA';
        } else {
            $val = "NA";
        }
        return $val;
    }

    public function fetchVehicleTypeName($id) {
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $val = '{"where": {"id": "' . $id . '"}}';
        $val = rawurlencode($val);
        $url = $config->api->url . "/vehicle-type?&filter=" . $val;
        $resp = $api->get($url);
        $val = Json::decode($resp->getBody(), true);

        $data = isset($val['data'][0]) ? $val['data'][0] : 0;
        if ($data != "") {
            $val = $data['vehicle_type'];
        } else {
            $val = "NA";
        }
        return $val;
    }

    public function getUserPendingDoc($user_id) {
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $url = $config->api->url . "/user/getuserpendingdoc?user_id=".$user_id;
        $resp = $api->get($url);
        $data = Json::decode($resp->getBody(), true);
        if($data['responsedata']['status']=="success"){
            $val = $data['responsedata']['data'];
        }
        return $val;
    }
    
    public function getRecentlyViewedItems($data) {
        $val =[];
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $url = $config->api->url . "/recently-viewed/getallrecentvieweditems";
        $resp = $api->post($url,$data);
        $data = Json::decode($resp->getBody(), true);
        if($data['responsedata']['status']=="success"){
            $val = $data['responsedata']['data'];
        }
        return $val;
    }
    
    public function getCityName($id) {
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $val = '{"where": {"id": "' . $id . '"}}';
        $val = rawurlencode($val);
        $url = $config->api->url . "/city?&filter=" . $val;
        $resp = $api->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data[0];
    }  
    
    public function getVehicleDetails($id) {
        $value="";
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $val = '{"where": {"id": "' . $id . '"}}';
        $val = rawurlencode($val);
        $url = $config->api->url . "/vehicle-master?&filter=" . $val;
        $resp = $api->get($url);
        $data = Json::decode($resp->getBody(), true);
        if(!empty($data)){
        $value =  $data[0];
        }        
        return $value;
        
    }
    
    public function fetchRoomRate($data) {        
        $result = [];
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $data['bkg_type_id'] = $config->masterBookingType->hotelId;
        $url = $config->api->url . "/room-rate/getHotelRoomRateDataList";
        $resp = $api->post($url, $data);
        $responsedata = Json::decode($resp->getBody(), true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'][0];
        }
        return $result;
    }
    
    public function fetchRoomRatePackage($data) {        
        $result = [];
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');       
        $url = $config->api->url . "/master-hotel-rate-type/getHotelRateTypeDetails";
        $resp = $api->post($url, $data);
        $responsedata = Json::decode($resp->getBody(), true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'][0];
        }
        return $result;
    }
    
    public function fetchActivityFare($data) {         
        $result = [];
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');     
        $data['bkg_type_id'] =  $config->masterBookingType->activityId;
        $url = $config->api->url . "/sightseeing/getActivityFareList";
        $resp = $api->post($url, $data);
        $responsedata = Json::decode($resp->getBody(), true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    public function fetchLanguage($lang) {         
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $url = $config->api->url . "/master-language/".$lang;
        $resp = $api->get($url);
        $data = Json::decode($resp->getBody(), true);
        if ($data != "") {
            $val = $data['language_name'];
        } else {
            $val = "NA";
        }
        return $val;
    }
    
    
    public function fetchVendorFare($vehicleTypeId,$vehicleMasterId) {
        $result = [];
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $data = [
            'vehicle_type_id' => $vehicleTypeId,
            'vehicle_master_id' => $vehicleMasterId,
        ];
        
        $url = $config->api->url . "/fare_management/getVendorFareInfo";
        $resp = $api->post($url, $data);
        $responsedata = Json::decode($resp->getBody(), true);
        //echo "<pre>"; print_r($responsedata); die;
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'][0];
        }
        return $result;
    }
    
    public function fetchFareData($base_vehicle_id,$booking_mode) {
        $result = [];
        $api = new RestAPIClientController();
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        if (is_array($base_vehicle_id)) {
            $base_vehicle_id = $base_vehicle_id[0];
        }
        $val = '{"where": {"base_vehicle_id": "' . $base_vehicle_id . '"}}';
        $val = rawurlencode($val);
        $url = $config->api->url . "/" . $booking_mode . "?&filter=" . $val;
        $resp = $api->get($url);
        return $data = Json::decode($resp->getBody(), true);       
    }
}
