<?php

namespace Application\Form;

use Zend\Form\Form;
use Zend\Form\Element\{Checkbox, Text, Submit, Hidden, Textarea, Select};
use Zend\Validator\{Digits, EmailAddress, NotEmpty, StringLength};
use Zend\InputFilter\InputFilterProviderInterface;

class ForgetPasswordForm extends Form implements InputFilterProviderInterface {

    public function __construct($name = null) {

        parent::__construct('forget-password-form');
        
         /**
         * user type
         */
        $this->add([
            'name' => 'user_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'user-type-id',
                'class' => 'form-control input-border'
            ],
            'options' => [
                'disable_inarray_validator' => true,
                'empty_option' => 'Select User Type',
                'value_options' => [
                    '3' => 'Driver',
                    '4' => 'Vendor',
                    '5' => 'Guide',
                    '10' => 'Super Admin',
                ],
            ],
        ]);

        /**
         * Name
         */
        $this->add([
            'name' => 'userid_email_mobile',
            'type' => Text::class,
            'attributes' => [
                'id' => 'userid-email-mobile',
                'placeholder' => 'Email/Mobile',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Name
         */
        $this->add([
            'name' => 'password_email_mobile',
            'type' => Text::class,
            'attributes' => [
                'id' => 'password-email-mobile',
                'placeholder' => 'Email/Mobile',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * user_name Used for Unique Id
         */
        $this->add([
            'name' => 'password_user_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'password-user_name_id',
                'class' => 'form-control input-border',
                'placeholder' => 'User Id'
            ],
            'options' => [
                'label' => 'User Id<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * user_name Used for Unique Id
         */
        $this->add([
            'name' => 'email_mobile_user_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'email-mobile-user_name_id',
                'class' => 'form-control input-border',
                'placeholder' => 'User Id'
            ],
            'options' => [
                'label' => 'User Id<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         *  Submit
         */
        $this->add([
            'name' => 'forgetpassword_submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Reset Password',
                'id' => 'forgetpassword-submit',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);

    }

    public function getInputFilterSpecification() {
        return [
            'user_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select User Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'userid_email_mobile' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Email / Mobile'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'password_email_mobile' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Email / Mobile'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'password_user_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter User Id'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'email_mobile_user_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter User Id'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ]
        ];
    }

}
