<?php

namespace Api\View\Helper;

use Zend\View\Helper\AbstractHelper;
use Application\Controller\RestAPIClientController;
use Zend\Json\Json;

class ApiMenu extends AbstractHelper {


     public function getApiDocumentLink($userTypeId) {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $apiUrl = $config->api->url;
        $api = new RestAPIClientController();
        
           $url = $apiUrl . '/apidocument/getapidocumentdetails';
            $resp = $api->get($url);
            $menuData = Json::decode($resp->getBody(), true);

            if (isset($menuData) && !empty($menuData['responsedata'])) {
                 return $this->buildTree($menuData['responsedata']);
            }
       
    }
  

    public function buildTree($elements, $parentId = 0) {
    $branch = array();

    foreach ($elements as $element) {
        if ($element['parent_id'] == $parentId) {
            $children = $this->buildTree($elements, $element['id']);
            if ($children) {
                $element['submenu'] = $children;
            }
            $branch[] = $element;
        }
    }

    return $branch;
   }
   
      
     public function getNotificationList($userId) { 
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $apiUrl = $config->api->url;
        $api = new RestAPIClientController();
        //if($userId > 0){
            $url = $apiUrl . '/notification/notificationList?driver_id='.$userId;           
            $resp = $api->get($url);
            $notificationData = Json::decode($resp->getBody(), true);

            if (isset($notificationData) && ($notificationData['responsedata']['status']=='success')) {
                 return $notificationData['responsedata']['data'];
            }
        //}
    }




}
