<?php

namespace Api\Controller;

use Application\Controller\RestAPIClientController;

use Zend\View\Model\{
    ViewModel,
    JsonModel
};
use Zend\Debug\Debug;
use Zend\Session\Container;
use Zend\Json\Json;
use Dashboard\Model\UserLicenseModel;

class IndexController extends RestAPIClientController {

    public function __construct() {
        $this->licenseModel = new UserLicenseModel();
    }

    public function indexAction() {        
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id']; 
        
        $userLicenseData= [];
        if($user_id>0){
        $params = ['user_id' => $user_id];
        $respData = $this->licenseModel->getUserLicenseDetail($params);  
            if(!empty($respData)){
                $userLicenseData = $respData[0];
            }
        
        }else{           
           $this->redirect()->toRoute('home');       
        }        
      
        $viewModel = new ViewModel(['userLicenseData'=>$userLicenseData]);            
        return $viewModel;
    }
    
    
    public function localhireapiAction(){
            
    }
    
    /** @Description : Get Api Details By Id
     * @Params : Id (api_document_detail)  
     */
    public function apiDetailAction(){        
       $id = $this->params()->fromQuery('id');
       $finalrespData = [];
       if($id){
            $url = $this->apiUrl().'/apidocument/getapidocumentdetails?id='.$id;
            $resp = $this->get($url);
            $respData = Json::decode($resp->getBody(), true);
           
            if (isset($respData) && !empty($respData['responsedata'])) {
                $finalrespData = $respData['responsedata'][0];
            }
       }       
        $viewModel = new ViewModel(['result'=>$finalrespData]);            
        return $viewModel;
    }
    
    
    /** @CreatedDate : 24-Sep-2020
     *  @CreatedBy : Mohit Verma
     *  @Descriptpion : Get API Term & Condition
     */
    public function apiTermConditionAction(){
        
            
    }
    
    /** @createdDate : 24-Sep-2020 
     *  @createdBy : Mohit verma 
     *  @Desc - API user login  
     */
    public function apiDocumentAction(){
        $id = $this->params()->fromQuery('id');
        $data = ['menu_id' => $id];
        $url = $this->apiUrl() . '/cms-pages/getCmsPages';
        $resp = $this->post($url, $data);
        $menuData = Json::decode($resp->getBody(), true);
        $cms_details = [];
        
        
        if(!empty($menuData['responsedata'])){
            $cms_details = $menuData['responsedata'][0];
        }
        
        $viewModel = new ViewModel(['result'=>$cms_details]);            
        return $viewModel;
    }

   

}
