<?php

namespace Activity;

use Zend\Mvc\ModuleRouteListener;
use Zend\Mvc\MvcEvent;

class Module {

    public function onBootstrap(MvcEvent $e) {
        $eventManager = $e->getApplication()->getEventManager();
        $moduleRouteListener = new ModuleRouteListener();
        $moduleRouteListener->attach($eventManager);


        //$eventManager->getSharedManager()->attach('*', MvcEvent::EVENT_DISPATCH, array($this, 'onDispatchError'), -100);
        //$eventManager->getSharedManager()->attach('*', MvcEvent::EVENT_DISPATCH_ERROR, array($this, 'onDispatchError'), -100);
        $eventManager->getSharedManager()->attach('Zend\Mvc\Controller\AbstractActionController', 'dispatch', function($event) {
            $controller = $event->getTarget();
            $controllerName = get_class($controller);
            $moduleNamespace = substr($controllerName, 0, strpos($controllerName, '\\'));
            $configs = $event->getApplication()->getServiceManager()->get('config');
            if (isset($configs['moduleLayouts'][$moduleNamespace])) {
                $controller->layout($configs['moduleLayouts'][$moduleNamespace]);
            }
        }, 100);
    }

    /*public function onDispatchError(MvcEvent $event){
        $response = $event->getResponse();
        if ($response->getStatusCode() == 404) {
            //DO SOMETHING
            //$event->getViewModel();
            $vm = $event->getViewModel();
            $vm->setTemplate('layout/blank');
        } elseif($response->getStatusCode() == 500){
            //DO SOMETHING else?
        }
    }*/

    public function getConfig() {
        return include __DIR__ . '/../config/module.config.php';
    }

}
