<?php

/** @CreatedBy : Mohit Jain
 *  @Description : User Model Functions
 */

namespace User\Model;

use Application\Controller\RestAPIClientController;
use Zend\Session\Container;
use Zend\Json\Json;

class Registration extends RestAPIClientController {

    public function apiUrl() {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        return $config->api->url;
    }

    public function verifyRegisterUser($username){
        $url = $this->apiUrl() . "/user/verifyregister?username=" . $username;
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $result = Json::decode($JsonData, true);
        return $result;
    }
    
     public function verifyUser($email,$mobile,$registrationType){
        $url = $this->apiUrl() . "/user/verifysignup?email=" . $email ."&mobile=" .$mobile ."&user_type_id=" .$registrationType;
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $result = Json::decode($JsonData, true);
        return $result;
    }

    public function userSignup($data){
        $url = $this->apiUrl() . "/user/signup";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $result = Json::decode($JsonData, true);
        return $result;
    }
    
     public function userNewSignup($data){
        $url = $this->apiUrl() . "/user/newsignup";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $result = Json::decode($JsonData, true);
        return $result;
    }

    public function updatePersonalInfo($data){
        $url = $this->apiUrl() . "/user/updatepersonalinfo";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $result = Json::decode($JsonData, true);
        return $result;
    }

    public function updateSignupStatus($data){
        $url = $this->apiUrl() . "/user/updatesignupstatus";
        $val = $this->put($url, $data);
        $JsonData = $val->getBody();
        $result = Json::decode($JsonData, true);
        return $result;
    }

    public function getUserPersonalInfo($user_id){
        $url = $this->apiUrl() . "/user/userpersonalinfo?user_id=" . $user_id;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
   
    
    public function resentOtp($user_id){
        $data = [];
        if ($user_id > 0) {
            $url = $this->apiUrl() . "/user/resendotp?user_id=" . $user_id;
            $resp = $this->get($url);
            $data = Json::decode($resp->getBody(), true);
            return $data;
        } else {
            return $data;
        }
    }
    
    
    public function registrationThanks($data){
        $url = $this->apiUrl() . "/user/registrationThanks";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $result = Json::decode($JsonData, true);
        return $result;
    }
    
   


}
