<?php

namespace User\Form;

use Zend\InputFilter\InputFilter;
use Zend\Validator\NotEmpty;


class UserRegistrationFormFilter extends InputFilter {

    public function __construct() {        

        /**
         * username
         */
        $this->add([
            'name' => 'username',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter username'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);

        /**
         * Password
         */
        $this->add([
            'name' => 'password',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Password'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);
        
        /**
         * Confirm Password
         */
        $this->add([
            'name' => 'confirm_password',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Confirm Password'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);
        
    }

}
