<?php

namespace User\Form;

use Zend\Form\Element;
use Zend\Form\Form;
use Zend\Form\Element\Select;
use Zend\Form\Element\Submit;
use Zend\Validator\{
    NotEmpty,
    Digits
};
use Zend\InputFilter\InputFilterProviderInterface;

class LoginRedirectForm extends Form implements InputFilterProviderInterface {

    public function __construct($name = null) {

        /**
         * Login Detail Form of Guide Registration
         */
        parent::__construct('login-redirect-form');
        $this->setAttribute('method', 'post');

        /**
         * username
         */
        $this->add([
            'name' => 'username_redirect',
            'type' => 'text',
            'attributes' => [
                'id' => 'username_redirect',
                'class' => 'form-control input-border',
                'placeholder' => 'User Name'
            ],
            'options' => [
                'label' => 'User Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Password
         */
        $this->add([
            'name' => 'password_redirect',
            'type' => 'password',
            'attributes' => [
                'id' => 'password_redirect',
                'class' => 'form-control input-border',
                'placeholder' => 'Password'
            ],
            'options' => [
                'label' => 'Password<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        $this->add([
            'name' => 'login_redirectform',
            'type' => 'Submit',
            'attributes' => [
                'value' => 'Sign In',
                'label' => 'Submit',
                'class' => 'publish_all btn btn-danger text-white'
            ]
        ]);


        $this->add([
            'name' => 'link_type',
            'type' => 'Hidden',
            'attributes' => [
                'id' => 'link_type',
            ]
        ]);

    }

    public function getInputFilterSpecification() {
        return [
            'username_redirect' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Email / Mobile No.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'password_redirect' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Password '
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
        ];
    }

}
