<?php

namespace User\Form;

use Zend\Form\Form;

class GuideRegistrationForm extends Form {
    
    
    public function __construct($name = null) {

        /**
         * Login Detail Form of Guide Registration
         */  
        parent::__construct('guide-registration-form');
        $this->setAttribute('method', 'post');        

        /**
         * username
         */
        $this->add([
            'name' => 'username',
            'type' => 'text',
            'attributes' => [
                'id' => 'username',                
                'class' => 'form-control user-name'
            ],
            'options' => [
                'label' => 'User Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Password
         */
        $this->add([
            'name' => 'password',
            'type' => 'password',
            'attributes' => [
                'id' => 'password',                
                'class' => 'form-control pwd'
            ],
            'options' => [
                'label' => 'Password<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);        
        
        /**
         * Confirm Password
         */
        $this->add([
            'name' => 'confirm_password',
            'type' => 'password',
            'attributes' => [
                'id' => 'confirm-password',                
                'class' => 'form-control conf-password'
            ],
            'options' => [
                'label' => 'Confirm Password<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Registration Type
         */
        $this->add([
            'name' => 'registration_type',
            'type' => 'hidden',
            'attributes' => [
                'id' => 'registration-type',                
                'class' => 'form-control'
            ]            
        ]);

        /**
         * Continue
         */
        $this->add([
            'name' => 'login_detail',
            'type' => 'Submit',
            'attributes' => [
                'value' => 'Continue',
                'id' => 'login-detail',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);
       
    }

}
