<?php

namespace User\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Submit,
    Hidden,
    Select,
    Textarea
};
use Zend\Validator\{
    NotEmpty,
    Digits
};
use \Zend\InputFilter\InputFilterProviderInterface;

class DutyRegistrationForm extends Form implements InputFilterProviderInterface{
    public static $dutytype = [];
    public static $paymenttype = [];
    public static $langspeak = [];
    public static $langwrite = [];
    public static $shiftlogin = [];


    public function __construct($name = null) {

        /**
         * Duty Info Form of Driver Registration
         */
        parent::__construct('duty-info-registration-form');
        $this->setAttribute('method', 'post');

        /**
         * Pref City to Drive Cab
         */

        $this->add([
            'name' => 'preferred_city',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'city-search',
                //'placeholder' => '',
                'class' => 'form-control',
                'class' => 'demo-default selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Pref. City to Drive Cab<span style="color: red">*</span>',
            ],
        ]);

        $this->add([
            'name' => 'city_search_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'city-search-id',
            ],
        ]);

        /**
         * Speak Language
         */
        $this->add([
            'name' => 'language_speak',
            'type' => Select::class,
            'attributes' => [
                'id' => 'language-speak',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Speak Language<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '',
                'value_options' => self::$langspeak,
            ],
        ]);

        /**
         * Write Language
         */
        $this->add([
            'name' => 'language_write',
            'type' => Select::class,
            'attributes' => [
                'id' => 'language-write',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Write Language<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '',
                'value_options' => self::$langwrite,
            ],
        ]);

        /**
         * Shift of Login
         */
        $this->add([
            'name' => 'shift_of_login',
            'type' => Select::class,
            'attributes' => [
                'id' => 'shift-of-login',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Shift of Login<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '',
                'value_options' => self::$shiftlogin,
            ],
        ]);

        /**
         * Duty Type
         */
        $this->add([
            'name' => 'duty_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'duty-type',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Duty Type<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '',
                'value_options' => self::$dutytype,
            ],
        ]);

        /**
         * Payment Type
         */
        $this->add([
            'name' => 'payment_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'payment-type',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Payment Type<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '',
                'value_options' => self::$paymenttype,
            ],
        ]);



        /**
         * Continue
         */
        $this->add([
            'name' => 'driver_duty_info',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Continue',
                'id' => 'driver-duty-info',
                'class' => 'save_data_btn btn btn-primary btn-new-vehile butoon_save btn-warning'
            ],
        ]);

    }

     public function getInputFilterSpecification() {
   return [

      'preferred_city' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter city'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

       'language_speak' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter speak language'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
       'duty_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter duty type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

       'payment_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter payment Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

       'language_write' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter write language'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
       'shift_of_login' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter shift of login'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],


   ];

   }
}
