<?php

namespace User\Form;

use Zend\InputFilter\InputFilter;
use Zend\Validator\Digits;
use Zend\Validator\StringLength;
use Zend\Validator\NotEmpty;
use Zend\Validator\EmailAddress;
use Zend\Validator\Date;

class CorporateUserPersonalRegistrationFormFilter extends InputFilter {
    
    public function __construct() {

        /**
         * Name
         */
        $this->add([
            'name' => 'first_name',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter First Name'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);

        /**
         * Last Name
         */
        $this->add([
            'name' => 'last_name',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Last Name'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);

        /**
         * Mobile No
         */
        $this->add([
            'name' => 'mobile',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Mobile No.'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ],
                [   'name' => 'Digits',
                    'options' => [
                        'messages' => [
                            Digits::NOT_DIGITS => 'Please enter Numeric value only',
                        ],
                    ],
                    'break_chain_on_failure' => true,
                ],
                [   'name' => 'StringLength',
                    'options' => [
                        'min' => 10,
                        'max' => 10,
                        'messages' => [
                            StringLength::TOO_LONG => 'Please enter Less than 10 Digits',
                            StringLength::TOO_SHORT => 'Please enter greater than 9 Digits',
                        ],
                    ],
                    'break_chain_on_failure' => true
                ],
            ]
        ]);

        /**
         * Date Of Birth
         */
        $this->add([
            'name' => 'dob',
            'required' => TRUE,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Date Of Birth'
                        ]
                    ],

                ],
                [   'name' => 'Date',
                    'options' => [
                        'messages' => [
                            Date::INVALID_DATE => '',
                        ],
                    ],
                    'break_chain_on_failure' => true
                ],
            ]
        ]);

        /**
         * Residential Address
         */
        $this->add([
            'name' => 'address',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Residential Address'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);
        
        /**
         * City
         */
        $this->add([
            'name' => 'city_id',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please Select City'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);
        
        /**
         * Vehicle Code
         */
//        $this->add([
//            'name' => 'vehicle_code',
//            'required' => true,
//            'filters' => [
//                ['name' => 'StripTags'],
//                ['name' => 'StringTrim']
//            ],
//            'validators' => [
//                [   'name' => 'NotEmpty',
//                    'options' => [
//                        'messages' => [
//                            NotEmpty::IS_EMPTY => 'Please enter Vehicle Code'
//                        ]
//                    ],
//                    'break_chain_on_failure' => true
//                ]
//            ]
//        ]);
        
        /**
         * Vehicle No
         */
//        $this->add([
//            'name' => 'vehicle_number',
//            'required' => true,
//            'filters' => [
//                ['name' => 'StripTags'],
//                ['name' => 'StringTrim']
//            ],
//            'validators' => [
//                [   'name' => 'NotEmpty',
//                    'options' => [
//                        'messages' => [
//                            NotEmpty::IS_EMPTY => 'Please enter Vehicle No'
//                        ]
//                    ],
//                    'break_chain_on_failure' => true
//                ]
//            ]
//        ]);
        
        /**
         * Upload Your RC Proof
         */
//        $this->add([
//            'name' => 'rc_proof',
//            'required' => true,
//            'filters' => [
//                ['name' => 'StripTags'],
//                ['name' => 'StringTrim']
//            ],
//            'validators' => [                
//                [   'name' => 'NotEmpty',
//                    'options' => [
//                        'messages' => [
//                            NotEmpty::IS_EMPTY => 'Please Upload Your RC Proof'
//                        ]
//                    ],
//                    'break_chain_on_failure' => true
//                ], 
//                ['name'    => 'FileUploadFile'],
//                [
//                    'name'    => 'FileMimeType',                        
//                    'options' => [                       
//                        'mimeType'  => ['image/gif', 'image/png', 'image/jpg', 'image/jpeg']
//                    ],
//                    'break_chain_on_failure' => true
//                ],
//                ['name'    => 'FileIsImage'],
//                [
//                        'name'    => 'FileImageSize',                        
//                        'options' => [                            
//                            'minWidth'  => 128,
//                            'minHeight' => 128,
//                            'maxWidth'  => 4096,
//                            'maxHeight' => 4096
//                        ]
//                ],     
//            ]
//        ]);
        
        /**
         * License State
         */
//        $this->add([
//            'name' => 'license_state',
//            'required' => true,
//            'filters' => [
//                ['name' => 'StripTags'],
//                ['name' => 'StringTrim']
//            ],
//            'validators' => [
//                [   'name' => 'NotEmpty',
//                    'options' => [
//                        'messages' => [
//                            NotEmpty::IS_EMPTY => 'Please select License State'
//                        ]
//                    ],
//                    'break_chain_on_failure' => true
//                ]
//            ]
//        ]);
        
        /**
         * License Proof
         */
//        $this->add([
//            'name' => 'license_proof',
//            'required' => true,
//            'filters' => [
//                ['name' => 'StripTags'],
//                ['name' => 'StringTrim']
//            ],
//            'validators' => [
//                [   'name' => 'NotEmpty',
//                    'options' => [
//                        'messages' => [
//                            NotEmpty::IS_EMPTY => 'Please Upload Your License Proof'
//                        ]
//                    ],
//                    'break_chain_on_failure' => true
//                ]
//            ]
//        ]);
        
        /**
         * Accept the Terms and Conditions
         */
        $this->add([
            'name' => 'agree_terms',
            'required' => true,
            'validators' => [
                [   'name' => 'Digits',
                    'break_chain_on_failure' => true,
                    'options' => [
                        'messages' => [
                            Digits::NOT_DIGITS => 'Please Accept the Terms and Conditions',
                        ],
                    ],
                ],
            ],
        ]);
        
    }

}
