<?php

namespace User\Form;

use Zend\Form\Form;
use Zend\Form\Element\{Select, Date, Email, Checkbox, File, Text, Textarea, Submit, Hidden};
use Zend\Validator\{
    NotEmpty,
    Digits,
    StringLength,
    EmailAddress
};
use Zend\InputFilter\InputFilterProviderInterface;


class CompanyRegistrationForm extends Form implements InputFilterProviderInterface{


    public function __construct($name = null) {

        //echo "form";die;

        /**
         * Company Info Form of Driver Registration
         */
        parent::__construct('company-info-registration-form');
        $this->setAttribute('method', 'post');
        $this->setAttribute('enctype', 'multipart/form-data');
        /**
         * Company Name
         */
        $this->add([
            'name' => 'company_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'company-name',
                'placeholder' => 'Company Name',
                'class' => 'form-control inputuppercase',
                'maxlength' => 50,
                'onkeypress' => "return isAlphaNumber(event)"
            ],
            'options' => [
                'label' => 'Company Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

         /**
         * City Value
         */
        $this->add([
            'name' => 'city_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'city-value',
                'class'=>'company-value'
            ],
        ]);
        /**
         * Office Address
         */
        $this->add([
            'name' => 'office_address',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'office-address',
                'class' => 'form-control inputuppercase office-address-class'
            ],
            'options' => [
                'label' => 'Office Address<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],

        ]);

        /**
         * Upload Your Office Address Proof
         */
        $this->add([
            'name' => 'office_proof',
            'type' => File::class,
            'attributes' => [
                'id' => 'office-proof',
                'class' => 'form-control common-upload-file',
                'data-level-name' => 'office_proof'
            ]

        ]);

        /**
         * City
         */
        $this->add([
            'name' => 'company_city',
            'type' => Text::class,
            'attributes' => [
                'id' => 'city-id',
                'placeholder' => 'Delhi',
                'class' => 'form-control inputchange city-class'
            ],
            'options' => [
                'label' => 'City<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],

        ]);

        /**
         * Pin Code
         */
        $this->add([
            'name' => 'company_pincode',
            'type' => Text::class,
            'attributes' => [
                'id' => 'company-pincode',
                'maxlength' => 6,
                'placeholder' => '110005',
                'class' => 'form-control pincode-class',
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'Pin Code'
            ],

        ]);

        /**
         * Services Tax/GST
         */
        $this->add([
            'name' => 'service_tax_gst',
            'type' => Text::class,
            'attributes' => [
                'id' => 'service-tax-gst',
                'class' => 'form-control service-tax-gst',
                'maxlength' => 15,
                'onkeypress' => "return isAlphaNumber(event)"
            ],
            'options' => [
                'label' => 'Services Tax/GST<span style="color: red"> </span>',
                'label_options' => ['disable_html_escape' => true]
            ],

        ]);

        /**
         * Upload Your GST Proof
         */
        $this->add([
            'name' => 'gst_proof',
            'type' => File::class,
            'attributes' => [
                'id' => 'gst-proof',
                'class' => 'form-control common-upload-file',
                'data-level-name' => 'gst_proof'
            ]

        ]);

        /**
         * Pan Card Details
         */
        $this->add([
            'name' => 'pancard_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pancard-no',
                'class' => 'form-control pancard-no-class',
                'maxlength' => 10,
                'onkeypress' => "return isAlphaNumber(event)"
            ],
            'options' => [
                'label' => 'Pan Card Details<span style="color: red"> </span>',
                'label_options' => ['disable_html_escape' => true]
            ],

        ]);

        /**
         * Upload Your Pan Card Proof
         */
        $this->add([
            'name' => 'company_pancard_proof',
            'type' => File::class,
            'attributes' => [
                'id' => 'pancard-proof',
                'class' => 'form-control common-upload-file',
                'data-level-name' => 'company_pancard_proof'

            ]

        ]);

        /**
         * Contact Person
         */
        $this->add([
            'name' => 'contact_person',
            'type' => Text::class,
            'attributes' => [
                'id' => 'contact-person',
                'class' => 'form-control contact-person-class inputuppercase',
                'maxlength' => 50,
                'onkeypress' => "return isAlpha(event)"
            ],
            'options' => [
                'label' => 'Contact Person<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],

        ]);

        /**
         * Phone Number
         */
        $this->add([
            'name' => 'company_phone_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'company-phone-no',
                'class' => 'form-control',
                'maxlength' => 12,
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'Landline Number<span style="color: red"> </span>',
                'label_options' => ['disable_html_escape' => true]
            ],

        ]);

        /**
         * Mobile Number
         */
        $this->add([
            'name' => 'company_mobile_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'company-mobile-no',
                'class' => 'form-control company-mobile-no-class',
                'maxlength' => 12,
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'Mobile Number<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],

        ]);

        /**
         * Email
         */
        $this->add([
            'name' => 'email',
            'type' => Text::class,
            'attributes' => [
                'id' => 'email',
                'class' => 'form-control email-class'
            ],
            'options' => [
                'label' => 'Company Email<span style="color: red"> </span>',
                'label_options' => ['disable_html_escape' => true]
            ],

        ]);

        /**
         * Website
         */
        $this->add([
            'name' => 'website_url',
            'type' => Text::class,
            'attributes' => [
                'id' => 'website-url',
                'class' => 'form-control weburl-class'
            ],
            'options' => [
                'label' => 'Website Url<span style="color: red"> </span>',
                'label_options' => ['disable_html_escape' => true]
            ],

        ]);

        /**
         * Upload Your Logo
         */
        $this->add([
            'name' => 'company_logo',
            'type' => File::class,
            'attributes' => [
                'id' => 'company-logo',
                'class' => 'form-control common-upload-file',
                'data-level-name' => 'company_logo'

            ]

        ]);

        /**
         * Continue
         */
        $this->add([
            'name' => 'driver_company_info',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'continue',
                'id' => 'driver-company-info',
                'class' => 'save_data_btn btn btn-primary btn-new-vehile btn-warning company_detail'
            ],
        ]);

    }

   public function getInputFilterSpecification() {
   return [
       /**
         * Name
         */
        'company_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Company name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
       'office_address' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Address'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],


            'office_proof' => [
            'required' => false,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'File was not uploaded'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ],
                ['name'    => 'FileUploadFile'],
                [
                    'name'    => 'FileMimeType',
                    'options' => [
                        'mimeType'  => ['image/gif', 'image/png', 'image/jpg', 'image/jpeg']
                    ],
                    'break_chain_on_failure' => true
                ],
                ['name'    => 'FileIsImage'],
                [
                        'name'    => 'FileImageSize',
                        'options' => [
                            'minWidth'  => 128,
                            'minHeight' => 128,
                            'maxWidth'  => 4096,
                            'maxHeight' => 4096
                        ]
                ],
            ]
        ],

            'company_city'=>[
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please Select City'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ],

        'service_tax_gst' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter GST no.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

       'gst_proof'=>[
            'required' => false,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'File was not uploaded'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ],
                ['name'    => 'FileUploadFile'],
                [
                    'name'    => 'FileMimeType',
                    'options' => [
                        'mimeType'  => ['image/gif', 'image/png', 'image/jpg', 'image/jpeg']
                    ],
                    'break_chain_on_failure' => true
                ],
                ['name'    => 'FileIsImage'],
                [
                        'name'    => 'FileImageSize',
                        'options' => [
                            'minWidth'  => 128,
                            'minHeight' => 128,
                            'maxWidth'  => 4096,
                            'maxHeight' => 4096
                        ]
                ],
            ]
        ],
       'pancard_no' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter pancard no.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

       'pancard_proof'=>[
            'required' => false,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'File was not uploaded'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ],
                ['name'    => 'FileUploadFile'],
                [
                    'name'    => 'FileMimeType',
                    'options' => [
                        'mimeType'  => ['image/gif', 'image/png', 'image/jpg', 'image/jpeg']
                    ],
                    'break_chain_on_failure' => true
                ],
                ['name'    => 'FileIsImage'],
                [
                        'name'    => 'FileImageSize',
                        'options' => [
                            'minWidth'  => 128,
                            'minHeight' => 128,
                            'maxWidth'  => 4096,
                            'maxHeight' => 4096
                        ]
                ],
            ]
        ],
       'contact_person' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter contact person name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],


            'company_phone_no'=>[
            'required' => false,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Mobile No.'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ],
                [   'name' => 'Digits',
                    'options' => [
                        'messages' => [
                            Digits::NOT_DIGITS => 'Please enter Numeric value only',
                        ],
                    ],
                    'break_chain_on_failure' => true,
                ],
                [   'name' => 'StringLength',
                    'options' => [
                        'min' => 10,
                        'max' => 10,
                        'messages' => [
                            StringLength::TOO_LONG => 'Please enter Less than 10 Digits',
                            StringLength::TOO_SHORT => 'Please enter greater than 9 Digits',
                        ],
                    ],
                    'break_chain_on_failure' => true
                ],
            ]
        ],
       'company_mobile_no'=>[
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Mobile No.'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ],
                [   'name' => 'Digits',
                    'options' => [
                        'messages' => [
                            Digits::NOT_DIGITS => 'Please enter Numeric value only',
                        ],
                    ],
                    'break_chain_on_failure' => true,
                ],
                [   'name' => 'StringLength',
                    'options' => [
                        'min' => 8,
                        'max' => 11,
                        'messages' => [
                            StringLength::TOO_LONG => 'Please enter Less than 10 Digits',
                            StringLength::TOO_SHORT => 'Please enter greater than 9 Digits',
                        ],
                    ],
                    'break_chain_on_failure' => true
                ],
            ]
        ],
     'email' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'EmailAddress',
                        'options' => [
                            'messages' => [
                                EmailAddress::INVALID => 'Please enter Valid Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
      'website_url' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter website'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

       'company_logo'=>[
            'required' => false,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'File was not uploaded'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ],
                ['name'    => 'FileUploadFile'],
                [
                    'name'    => 'FileMimeType',
                    'options' => [
                        'mimeType'  => ['image/gif', 'image/png', 'image/jpg', 'image/jpeg']
                    ],
                    'break_chain_on_failure' => true
                ],
                ['name'    => 'FileIsImage'],
                [
                        'name'    => 'FileImageSize',
                        'options' => [
                            'minWidth'  => 128,
                            'minHeight' => 128,
                            'maxWidth'  => 4096,
                            'maxHeight' => 4096
                        ]
                ],
            ]
        ],

   ];

   }

}
