<?php

/** @CreatedBy : Mohit Jain
 *  @Description : LocalHire Model Functions
 */

namespace LocalHire\Model;

use Application\Controller\RestAPIClientController;
use Zend\Session\Container;
use Zend\Json\Json;

class Local extends RestAPIClientController {

    public function apiUrl() {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        return $config->api->url;
    }

    public function getFareData($base_vehicle_id, $modelType) {
        $val = '{"where":{"and": [{"base_vehicle_id": "' . $base_vehicle_id . '"},{"status": "1"}]}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/" . $modelType . "?&filter=" . $val;
        $resp = $this->get($url);
        return $data = Json::decode($resp->getBody(), true);
    }

    public function getMarkupGrade($gradeArray) {
        $grade="";
        if ($gradeArray['userTypeId'] == 1) {
            if (($gradeArray['userCity'] == $gradeArray['searchCity']) && ($gradeArray['userGender'] == 'Male')) {
                $grade = '1';
            } else if (($gradeArray['userCity'] == $gradeArray['searchCity']) && ($gradeArray['userGender'] == 'Female')) {
                $grade = '2';
            } else if (($gradeArray['userCity'] != $gradeArray['searchCity']) && ($gradeArray['userGender'] == 'Male')) {
                $grade = '3';
            } else if (($gradeArray['userCity'] != $gradeArray['searchCity']) && ($gradeArray['userGender'] == 'Female')) {
                $grade = '4';
            }
        } else if ($gradeArray['userTypeId'] == 7) {
            if (($gradeArray['userCity'] == $gradeArray['searchCity']) && ($gradeArray['userGender'] == 'Male')) {
                $grade = '1';
            } else if (($gradeArray['userCity'] == $gradeArray['searchCity']) && ($gradeArray['userGender'] == 'Female')) {
                $grade = '2';
            } else if (($gradeArray['userCity'] != $gradeArray['searchCity']) && ($gradeArray['userGender'] == 'Male')) {
                $grade = '3';
            } else if (($gradeArray['userCity'] != $gradeArray['searchCity']) && ($gradeArray['userGender'] == 'Female')) {
                $grade = '4';
            }
        }
        return $grade;
    }

    public function getCompanyMarkup($companyId, $cityId, $masterPackageType, $grade) {
        $markup_data = $this->apiUrl() . "/markup/getCompanyMarkup?company_id=" . $companyId . "&city_id=" . $cityId . "&master_package_id=" . $masterPackageType . "&user_grade=" . $grade;
        $markupValue = $this->get($markup_data);
        $markupData = Json::decode($markupValue->getBody(), true);
        if ($markupData['responsedata']['status'] == "failed") {
            $markup_data = $this->apiUrl() . "/markup/getCompanyMarkup?company_id=" . $companyId . "&city_id=" . $cityId . "&master_package_id=0&user_grade=" . $grade;
            $markupValue = $this->get($markup_data);
            $markupData = Json::decode($markupValue->getBody(), true);
        }else if($markupData['responsedata']['status'] == "failed"){
            $markup_data = $this->apiUrl() . "/markup/getCompanyMarkup?company_id=" . $companyId . "&user_grade=" . $grade;
            $markupValue = $this->get($markup_data);
            $markupData = Json::decode($markupValue->getBody(), true);
        }
        if ($markupData['responsedata']['status'] == "success") {
            $markupData = $markupData['responsedata']['data'][0];
        } else {
            $markupData = [];
        }
        //echo '<pre>';print_r($markupData);die();
        return $markupData;
    }

    public function getUserMarkup($companyId, $cityId, $masterPackageType,$user_id){
        echo $markup_data = $this->apiUrl() . "/markup/getCompanyMarkup?company_id=" . $companyId . "&city_id=" . $cityId . "&master_package_id=" . $masterPackageType . "&user_id=" . $user_id;
        $markupValue = $this->get($markup_data);
        $markupData = Json::decode($markupValue->getBody(), true);
        if ($markupData['responsedata']['status'] == "success") {
            $markupData = $markupData['responsedata']['data'][0];
        } else {
            $markupData = [];
        }
        //echo '<pre>';print_r($markupData);die();
        return $markupData;
    }

    public function getCurrencyDetails($currencyId){
        $val = '{"where": {"id": "' . $currencyId . '"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/master-currency?&filter=" . $val;
        $resp = $this->get($url);
        $val = Json::decode($resp->getBody(), true);
        $currData = isset($val[0]) ? $val[0] : 0;
        return $currData;
    }
    
    public function getCompanyDetail($userId){
        if($userId>0){ 
        $url = $this->apiUrl() . "/company/companydetails?user_id=" . $userId;
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $respData = Json::decode($JsonData, true);        
        if($respData['responsedata']['status']){
           return $userDetails = $respData['responsedata'];
        }else{
            return $respData['responsedata']['status'];
        }
        
        }
    }
    
    public function getBookingInfoById($bookingId){
        $apiParams = ['id' => $bookingId];
        $url = $this->apiUrl() . "/booking/bookingListSearch";
        $resp = $this->post($url, $apiParams);
        $bookingList = Json::decode($resp->getBody(), true);
        if($bookingList['responsedata']['status']=='success'){
           return $bookingList = $bookingList['responsedata']['data'];
        }else{
            return $bookingList['status'];
        }
    }
    
    
    public function checkCreditLimit($user_id){        
        $url = $this->apiUrl() . "/user/walletamount?user_id=" . $user_id;
        $resp = $this->get($url);
        $response = Json::decode($resp->getBody(), true);
         $walletAmt = $response['responsedata']['data']['credit_balance'];
        
        $url = $this->apiUrl() .'/credit-limit/getusercreditlimit?userid='.$user_id;
        $resp = $this->get($url);
        $response2 = Json::decode($resp->getBody(), true);
   
        if($response2['responsedata']['status']=='success'){
            $credit_limit = $response2['responsedata']['data']['credit_limit_amount'];
        }else{
            $credit_limit = 0;
        }
       
        $credit_balance = $credit_limit + $walletAmt;  
        return $credit_balance;
    }

}
