<?php

namespace Guide\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    Date,
    Number,
    Checkbox,
    Text,
    Submit,
    Hidden
};
use Zend\Validator\{
    NotEmpty,
    Digits
};
use Zend\InputFilter\InputFilterProviderInterface;

class LocalGuideSearchForm extends Form implements InputFilterProviderInterface {

    public static $lang = [];
    public static $tourType = [];

    public function __construct($name = null) {

        parent::__construct('vehicle-search-form');

        $this->setAttribute('method', 'post');


        //Please Select City

        $this->add([
            'name' => 'pickup_city',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pickup-city',
                'placeholder' => '',
                'class' => 'pickup-city inputMaterial'
            ],
            'options' => [
                'label' => 'I want a Guide in<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        //Pickup date
        $this->add([
            'name' => 'pickup_date',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pickup-date',
                'placeholder' => '',
                'class' => 'inputMaterial datepicker',
            ],
            'options' => [
                'label' => 'Date<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        //Pickup Time
        $this->add([
            'name' => 'pickup_time',
            'type' =>  Text::class,
            'attributes' => [
                'id' => 'pickup-time',
                'placeholder' => '',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => 'Time<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        //Please Select Package
        $this->add([
            'name' => 'guide_package',
            'type' => Select::class,
            'attributes' => [
                'id' => 'guide-package',
                'class' => 'inputMaterial',
            ],
            'options' => [
                'label' => 'I want a Guide for<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true,
                'empty_option' => '  ',
                'value_options' => [
                    'Half Day' => 'Half Day',
                    'Full Day' => 'Full Day',

                ],
            ],
        ]);


        //Number of adult
        $this->add([
            'type' => Number::class,
            'name' => 'adults',
            'attributes' => [
                'id' => 'adults',
                'class' => 'inputMaterial',
                'min' => 1,
                'max' => 9,
                'step' => 1,
                'value' => 1
            ],
            'options' => [
                'label' => 'Adults',
                'options' => [],
            ],
        ]);

        //Number of child
        $this->add([
            'type' => Number::class,
            'name' => 'childs',
            'attributes' => [
                'id' => 'childs',
                'class' => 'inputMaterial',
                'min' => 0,
                'max' => 9,
                'step' => 1,
                'value' => 0
            ],
            'options' => [
                'label' => 'Child',
                'options' => [],
            ],
        ]);

        //Number of guides
        $this->add([
            'type' => Number::class,
            'name' => 'guides',
            'attributes' => [
                'id' => 'guides',
                'class' => 'inputMaterial',
                'min' => 1,
                'max' => 9,
                'step' => 1,
                'value' => 1
            ],
            'options' => [
                'label' => 'Guides',
                'options' => [],
            ],
        ]);

        //Guide Language*
        $this->add([
            'name' => 'guide_language',
            'type' => Select::class,
            'attributes' => [
                'id' => 'guide-language',
                'class' => 'inputMaterial',
            ],
            'options' => [
                'label' => 'Guide Language<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true,
                'empty_option' => '',
                'value_options' => self::$lang
            ],
        ]);

        /**
         * Nationality
         */
        $this->add([
            'name' => 'nationality',
            'type' => Text::class,
            'attributes' => [
                'id' => 'nationality',
                'class' => 'inputMaterial country-class'
            ],
            'options' => [
                'label' => 'Nationality<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
            ],
        ]);
        //Pickup address*
        $this->add([
            'name' => 'pickup_address',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pickup-address',
                'placeholder' => '',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => 'Pickup address<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        //Terms and conditions
        $this->add([
            'name' => 'agree_terms',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'agree-terms',
            ],
            'options' => [
                'label' => 'Accept the Terms and Conditions<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'checked_value' => '1',
                'unchecked_value' => 'no',
                'use_hidden_element' => true,
            ],
        ]);

        // Tour type

        $this->add([
            'name' => 'tour_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'tour-type',
                'class' => 'inputMaterial',
            ],
            'options' => [
                'label' => 'Tour Type<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true,
                'empty_option' => '',
                'value_options' => self::$tourType
            ],
        ]);


        //submit button
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Search Guide',
                'id' => 'submitbutton',
                'class' => 'btn btn-primary btn-lg',
            ],
        ]);

        $this->add([
            'name' => 'master_package_type',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'master-package-type',
                'class' => 'inputMaterial'
            ]
        ]);

        $this->add([
            'name' => 'module_type',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'module-type',
                'class' => 'inputMaterial'
            ]
        ]);

        $this->add([
            'name' => 'city_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'city-id',
                'class' => 'inputMaterial'
            ]
        ]);

        $this->add([
            'name' => 'vehicle_type_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'vehicle-type-id',
                'class' => 'inputMaterial'
            ]
        ]);

        $this->add([
            'name' => 'city_latitude',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'city-latitude',
                'class' => 'inputMaterial'
            ]
        ]);

         $this->add([
            'name' => 'city_longitude',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'city-longitude',
                'class' => 'inputMaterial'
            ]
        ]);

        $this->add([
            'name' => 'city_northeast_latitude',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'city-northeast-latitude',
                'class' => 'inputMaterial'
            ]
        ]);

         $this->add([
            'name' => 'city_northeast_longitude',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'city-northeast-longitude',
                'class' => 'inputMaterial'
            ]
        ]);

        $this->add([
            'name' => 'city_southwest_latitude',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'city-southwest-latitude',
                'class' => 'inputMaterial'
            ]
        ]);

         $this->add([
            'name' => 'city_southwest_longitude',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'city-southwest-longitude',
                'class' => 'inputMaterial'
            ]
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'pickup_city' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select City'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'pickup_date' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [

                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Pickup Date'
                            ]
                        ],
                    ],
                    ['name' => 'Date',
                        'options' => [
                             'format'=>'d-m-Y',
                            'messages' => [
                                //Date::INVALID_DATE => '',
                                \Zend\Validator\Date::INVALID_DATE => 'Please enter Valid Date',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],
            'pickup_time' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Pickup Time'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'tour_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Tour Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'guide_language' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select language'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'guide_package' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Package'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'nationality' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Nationality'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'pickup_address' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Pickup Address'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'agree_terms' => [
                'required' => true,
                'validators' => [
                    ['name' => 'Digits',
                        'break_chain_on_failure' => true,
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please Accept the Terms and Conditions',
                            ],
                        ],
                    ],
                ],
            ],
        ];
    }

}