<?php

namespace Dashboard\View\Helper;

use Zend\View\Helper\AbstractHelper;
use Application\Controller\RestAPIClientController;
use Zend\Json\Json;

class DashboardMenu extends AbstractHelper {

 
     public function getDashboardModule($roleId) {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $apiUrl = $config->api->url;
        $api = new RestAPIClientController();       
        
      
        if($roleId > 0){
           $url = $apiUrl . '/role-assign-module/getAssignModuleByusertypeid?&user_type_id='. $roleId;
            $resp = $api->get($url);        
            $menuData = Json::decode($resp->getBody(), true);     
            
            if (isset($menuData) && !empty($menuData['responsedata'])) {
                 return $this->buildTree($menuData['responsedata']);
            }
        }
       
    }
    
    public function getAllMasterModule(){ 
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        $apiUrl = $config->api->url;
        $api = new RestAPIClientController();  
        
         $url = $apiUrl . '/module-manager';
            $resp = $api->get($url);        
            $menuData = Json::decode($resp->getBody(), true);     
           
            if (isset($menuData) && !empty($menuData)) {
                 return $this->buildTree($menuData);
            }
    }
    
    public function buildTree($elements, $parentId = 0) {
    $branch = array();

    foreach ($elements as $element) {
        if ($element['parent_id'] == $parentId) {
            $children = $this->buildTree($elements, $element['module_id']);
            if ($children) {
                $element['submenu'] = $children;
            }
            $branch[] = $element;
        }
    }

    return $branch;
   }  




}
