<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace Dashboard\Model;

use Application\Controller\RestAPIClientController;
use Zend\Session\Container;
use Zend\Json\Json;

class Template extends RestAPIClientController {

    public function apiUrl() {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        return $config->api->url;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET MAIL LIST
     * @param $data
     * @returns $responsedata
     */
    public function getMailList() {
        
        $url = $this->apiUrl() ."/email-templates";
        $resp = $this->get($url);
        $tempList = Json::decode($resp->getBody(), true);
        
        if ($tempList != "") {
            $val = ["status" => true, "data" => Json::decode($resp->getBody(), true)];
        } else {
            $val = ["status" => false, "data" => Json::decode($resp->getBody(), true)];
        }
        return $val;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO ADD MAIL INFO
     * @param $data
     * @returns $responsedata
     */
    
    public function addMailInfo() {
        
        $url = $this->apiUrl() ."/email-templates";
        $resp = $this->get($url);
        $tempList = Json::decode($resp->getBody(), true);
        
        if ($tempList != "") {
            $val = ["status" => true, "data" => Json::decode($resp->getBody(), true)];
        } else {
            $val = ["status" => false, "data" => Json::decode($resp->getBody(), true)];
        }
        return $val;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO INSERT MAIL DETAILS
     * @param $data
     * @returns $responsedata
     */
    
    public function insertMailDetails($data) {
       $sessionContainer = new Container('userlogin');
       $userId = $sessionContainer->user_id;
        if($data !='')
        {       
        $data['created_date']=date('Y-m-d H:i:s');
        $data['ip']=$_SERVER['REMOTE_ADDR'];
        $data['created_by']=$userId;
        $url = $this->apiUrl() . "/email-templates";
        $resp = $this->post($url, $data);
        $vehicleTypeJsonData = Json::decode($resp->getBody(), true);
        }
        return $vehicleTypeJsonData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO EDIT MAIL DETAILS
     * @param $data
     * @returns $responsedata
     */
    
    public function editMailDetails($post) {
       $sessionContainer = new Container('userlogin');
       $userId = $sessionContainer->user_id;
        
        if($post['id'] !='')
        {
                $val = '{"id": "' .$post['id'] . '"}';
                $val = rawurlencode($val);
                $url = $this->apiUrl() . "/email-templates/update?where=" . $val;
                $post['modified_by']=$userId;
                $val = $this->post($url, $post);
                $JsonData = $val->getBody();
                $JsonData = Json::decode($JsonData, true);
                 
        }
        return $JsonData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO UPDATE MAIL STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function updateMailStatus($data) {
        
        $url = $this->apiUrl() . "/email-templates/emailStatus?id=".$data['id']."&email_status=".$data['email_status']; 
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET DESC
     * @param $data
     * @returns $responsedata
     */
    
    public function getDesc($data) {
        $id=$data['id'];
        $url = $this->apiUrl() ."/email-templates/".$id;
        $resp = $this->get($url);
        $tempList = Json::decode($resp->getBody(), true);
        if ($tempList != "") {
            $val = ["status" => true, "data" => Json::decode($resp->getBody(), true)];
        } else {
            $val = ["status" => false, "data" => Json::decode($resp->getBody(), true)];
        }
        return $val;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET SMS LIST
     * @param $data
     * @returns $responsedata
     */
    
    public function getSmsList() {
        
        $url = $this->apiUrl() ."/sms_template";
        $resp = $this->get($url);
        $tempList = Json::decode($resp->getBody(), true);
        
        if ($tempList != "") {
            $val = ["status" => true, "data" => Json::decode($resp->getBody(), true)];
        } else {
            $val = ["status" => false, "data" => Json::decode($resp->getBody(), true)];
        }
        return $val;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO INSERT SMS DETAILS
     * @param $data
     * @returns $responsedata
     */
    
    public function insertSmsDetails($data) {
       $sessionContainer = new Container('userlogin');
       $userId = $sessionContainer->user_id;
     
        if($data !='')
        { 
        $data['created_by']=$userId;
        $data['created_date']=date('Y-m-d H:i:s');
        
        $url = $this->apiUrl() ."/sms_template"; 
        $resp = $this->post($url,$data);
        $vehicleTypeJsonData = Json::decode($resp->getBody(), true);
        }
        return $vehicleTypeJsonData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET SMS DETAILS
     * @param $data
     * @returns $responsedata
     */
 
    public function getsmsdetail($id) {
        $val=[];
        if($id !=''){
        $url = $this->apiUrl() ."/sms_template/".$id;
        $resp = $this->get($url);
        $tempList = Json::decode($resp->getBody(), true);
        if ($tempList != "") {
            $val = ["status" => true, "data" => Json::decode($resp->getBody(), true)];
        } else {
            $val = ["status" => false, "data" => Json::decode($resp->getBody(), true)];
        }
        }
        return $val;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO EDIT SMS DETAILS
     * @param $data
     * @returns $responsedata
     */
    
    public function editSmsDetails($post) {
       $sessionContainer = new Container('userlogin');
       $userId = $sessionContainer->user_id;   
        if($post['id'] !='')
        {
               $val = '{"id": "' .$post['id'] . '"}';
                $val = rawurlencode($val);
                $url = $this->apiUrl() . "/sms_template/update?where=" . $val;
                $val = $this->post($url, $post);
                $JsonData = $val->getBody();
                $JsonData = Json::decode($JsonData, true);
                 
        }
        return $JsonData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO UPDATE SMS STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function updateSmsStatus($data) {
        
        $url = $this->apiUrl() . "/sms_template/smsStatus?id=".$data['id']."&sms_status=".$data['sms_status']; 
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }

}
