<?php

namespace Dashboard\Model;

use Application\Controller\RestAPIClientController;
use Zend\Session\Container;
use Zend\Json\Json;
use Dashboard\View\Helper\DashboardMenu;

class Role extends RestAPIClientController {
    
    public function apiUrl() {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        return $config->api->url;
    }
    
    /** @CreatedBy : Mohit Verma
     * @CreatedDate: 2-May-2019
     * @Desc : Get All Master Modules Listing
     *  */
    public function MasterModules(){
        $dashboardhelper = new DashboardMenu();
        $allmodules = $dashboardhelper->getAllMasterModule();       
        return $allmodules;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET ALL MASTER MODULE BY ID
     * @param $data
     * @returns $responsedata
     */
    public function getAllMasterModuleById($moduleId){
        
        $val = '{"where": {"module_id": "' . $moduleId . '"}}';      
        $val = rawurlencode($val);
        $url = $this->apiUrl() ."/module-manager?filter=".$val;
      
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $JsonData = Json::decode($JsonData, true);   
        if ((!empty($JsonData))) {
            $result= $JsonData[0];
        }
        return $result;
    }
}