<?php

/** @CreatedBy : Mohit verma
 *  @Description : Common Model Functions 
 */

namespace Dashboard\Model;

use Application\Controller\RestAPIClientController;
use Zend\Session\Container;
use Zend\Json\Json;

class CommonModel extends RestAPIClientController {

    public function apiUrl() {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        return $config->api->url;
    }

    /** @CreatedBy : Mohit Verma
    *   @Description : Get Department Name By User Id
     *  @param : User Id 
    */
    public function getDepartmentByuserId($userId){
        $JsonDataArray = [];
        $val = '{"where": {"created_by": "'.$userId.'"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/department?&filter=" . $val;
        $resp = $this->get($url);
        $kycTypeJsonData = Json::decode($resp->getBody(), true);
        foreach ($kycTypeJsonData as $res) {
            $JsonDataArray[$res['id']] = $res['department_name'];
        }
        return $JsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO GET PACKAGE TYPE LIST
     * @param $data
     * @returns $responsedata
     */
    
    public function getPackageTypeList() {
        $packageTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/package";
        $resp = $this->get($url);
        $packageTypeJsonData = Json::decode($resp->getBody(), true);
        if(count($packageTypeJsonData['data'])>0){
        foreach ($packageTypeJsonData['data'] as $res) {
            $packageTypeJsonDataArray[$res['id']] = $res['name'];
        }
        }
        return $packageTypeJsonDataArray;
    }
    
    /** @Description : Get Package Mode List(Distance,Distance+hour,Distance+waiting,Hour)
     *  @CreatedBy   : Mohit Verma     
     */
    public function getPackageModeList() {
        $packageModeJsonDataArray = [];
        $url = $this->apiUrl() . "/package-mode";
        $resp = $this->get($url);
        $packageModeJsonData = Json::decode($resp->getBody(), true);
        foreach ($packageModeJsonData as $res) {
            $packageModeJsonDataArray[$res['id']] = $res['package_mode'];
        }
        return $packageModeJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO GET DOCUMENT TYPE BY NAME
     * @param $data
     * @returns $responsedata
     */
    
    public function getDocumentTypeByName($documentName){
        $response = [];
        if(isset($documentName) && $documentName!=''){
        $val = '{"where": {"doc_level_name":"' . $documentName . '"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/document-type?&filter=" . $val;
        $resp = $this->get($url);
        return $response = Json::decode($resp->getBody(), true);
        }else{
             return $response;
        }
    }
    
     /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO UPLOAD IMAGE
     * @param $data
     * @returns $responsedata
     */
    public function uploadimageapi($arrval = array()) {
        $url = $this->apiUrl() . "/user/uploadImg";
        $val = $this->post($url, $arrval);
        $JsonData = $val->getBody();
        $JsonData = Json::decode($JsonData, true);
    }      
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE PACKAGE LIST
     * @param $data
     * @returns $responsedata
     */
    
    public function getPackageListAction($booking_type_id) {
        $packageTypeJsonDataArray = [];
        $postData = $this->getRequest()->getPost();
        $val = '{"where": {"booking_type_id": "' . $booking_type_id . '"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/package?&filter=" . $val;
        $resp = $this->get($url);
        $packageTypeJsonData = Json::decode($resp->getBody(), true);
        if ($packageTypeJsonData['status']=="success") {
            foreach ($packageTypeJsonData['data'] as $res) {
                $packageTypeJsonDataArray[$res['id']] = $res['name'];
            }
        }
       return $packageTypeJsonDataArray;
    }
    
}
    