<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace Dashboard\Model;
use Application\Controller\RestAPIClientController;
use Zend\Session\Container;
use Zend\Json\Json;

class Booking extends RestAPIClientController {

    public function apiUrl() {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        return $config->api->url;
    }

     //Get distance fare detail by base_vehicle_id //
    function getDistanceFare() {
        $arrdata  = ['message'=>'hello'];
        return $arrdata;
    }
    // End//

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO GET CREDIT BALANCE
     * @param $data
     * @returns $responsedata
     */
    public function getCreditBalance($data) {
        $url = $this->apiUrl() . "/user-management/userCreditLimit";
        $resp = $this->get($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO GET RECENT BOOKINGS
     * @param $data
     * @returns $responsedata
     */
    public function getRecentBookings($data) {
        //$url = $this->apiUrl() . "/booking/bookingList";
        $url = $this->apiUrl() . "/booking/bookingListSearch";
        $resp = $this->post($url, $data);
        $data = Json::decode($resp->getBody(), true);
        $result = [];
        if($data['responsedata']['status']=='success'){
           $result  = $data['responsedata']['data'];
        }
        return $result;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO GET WALLET POINTS
     * @param $data
     * @returns $responsedata
     */
    
    public function getWalletPoint($data) {
        if($data['id']>0){
        $url = $this->apiUrl() . "/user-management/userWalletHistory?id=".$data['id'];
        }else{
        $url = $this->apiUrl() . "/user-management/userWalletHistory";
        }
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO GET CANCEL BOOKINGS
     * @param $data
     * @returns $responsedata
     */
    public function getCancelBookings($data) {
        $url = $this->apiUrl() . "/booking/bookingList";
        $resp = $this->post($url,$data);
        $responsedata = Json::decode($resp->getBody(), true);
        $result = [];
        if($responsedata['responsedata']['status']=='success'){
           $result  = $responsedata['responsedata']['data'];
        }
        return $result;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO GET BOOKING COUNTS
     * @param $data
     * @returns $responsedata
     */
    public function getBookingCounts($data) {
        $url = $this->apiUrl() . "/booking/getbookingCount";
        $resp = $this->post($url,$data);
        $responsedata = Json::decode($resp->getBody(), true);
        $result = [];
        if($responsedata['responsedata']['status']=='success'){
           $result  = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO GET WALLET AMOUNT
     * @param $data
     * @returns $responsedata
     */

    public function getWalletAmt($user_id) {
        $url = $this->apiUrl() . "/user/walletamount?user_id=" . $user_id;
        $resp = $this->get($url);
        $response = Json::decode($resp->getBody(), true);
        $walletAmt = $response['responsedata']['data']['wallet_amount'];
        if ($walletAmt != "") {
            $data = $response['responsedata']['data']['wallet_amount'];
        } else {
            $data = 0;
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO GET CAB STATUS LIST
     * @param $data
     * @returns $responsedata
     */
    
    public function getCabStatusList() {
        $statusJsonDataArray = [];
        $status_type = 'cab';
        $val = '{"where": {"type":"' . $status_type . '"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/cab-status?&filter=" . $val;
        $resp = $this->get($url);
        $statusJsonData = Json::decode($resp->getBody(), true);
        foreach ($statusJsonData as $res) {
            $statusJsonDataArray[$res['status_id']] = $res['status'];
        }
        return $statusJsonDataArray;
    }
}