<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
namespace Dashboard\Model;

use Application\Controller\RestAPIClientController;
use Zend\Session\Container;
use Zend\Json\Json;

class Bid extends RestAPIClientController {

    public function apiUrl() {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        return $config->api->url;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO GET BIDDING LISTING
     * @param $data
     * @returns $responsedata
     */
    public function bidlisting($data) {
        $url = $this->apiUrl() . "/bidding/getBidding";
        //echo $url; die;
        $resp = $this->post($url, $data);
        $cityJsonData = Json::decode($resp->getBody(), true);
        return $cityJsonData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO GET CITY LIST
     * @param $data
     * @returns $responsedata
     */
    
    public function cityList($postdata){
        $term = $postdata['term'];
        $val = '{"where": {"name": {"like": "' . $term . '%"}},"limit":10}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/city?&filter=" . $val;
        $resp = $this->get($url);
        $cityJsonData = Json::decode($resp->getBody(), true);
        return $cityJsonData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO GET KILOMETER
     * @param $data
     * @returns $responsedata
     */
    
    public function kiloMeter($postdata){
        $cityJsonData=[];
        $source_name='';
        $destination_name='';
        $source_id=0;
        $destination_id=0;

        $source_name = $postdata['source_name'];
        $destination_name =  $postdata['destination_name'];
        $source_id = $postdata['source_id'];
        $destination_id = $postdata['destination_id'];
        if(!empty($source_id && $destination_id)){
        $val = '{"where":{"and": [{"source_city": "'.$source_id.'"},{"destination_city": "'.$destination_id.'"}]}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/city-distance-list?filter=" . $val;
        $resp = $this->get($url);
        $cityJsonData = Json::decode($resp->getBody(), true);

        if(empty($cityJsonData))
        {

        $api = file_get_contents("https://maps.googleapis.com/maps/api/distancematrix/json?units=imperial&origins=".$source_name."&destinations=".$destination_name."&key=AIzaSyBiFNtCEUrKPHbCUOdqVKMCsq9-uPB5sc4");
       $data = json_decode($api);
       $distance= ((int)$data->rows[0]->elements[0]->distance->value / 1000);
       if(!empty($distance && $source_name && $destination_name))
       {
        $distancedetail=[];
        $distancedetail=[
            'source_city' => $source_id,
            'destination_city'=> $destination_id,
            'distance_km'=>$distance
        ];

        $url = $this->apiUrl() . "/city-distance-list";
        $resp = $this->post($url, $distancedetail);
        $cityDistanceJsonData = Json::decode($resp->getBody(), true);
        if(!empty($cityDistanceJsonData))
        {
        $val = '{"where":{"and": [{"source_city": "'.$source_id.'"},{"destination_city": "'.$destination_id.'"}]}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/city-distance-list?filter=" . $val;
        $resp = $this->get($url);
        $cityJsonData = Json::decode($resp->getBody(), true);

        }

       }

       }
      }
        return $cityJsonData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO INSERT BID INFO
     * @param $data
     * @returns $responsedata
     */

    public function insertBidInfo($postdata){

        if($postdata !='')
        {
        $url = $this->apiUrl() . "/bidding/addbidding";
        $resp = $this->post($url, $postdata);
        $vehicleTypeJsonData = Json::decode($resp->getBody(), true);
        }
        else{
            $vehicleTypeJsonData="";
        }

        return $vehicleTypeJsonData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO GET BIDDING INFO
     * @param $data
     * @returns $responsedata
     */

    public function getBidInfo($data) {
        $url = $this->apiUrl() . "/bidding/getBidding";
        $resp = $this->post($url, $data);
        $response = Json::decode($resp->getBody(), true);
        return $response;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO UPDATE BID INFO
     * @param $data
     * @returns $responsedata
     */

    public function updateBidInfo($postdata){
    if($postdata !='')
        {
        $url = $this->apiUrl() . "/bidding/updateBidding";
        $resp = $this->post($url, $postdata);
        $vehicleTypeJsonData = Json::decode($resp->getBody(), true);
        }
        else{
            $vehicleTypeJsonData="";
        }

        return $vehicleTypeJsonData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO UPDATE THE BID STATUS
     * @param $data
     * @returns $responsedata
     */

    public function bidStatusUpdation($data) {
        $url = $this->apiUrl() . "/bidding/deleteBidding";
        $resp = $this->post($url, $data);
        $biddingList = Json::decode($resp->getBody(), true);
        $result = [];
        if ($biddingList['responsedata']['status'] == 'success') {
            $result = $biddingList['responsedata']['data'];
        }
        return $result;
    }
}