<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Radio,
    Submit,
    Checkbox,
    Date,
    Hidden
};
use Zend\Validator\{
    NotEmpty
};
use Zend\InputFilter\InputFilterProviderInterface;

class VoucherForm extends Form implements InputFilterProviderInterface {

    public static $payment_status = [];
    public static $vouchertype = [];
    public static $paymenttype = ['1' => 'Debit', '2' => 'Credit'];

    public function __construct($name = null) {

        parent::__construct('voucher-form');
        $this->setAttribute('method', 'post');

        /**
         * Payment Status
         */
        $this->add([
            'name' => 'voucher_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'voucher-type',
                'class' => 'input form-control'
            ],
            'options' => [
                'label' => 'Voucher Type',
                'value_options' => self::$vouchertype,
                'disable_inarray_validator' => true,
                'empty_option' => 'Select',
            ]
        ]);

        /**
         *
         * VOUCHER NO
         */
        $this->add([
            'name' => 'voucher_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'voucher-no',
                'placeholder' => 'Voucher No',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Voucher No',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Voucher Date
         */
        $this->add([
            'name' => 'voucher_date',
            'type' => Date::class,
            'attributes' => [
                'id' => 'voucher-date',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Voucher Date',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Payment Status
         */
        $this->add([
            'name' => 'payment_type[]',
            'type' => Select::class,
            'attributes' => [
                'id' => 'payment-type',
                'class' => 'input form-control'
            ],
            'options' => [
                'label' => 'Payment Type',
                'value_options' => self::$paymenttype,
                'disable_inarray_validator' => true,
            ]
        ]);

        /**
         *
         * Amount
         */
        $this->add([
            'name' => 'amount[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'amount',
                'placeholder' => 'Amount',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Amount',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         *
         * Booking ID
         */
        $this->add([
            'name' => 'booking_id[]',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'booking-id',
            ],
        ]);

        /**
         *
         * Booking ID
         */
        $this->add([
            'name' => 'booking_invoice_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'booking-invoice-id',
            ],
        ]);


        /**
         *
         * Invoice No
         */
        $this->add([
            'name' => 'invoice_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'invoice-no',
                'placeholder' => 'Invoice No',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Invoice No',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Search
         */
        $this->add([
            'name' => 'search',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Search',
                'id' => 'search',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);

        /**
         * Clear
         */
        $this->add([
            'name' => 'clear',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Clear',
                'id' => 'clear',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);

        /**
         *
         * save
         */
        $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'voucher-save-btn',
                'placeholder' => 'Save',
                'class' => 'btn btn-unapublish pull-right margin-L-1',
                'Value' => 'Save',
                'onclick' => "submitForm('#voucher-form', event);"
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'voucher_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Voucher Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'voucher_no' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Voucher No'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'voucher_date' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Date'
                            ]
                        ],
                    ],
                    ['name' => 'Date',
                        'options' => [
                            'messages' => [
                                //Date::INVALID_DATE => '',
                                \Zend\Validator\Date::INVALID_DATE => '',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],
            'payment_type[]' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Payment Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'amount[]' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Amount'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
        ];
    }

}
