<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden
};

class VehicleTypeForm extends Form {

    public static $vehicletype = [];

    public function __construct($name = null) {

        parent::__construct('cab-type-search-type');

        $this->setAttribute('method', 'post');

         /**
         *
         * status
         */
        $this->add([
            'name' => 'status',
            'type' => Radio::class,
            'attributes' => [
                'id' => 'active',
            ],
            'options' => [
                'label' => '<span class="radio">Active</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => array(
                '1' => 'Active',
                '0' => 'In-Active',
            ),
            ],
        ]);

        /**
         *
         * vehicle type
         */
        $this->add([
            'name' => 'vehicle_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'vehicle-type-id',
                'placeholder' => '',
                'class' => 'input form-control '
            ],
            'options' => [
                'label' => 'Vehicle Type',
                'value_options' => self::$vehicletype,
                'empty_option' => 'Select Vehicle Type',
            ],
        ]);

        /**
         *
         * vehicle type_name
         */
        $this->add([
            'name' => 'vehicle_type_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'vehicle-type-name',
                'placeholder' => '',
                'class' => 'input form-control '
            ],
            'options' => [
                'label' => 'Vehicle Type',
            ],
        ]);

        /**
         *
         * vehicle type_name
         */
        $this->add([
            'name' => 'vehicle_type_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'vehicle-type-id',
                'placeholder' => '',
                'class' => 'input form-control '
            ],
            'options' => [
                'label' => 'Vehicle Type',
            ],
        ]);




        /**
         *
         * Search Button
         */
        $this->add([
            'name' => 'search_vehicle_type',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'search-vehicle-type',
                'placeholder' => 'Search',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Search'
            ],
        ]);


        $this->add([
            'name' => 'add_vehicle_type',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'addvehicle-type',
                'placeholder' => 'Add Vehicle',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Save'
            ],
        ]);

        $this->add([
            'name' => 'edit_vehicle_type',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'editvehicle-type',
                'placeholder' => 'Add Vehicle',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Edit Vehicle'
            ],
        ]);

        $this->add([
            'name' => 'clear_button',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'clear-button-id',
                'placeholder' => 'Submit',
                'class' => 'btn btn-red btn-warning',
                'value' => 'Clear'
            ],
        ]);
    }

}
