<?php

namespace Dashboard\Form;

use Zend\Form\Form;
//use Zend\Form\Element;
//use Zend\Form\Element\Select;
//use Zend\Form\Element\Text;
//use Zend\Form\Element\Textarea;
//use Zend\Form\Element\Submit;

use Zend\Form\Element\{
    Select,
    Date,
    Number,
    Checkbox,
    Text,
    Submit,
    Hidden,
    Textarea,
    File
};
use Zend\Validator\{
    NotEmpty,
    Digits
};

use Zend\InputFilter\InputFilterProviderInterface;

class UserRoleManagerForm extends Form implements InputFilterProviderInterface {


    public function __construct($name = null) {

        parent::__construct('userrolemanager');

        /**
         *
         *  Title...
         */
         $this->add([
            'name' => 'title',
            'type' => text::class,
            'attributes' => [
                'id' => 'title',
                'class' => 'form-control',
            ],
        ]);
         /**
         *
         *  Id...
         */
         $this->add([
            'name' => 'role_id',
            'type' => Hidden::class,
            'attributes' => [
                'class' => 'form-control',
            ],
        ]);
          /**
         *
         *  Description...
         */
         $this->add([
            'name' => 'description',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'description',
                'class' => 'form-control',
            ],
        ]);



         /**
         *
         * Save...
         */
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'options' => [
            'label'   => '<i class="icon icon-foo"></i> Submit',
           // 'icon'    => '<i class="fa fa-save>',
            'disable_html_escape' => true,
    ],
            'attributes' => [
                'value' => 'Save',
                'id' => 'submit-button',
                'class' => 'save_data_btn btn btn-primary btn-warning',
            ],


        ]);



    }
  public function getInputFilterSpecification() {
        return [



            'title' => [
               'required' => true,
               'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
               ],
                'validators' => [
                    ['name' => 'NotEmpty',
                       'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Title Name'
                            ]
                       ],
                        'break_chain_on_failure' => true
                    ]
                ]
           ],

            'description' => [
               'required' => true,
               'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
               ],
                'validators' => [
                    ['name' => 'NotEmpty',
                       'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Description'
                            ]
                       ],
                        'break_chain_on_failure' => true
                    ]
                ]
           ],



            ];


}
}
