<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Radio,
    Submit,
    Checkbox,
    Email,
    Textarea,
    Date,
    Hidden
};
use Zend\Validator\{
    NotEmpty
};
use Zend\InputFilter\InputFilterProviderInterface;

class SiteConfigurationForm extends Form implements InputFilterProviderInterface {

    public static $country = [];
    public static $supp_lang = [];
    public static $def_curr = [];
    public static $def_format = [];
    public static $date_format_short = [];
    public static $date_format_long = [];
    public static $time_format_short = [];
    public static $time_format_long = [];
    public static $site_owner = [];

    public function __construct($name = null) {

        parent::__construct('site-configuration');
        $this->setAttribute('method', 'post');

        /**
         *
         * Site name
         */
        $this->add([
            'name' => 'site_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'site-name-id',
                'placeholder' => 'Booking Cabs',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Site name:<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Site Title
         */
        $this->add([
            'name' => 'site_title',
            'type' => Text::class,
            'attributes' => [
                'id' => 'site-title',
                'placeholder' => 'Booking Cabs',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Site Title<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Site URL
         */
        $this->add([
            'name' => 'site_url',
            'type' => Text::class,
            'attributes' => [
                'id' => 'site-url',
                'placeholder' => 'Booking Cabs',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Site Url<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Default Country
         */
        $this->add([
            'name' => 'country_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'country-id',
                'placeholder' => 'india',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Country<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$country,
                'empty_option' => 'Select Country',
                'disable_inarray_validator' => true,
            ],
        ]);

        /**
         *
         * Supported Language
         */
        $this->add([
            'name' => 'language',
            'type' => Select::class,
            'attributes' => [
                'id' => 'language',
                'placeholder' => 'English',
                'class' => 'fieldname form-control'
            ],
            'options' => [
                'label' => 'Language',
                'value_options' => self::$supp_lang
            ],
        ]);

        /**
         *
         * Add language
         */
        $this->add([
            'name' => 'add_language',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'add-language-id',
                'placeholder' => 'Add language',
                'class' => 'btn btn-success no-radus supported_language-block-row-add display-inline',
            ],
        ]);

        /**
         *
         * Default Currency
         */
        $this->add([
            'name' => 'currency_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'currency-id',
                'placeholder' => 'English',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Currency<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$def_curr,
                'empty_option' => 'Select Currency',
                'disable_inarray_validator' => true,
            ],
        ]);

        /**
         *
         * Default Format
         */
        $this->add([
            'name' => 'price_format',
            'type' => Select::class,
            'attributes' => [
                'id' => 'price-format',
                'placeholder' => 'English',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Price Format<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$def_format,
                'empty_option' => 'Select Format',
                'disable_inarray_validator' => true,
            ],
        ]);

        /**
         *
         * Maintenance Mode Message
         */
        $this->add([
            'name' => 'maintenance_mode_message',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'maintenance-mode-message',
                'placeholder' => 'We are offline',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Maintainence Mode Message',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Date Format (short)
         */
        $this->add([
            'name' => 'date_format_short',
            'type' => Select::class,
            'attributes' => [
                'id' => 'date-format-short',
                'placeholder' => 'dd/mm/yyyy',
                'class' => 'form-control widthpersent50'
            ],
            'options' => [
                'label' => 'Date Format(short):',
                'value_options' => self::$date_format_short,
                'empty_option' => 'Select',
                'disable_inarray_validator' => true,
            ],
        ]);

        /**
         *
         * Date Format (long)
         */
        $this->add([
            'name' => 'date_format_long',
            'type' => Select::class,
            'attributes' => [
                'id' => 'date-format-long-id',
                'placeholder' => 'month date,year',
                'class' => 'form-control widthpersent50'
            ],
            'options' => [
                'label' => 'Date Format(long):',
                'value_options' => self::$date_format_long,
                'empty_option' => 'Select',
                'disable_inarray_validator' => true,
            ],
        ]);

        /**
         *
         * Time Format (short)
         */
        $this->add([
            'name' => 'time_format_short',
            'type' => Select::class,
            'attributes' => [
                'id' => 'time-format-short-id',
                'placeholder' => '',
                'class' => 'form-control widthpersent50'
            ],
            'options' => [
                'label' => 'Time format(short):',
                'value_options' => self::$time_format_short,
                'empty_option' => 'Select',
                'disable_inarray_validator' => true,
            ],
        ]);

        /**
         *
         * Time Format (long)
         */
        $this->add([
            'name' => 'time_format_long',
            'type' => Select::class,
            'attributes' => [
                'id' => 'time-format-long-id',
                'placeholder' => '12:03:02 PM',
                'class' => 'form-control widthpersent50'
            ],
            'options' => [
                'label' => 'Time Format(Long):',
                'value_options' => self::$time_format_long,
                'empty_option' => 'Select',
                'disable_inarray_validator' => true,
            ],
        ]);

        /**
         *
         * Select Your Account(Site Owner)
         */
        $this->add([
            'name' => 'site_owner',
            'type' => Select::class,
            'attributes' => [
                'id' => 'site-owner',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Select your account(Site Owner)<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$site_owner,
                'empty_option' => 'Select',
                'disable_inarray_validator' => true,
            ],
        ]);

        /**
         *
         * URL of logo printed on invoice
         */
        $this->add([
            'name' => 'logo_url',
            'type' => Text::class,
            'attributes' => [
                'id' => 'logo-url',
                'placeholder' => 'https://bookingcabs.com/images/logo.jpg',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'URL of logo printed on invoice:',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Pay To Text
         */
        $this->add([
            'name' => 'pay_to_text',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'pay-to-text-id',
                'placeholder' => 'PAY TO : Mr xxxxxxxxxx',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Pay To Text:',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Keywords
         */
        $this->add([
            'name' => 'meta_key',
            'type' => Text::class,
            'attributes' => [
                'id' => 'meta-key',
                'placeholder' => 'keyword',
                'class' => 'form-control ',
            ],
            'options' => [
                'label' => 'Keywords',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Description
         */
        $this->add([
            'name' => 'meta_desc',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'meta-desc',
                'placeholder' => 'Write Description',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Description',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * button System Backup
         */
        $this->add([
            'name' => 'system_backup',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'system-backup-id',
                'placeholder' => 'System Backup',
                'class' => 'btn btn-info',
            ],
        ]);

        /**
         *
         * button Restore
         */
        $this->add([
            'name' => 'restore',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'restore-id',
                'placeholder' => 'Restore',
                'class' => 'btn btn-danger',
            ],
        ]);


        /**
         *
         * button reset
         */
        $this->add([
            'name' => 'reset',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'reset-id',
                'placeholder' => 'reset',
                'class' => 'btn btn-success',
            ],
        ]);

        /**
         *
         * save
         */
        $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'site-config-save-btn',
                'placeholder' => 'Save',
                'class' => 'save_data_btn btn btn-primary btn-warning pull-right margin-L-1',
                'Value' => 'Save',
                'onclick' => "submitForm('#site-configuration', event);"
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'site_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Site Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'site_title' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Site Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'site_url' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Site Url'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'country_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Country'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'currency_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Currency'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'price_format' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Price Format'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'maintenance_mode_message' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Price Format'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'date_format_short' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Short Format'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'date_format_long' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Long Format'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'time_format_short' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Short Time Format'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'time_format_long' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Long Time Format'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'site_owner' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Site Owner'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'maintenance_mode_message' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Long Time Format'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'url_of_logo' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Long Time Format'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'pay_to_text' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Long Time Format'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'keywords' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Long Time Format'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'description' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Long Time Format'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
        ];
    }

}
