<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;


use Zend\Form\Element\Select;
use Zend\Form\Element\File;
use Zend\Form\Element\Text;
use Zend\Form\Element\Radio;
use Zend\Form\Element\Submit;
use Zend\Form\Element\Checkbox;
use Zend\Form\Element\Email;
use Zend\Form\Element\Textarea;
class SetupGlobalSettingUserRoleForm extends Form {
    
    public static $role=[];
    public static $registration_role=[];
    public static $customer_role=[];

    public function __construct($name = null) {

        parent::__construct('profile-personal');

        $this->setAttribute('method', 'post');
        
        /**
         * 
         * Select Role
         */
          $this->add([
            'name' => 'select_role',
            'type' => Select::class,
            'attributes' => [
                'id' => 'select-role-id',  
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Select Role',
                'value_options' => self::$role
            ],
        ]);
          
          /**
         * 
         * button Go To Settings
         */
          $this->add([
            'name' => 'go_to_setting',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'go-to-setting-id',    
                'placeholder' => 'Go To Settings',
                'class' => 'btn btn-success',
            ],
           
        ]);
          
          /**
         * 
         * Default Registeration Role
         */
          $this->add([
            'name' => 'default_registration_role',
            'type' => Select::class,
            'attributes' => [
                'id' => 'default-registration-role-id',  
                'placeholder' => 'india',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Default Registeration Role',
                'value_options' => self::$registration_role
            ],
        ]);
          
           
          /**
         * 
         * Default Customer Role
         */
          $this->add([
            'name' => 'default_customer_role',
            'type' => Select::class,
            'attributes' => [
                'id' => 'default-customer-role-id',  
                'placeholder' => 'india',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Default Customer Role',
                'value_options' => self::$customer_role
            ],
        ]);
           /**
         * 
         * button System Backup
         */
         $this->add([
            'name' => 'system_backup',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'system-backup-id',    
                'placeholder' => 'System Backup',
                'class' => 'btn btn-info',
            ],
           
        ]);
          
         /**
         * 
         * button Restore
         */
          $this->add([
            'name' => 'restore',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'restore-id',    
                'placeholder' => 'Restore',
                'class' => 'btn btn-danger',
            ],
           
        ]);
          
            
         /**
         * 
         * button reset
         */
          $this->add([
            'name' => 'reset',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'reset-id',    
                'placeholder' => 'reset',
                'class' => 'btn btn-success',
            ],
           
        ]);
          
          /**
         * 
         * button Save
         */
          $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'save-id',    
                'placeholder' => 'Save',
                'class' => 'save_data_btn btn btn-primary btn-warning',
            ],
           
        ]);
          
    }

}
