<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Date,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden
};
use Zend\Validator\{
    NotEmpty,
    Digits,
    EmailAddress,
    StringLength
};
use Zend\InputFilter\InputFilterProviderInterface;

class ProfilePersonalForm extends Form implements InputFilterProviderInterface {

    public static $gender = ['Male' => 'Male', 'Female' => 'Female'];
    public static $kyctype = [];
    public static $usertype = [];

    public function __construct($name = null) {

        parent::__construct('profile-personal');
        //$this->setAttribute('method', 'post');

        /**
         * First Name
         */
        $this->add([
            'name' => 'first_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'first-name',
                'placeholder' => 'Full Name.',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'First Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Last Name
         */
        $this->add([
            'name' => 'last_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'last-name',
                'placeholder' => 'Last Name',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Last Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Father`s Name
         */
        $this->add([
            'name' => 'father_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'father-name',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Father`s Name',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * EMAIL ID
         */
        $this->add([
            'name' => 'email',
            'type' => Text::class,
            'attributes' => [
                'id' => 'email',
                'placeholder' => 'example@mail.com',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Email<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Email Verified
         */
        $this->add([
            'name' => 'email_verified',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'email-verified',
                'class' => 'form-control',
                'disabled' => true,
                'style'=> 'display: none'
            ],
            'options' => [
                'label' => 'Email Verified',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Newsletter Subscription
         */
        $this->add([
            'name' => 'newsletter_subscription',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'newsletter-subscription',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Newsletter Subscription',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Mobile Number
         */
        $this->add([
            'name' => 'mobile',
            'type' => Text::class,
            'attributes' => [
                'id' => 'mobile-number',
                'placeholder' => 'Mobile',
                'class' => 'form-control',
                'maxlength'=> 10,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Mobile No.<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         * Phone Number
         */
        $this->add([
            'name' => 'landline_number',
            'type' => Text::class,
            'attributes' => [
                'id' => 'landline-number',
                'class' => 'form-control',
                'maxlength'=> 12,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Phone No.',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Phone Number Verified
         */
        $this->add([
            'name' => 'phone_verified',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'phone-verified',
                'placeholder' => '',
                'class' => 'form-control',
                'disabled' => true,
                'style'=> 'display: none'
            ],
            'options' => [
                'label' => 'Phone Verified',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);



        /**
         * Alternate Mobile Number
         */
        $this->add([
            'name' => 'alternate_mobile',
            'type' => Text::class,
            'attributes' => [
                'id' => 'alternate-mobile',
                'placeholder' => 'Alt Mobile',
                'class' => 'form-control',
                'maxlength'=> 12,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Alt Mobile No.'
            ],
        ]);


        /**
         * External Reference
         */
        $this->add([
            'name' => 'refer_by',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'refer-by',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'External Ref',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        /**
         * Referral Key
         */
        $this->add([
            'name' => 'referral_key',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'referral-key',
                'placeholder' => 'referral key',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'External Ref',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);



        /**
         * Date Of Birth
         */
        $this->add([
            'name' => 'dob',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dob',
                'placeholder' => '',
                'class' => 'form-control dob'
            ],
            'options' => [
                'label' => 'DOB<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Gender
         */
        $this->add([
            'name' => 'gender',
            'type' => Select::class,
            'attributes' => [
                'id' => 'gender',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Gender<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$gender,
                'disable_inarray_validator' => true,
                'empty_option' => 'Select Gender',
            ],
        ]);

        /**
         * Address
         */
        $this->add([
            'name' => 'address',
            'type' => Text::class,
            'attributes' => [
                'id' => 'address',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Address<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * State
         */
        $this->add([
            'name' => 'state_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'state-name',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'State<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * State Value
         */
        $this->add([
            'name' => 'state_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'state-value'
            ],
        ]);

        /**
         * City
         */
        $this->add([
            'name' => 'city_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'city-name',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'City<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * City Value
         */
        $this->add([
            'name' => 'city_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'city-value'
            ],
        ]);

        /**
         * KYC Type
         */
        $this->add([
            'name' => 'kyc_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'kyc-type',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'KYC Type<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$kyctype,
                'disable_inarray_validator' => true,
                'empty_option' => 'Select KYC',
            ],
        ]);

        /**
         * KYC
         */
        $this->add([
            'name' => 'kyc',
            'type' => Text::class,
            'attributes' => [
                'id' => 'kyc',
                'placeholder' => 'Adhar No./DL No.',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'KYC<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * KYC Upload
         */
        $this->add([
            'name' => 'kyc_upload',
            'type' => File::class,
            'attributes' => [
                'id' => 'kyc-upload',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'KYC Upload<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Pin Code
         */
        $this->add([
            'name' => 'pincode',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pincode',
                'placeholder' => '',
                'class' => 'form-control',
                'maxlength' => 6,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Pin Code<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         * Hidden Field...
         */
        $this->add([
            'name' => 'submit_type',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'submit-type',
                'class' => 'form-control',
                'value' => 'submit'
            ]
        ]);


        /**
         * Hidden Field...
         */
        $this->add([
            'name' => 'user_id',
            'type' => Text::class
        ]);

        /**
         * Submit
         */
        $this->add([
            'name' => 'profile_submit',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'profile-submit',
                'placeholder' => 'Submit',
                'value' => 'Save',
                'class' => 'save_data_btn btn btn-primary btn-new-vehile profile_save btn-warning'
            ],
        ]);

        /**
         * Reset
         */
        $this->add([
            'name' => 'profile_reset',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'profile-reset',
                'placeholder' => 'Submit',
                'class' => 'reset_btn btn btn-success btn-new-vehile'
            ],
        ]);

        /**
         * User Type
         */
        $this->add([
            'name' => 'user_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'user-type',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'User Type<span style="color: red"> *</span>',
                'value_options' => self::$usertype,
                'disable_inarray_validator' => true,
                'empty_option' => 'Select User Type',

            ]
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'first_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter First Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'last_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Last Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'father_name' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Father Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'email' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'EmailAddress',
                        'options' => [
                            'messages' => [
                                EmailAddress::INVALID => 'Please enter Valid Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            /*'mobile' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Mobile No.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'Digits',
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please enter Numeric value only',
                            ],
                        ],
                        'break_chain_on_failure' => true,
                    ],
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 10,
                            'max' => 10,
                            'messages' => [
                                StringLength::TOO_LONG => 'Please enter Less than 10 Digits',
                                StringLength::TOO_SHORT => 'Please enter greater than 9 Digits',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],*/
            'dob' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter DOB'
                            ]
                        ],
                    ],

                ]
            ],
            'gender' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Gender'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'user_type' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select User Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'address' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Address'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'kyc_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select KYC Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'kyc' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter KYC'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'pincode' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Pincode.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'Digits',
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please enter Numeric value only',
                            ],
                        ],
                        'break_chain_on_failure' => true,
                    ],
                ]
            ],

             'phone_verified' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select User Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

             'email_verified' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select User Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
        ];
    }

}
