<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Submit,
    Checkbox,
    Hidden,
    Select,
    Text
};
use Zend\Validator\{
    NotEmpty,
    Digits
};
use \Zend\InputFilter\InputFilterProviderInterface;

class ProfileDutyDetailForm extends Form implements InputFilterProviderInterface {

    public static $dutytype = [];
    public static $paymenttype = [];
    public static $langspeak = [];
    public static $langwrite = [];
    public static $shiftlogin = [];
    public static $weekdays = [];

    public function __construct($name = null) {

        parent::__construct('duty-detail-form');
        $this->setAttribute('method', 'post');

        /**
         * Duty Type
         */
        $this->add([
            'name' => 'duty_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'duty-type',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Duty Type<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '',
                'value_options' => self::$dutytype,
            ],
        ]);

        /**
         * Payment Type
         */
        $this->add([
            'name' => 'payment_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'payment-type',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Payment Type<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '',
                'value_options' => self::$paymenttype,
            ],
        ]);

        /**
         * Week Off
         */
        $this->add([
            'name' => 'week_days',
            'type' => Select::class,
            'attributes' => [
                'id' => 'week-days',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Week Off<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '',
                'value_options' => self::$weekdays,
            ],
        ]);

        /**
         * Hidden Field...
         */
        $this->add([
            'name' => 'submit_type',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'submit-type',
                'value' => 'submit'
            ]
        ]);

        /**
         * Reset
         */
        $this->add([
            'name' => 'duty_payment_reset',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'duty-payment-reset',
                'placeholder' => 'Reset',
                'class' => 'reset_btn btn btn-success btn-new-vehile'
            ],
        ]);

        /**
         * Save
         */
        $this->add([
            'name' => 'duty_payment_submit',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'duty-payment-save',
                'value' => 'Save',
                'placeholder' => 'Save',
                'class' => 'save_data_btn btn btn-primary btn-new-vehile profile_save btn-warning'
            ],
        ]);

        /**
         * Hidden Field...
         */
        $this->add([
            'name' => 'user_id',
            'type' => Text::class
        ]);

        /**
         * Pref City to Drive Cab
         */
        $this->add([
            'name' => 'preferred_city',
            'type' => Select::class,
            'attributes' => [
                'id' => 'preferred-city',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Pref City to Drive Cab<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '',
                'value_options' => array(
                    '1' => 'Gurgoan',
                    '2' => 'Noida',
                    '3' => 'Chandigarh',
                    '4' => 'Delhi'
                ),
            ],
        ]);

        /**
         * Speak Language
         */
        $this->add([
            'name' => 'language_speak',
            'type' => Select::class,
            'attributes' => [
                'id' => 'language-speak',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Speak Language<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '',
                'value_options' => self::$langspeak,
            ],
        ]);

        /**
         * Write Language
         */
        $this->add([
            'name' => 'language_write',
            'type' => Select::class,
            'attributes' => [
                'id' => 'language-write',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Write Language<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '',
                'value_options' => self::$langwrite,
            ],
        ]);

        /**
         * Shift of Login
         */
        $this->add([
            'name' => 'shift_of_login',
            'type' => Select::class,
            'attributes' => [
                'id' => 'shift-of-login',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Shift of Login<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '',
                'value_options' => self::$shiftlogin,
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'duty_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter duty type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'payment_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter payment Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'preferred_city' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter city'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'language_speak' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter speak language'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'language_write' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter write language'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'shift_of_login' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter shift of login'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'week_days' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Week Days'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ]
        ];
    }

}
