<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Date,
    Radio,
    Submit,
	Password,
    Checkbox,
    Email,
    Hidden
};

use Zend\InputFilter\InputFilterProviderInterface;
use Zend\Validator\{
    NotEmpty,
    Digits,
    StringLength,
    EmailAddress
};



class ProfileCompanyDetailForm extends Form implements InputFilterProviderInterface{

    public function __construct($name = null) {

        parent::__construct('profile-company');
        $this->setAttribute('method', 'post');

        /**
         * Company Name
         */
        $this->add([
            'name' => 'company_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'company-name',
                'placeholder' => 'Company Name',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Company Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Office Address
         */
        $this->add([
            'name' => 'company_address',
            'type' => Text::class,
            'attributes' => [
                'id' => 'office-address',
                'placeholder' => '',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Company Address<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         * State
         */
        $this->add([
            'name' => 'state_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'state-name',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'State <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * State Value
         */
        $this->add([
            'name' => 'state_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'state-value'
            ],
        ]);

        /**
         * City
         */
        $this->add([
            'name' => 'city_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'city-name',
                'placeholder' => '',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'City<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * City Value
         */
        $this->add([
            'name' => 'city_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'city-value'
            ],
        ]);

        /**
         * Pincode
         */
        $this->add([
            'name' => 'pincode',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pincode',
                'placeholder' => '',
                'class' => 'form-control',
                'maxlength' => 6,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Pincode<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Service Tax/GST
         */
        $this->add([
            'name' => 'service_tax_gst',
            'type' => Text::class,
            'attributes' => [
                'id' => 'service-tax-gst',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Service Tax/GST<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * PAN Card Detail
         */
        $this->add([
            'name' => 'pancard_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pancard-detail',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'PAN No.<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Contact Person
         */
        $this->add([
            'name' => 'contact_person_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'contact-person',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Contact Person<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Phone Number
         */
        $this->add([
            'name' => 'landline_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'phone-number',
                'placeholder' => '',
                'class' => 'form-control',
                'maxlength'=> 12,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Phone No.<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Mobile Number
         */
        $this->add([
            'name' => 'mobile_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'mobile-no',
                'placeholder' => '',
                'class' => 'form-control',
                'maxlength'=> 10,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Mobile No.<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Email
         */
        $this->add([
            'name' => 'email',
            'type' => Text::class,
            'attributes' => [
                'id' => 'email',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Email<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Website
         */
        $this->add([
            'name' => 'website_url',
            'type' => Text::class,
            'attributes' => [
                'id' => 'website',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Website<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Logo
         */
        $this->add([
            'name' => 'logo',
            'type' => File::class,
            'attributes' => [
                'id' => 'logo',
                'placeholder' => '',
                'class' => 'form-control common-upload-file',
                'data-level-name' => 'company_logo'
            ],
            'options' => [
                'label' => 'Logo<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Upload Your Office Address Proof
         */
        $this->add([
            'name' => 'office_proof',
            'type' => File::class,
            'attributes' => [
                'id' => 'office-proof',
                'class' => 'form-control common-upload-file',
                'data-level-name' => 'office_proof'
            ]

        ]);


 /**
         * Upload Your Company GST Proof
         */
        $this->add([
            'name' => 'gst_proof',
            'type' => File::class,
            'attributes' => [
                'id' => 'gst-proof',
                'class' => 'form-control common-upload-file',
                'data-level-name' => 'gst_proof'
            ]

        ]);

 /**
         * Upload Your Company Pan Card Proof
         */
        $this->add([
            'name' => 'company_pancard_proof',
            'type' => File::class,
            'attributes' => [
                'id' => 'pancard-proof',
                'class' => 'form-control common-upload-file',
                'data-level-name' => 'company_pancard_proof'
            ]

        ]);

        /**
         * Hidden Field...
         */
        $this->add([
            'name' => 'submit_type',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'submit-type',
                'class' => 'form-control',
                'value' => 'submit'
            ]
        ]);

        /**
         * Hidden Field...
         */
        $this->add([
            'name' => 'user_id',
            'type' => Text::class
        ]);

        /**
         * Hidden Field...
         */
        $this->add([
            'name' => 'id',
            'type' => Text::class
        ]);

        /**
         * Company Reset
         */
        $this->add([
            'name' => 'company_reset',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'company-reset',
                'value'=>'Reset',
                'placeholder' => 'Reset',
                'class' => 'reset_btn btn btn-success reset_btn'
            ],

        ]);

        /**
         * Company Save
         */
        $this->add([
            'name' => 'company_save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'company-save',
                'value' => 'Save',
                'placeholder' => 'Save',
                'class' => 'save_data_btn btn btn-primary btn-new-vehile profile_save btn-warning'
            ],

        ]);

    }
public function getInputFilterSpecification() {
   return [
       /**
         * Name
         */
        'company_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Company name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
       'company_address' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Address'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],


            'city_name'=>[
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please Select City'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ],

            'state_name'=>[
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please Select State'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ],

        'service_tax_gst' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter GST no.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
        'pincode' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Pincode'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

       'pancard_no' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter pancard no.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

       /*'logo'=>[
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'File was not uploaded'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ],
                ['name'    => 'FileUploadFile'],
                [
                    'name'    => 'FileMimeType',
                    'options' => [
                        'mimeType'  => ['image/gif', 'image/png', 'image/jpg', 'image/jpeg']
                    ],
                    'break_chain_on_failure' => true
                ],
                ['name'    => 'FileIsImage'],
                [
                        'name'    => 'FileImageSize',
                        'options' => [
                            'minWidth'  => 128,
                            'minHeight' => 128,
                            'maxWidth'  => 4096,
                            'maxHeight' => 4096
                        ]
                ],
            ]
        ],*/
       'contact_person_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter contact person name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],


            'landline_no'=>[
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Mobile No.'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ],
                [   'name' => 'Digits',
                    'options' => [
                        'messages' => [
                            Digits::NOT_DIGITS => 'Please enter Numeric value only',
                        ],
                    ],
                    'break_chain_on_failure' => true,
                ],
                [   'name' => 'StringLength',
                    'options' => [
                        'min' => 10,
                        'max' => 10,
                        'messages' => [
                            StringLength::TOO_LONG => 'Please enter Less than 10 Digits',
                            StringLength::TOO_SHORT => 'Please enter greater than 9 Digits',
                        ],
                    ],
                    'break_chain_on_failure' => true
                ],
            ]
        ],
       'mobile_no'=>[
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Mobile No.'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ],
                [   'name' => 'Digits',
                    'options' => [
                        'messages' => [
                            Digits::NOT_DIGITS => 'Please enter Numeric value only',
                        ],
                    ],
                    'break_chain_on_failure' => true,
                ],
                [   'name' => 'StringLength',
                    'options' => [
                        'min' => 10,
                        'max' => 10,
                        'messages' => [
                            StringLength::TOO_LONG => 'Please enter Less than 10 Digits',
                            StringLength::TOO_SHORT => 'Please enter greater than 9 Digits',
                        ],
                    ],
                    'break_chain_on_failure' => true
                ],
            ]
        ],
     'email' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter email'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
      'website_url' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter website'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

   ];

   }

}
