<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Date,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden
};
use Zend\InputFilter\InputFilterProviderInterface;
use Zend\Validator\{
    NotEmpty,
    Digits,
    StringLength,
    EmailAddress
};
use Zend\Validator\File\Size;

class ProfileBankDetailForm extends Form implements InputFilterProviderInterface{

    public function __construct($name = null) {

        parent::__construct('profile-bank-detail');
        $this->setAttribute('method', 'post');

        /**
         * Bank Name
         */
        $this->add([
            'name' => 'name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'bank-name',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Bank Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Account Name
         */
        $this->add([
            'name' => 'ac_holder_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'account-name',
                'placeholder' => '',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Account Holder Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Account Number
         */
        $this->add([
            'name' => 'ac_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'account-number',
                'placeholder' => '',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Account No.<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * IFSC Code
         */
        $this->add([
            'name' => 'ifsc_code',
            'type' => Text::class,
            'attributes' => [
                'id' => 'ifsc-code',
                'placeholder' => '',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'IFSC Code<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

         /**
         * Branch Name
         */
        $this->add([
            'name' => 'branch',
            'type' => Text::class,
            'attributes' => [
                'id' => 'branch-name',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Branch<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Address
         */
        $this->add([
            'name' => 'address',
            'type' => Text::class,
            'attributes' => [
                'id' => 'address',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Address<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

         /**
         * Hidden Field...
         */
        $this->add([
            'name' => 'user_id',
            'type' => Text::class
        ]);

         /**
         * Hidden Field...
         */
        $this->add([
            'name' => 'bank_id',
            'type' => Text::class
        ]);

        /**
         * Hidden Field...
         */
        $this->add([
            'name' => 'submit_type',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'submit-type',
                'class' => 'form-control',
                'value' => 'submit'
            ]
        ]);

        /**
         * Reset
         */
        $this->add([
            'name' => 'profile_reset',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'profile-reset',
                'class' => 'reset_btn btn btn-success btn-new-vehile'
            ],

        ]);


        $this->add([
            'name' => 'bank_proof',
            'type' => File::class,
            'attributes' => [
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Bank Proof',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         * Save
         */
        $this->add([
            'name' => 'profile_submit',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'profile-submit',
                'value' => 'Save',
                'class' => 'save_data_btn btn btn-primary btn-new-vehile profile_save btn-warning'
            ],

        ]);

    }
public function getInputFilterSpecification() {
   return [
       /**
         * Name
         */
        'name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter bank name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
       'ac_holder_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Account name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],


            'ac_no'=>[
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please Enter Account Number'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ],

            'ifsc_code'=>[
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please Enter Ifsc code'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ],

        'branch' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Branch'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

        'address' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Address'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

   ];

   }

}
