<?php

namespace Dashboard\Form;

use Zend\Form\Form;

use Zend\Form\Element\
{
    File,Text,Radio,Submit,
    Checkbox,Email,Hidden,Select

};
use Zend\Validator\{
    NotEmpty,
    Digits
};
use Zend\InputFilter\InputFilterProviderInterface;

class MarkupAddUserForm extends Form implements InputFilterProviderInterface {

    public static $country = [];
    public static $booking_type =[];
    public static $user_grade_type = [];

    public function __construct($name = null) {

       $countrylist =  self::$country;
       $bookinglist =  self::$booking_type;


       $countrylist = array(0 => 'All') + $countrylist;
       $bookinglist = array(0 => 'All') + $bookinglist;


        parent::__construct('markup-form');
        $this->setAttribute('method', 'post');


        /**
         *
         * Driver ID
         */
        $this->add([
            'name' => 'driver_id',
            'type' => Text::class,
            'attributes' => [
                'id' => 'driver-id',
                'class' => 'form-control',
                'placeholder'=>'123'
            ],
            'options' => [
                'label' => 'Driver ID<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Country
         */
       $this->add([
            'name' => 'country_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'country-id',
                'placeholder' => '',
                'class' => 'form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Country',
                'value_options' => $countrylist,
                'disable_inarray_validator' => true
            ],
        ]);


        /**
         *
         * State
         */
        $this->add([
            'name' => 'state_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'state-id',
                'placeholder' => '',
                'class' => 'form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'State',
                //'value_options' => self::$state,
                'disable_inarray_validator' => true,
                //'empty_option' => '--Select State--',
                'value_options' => [
                    0=>'All'
                ]
            ],
        ]);

         /**
         *
         * country
         */
        $this->add([
            'name' => 'city_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'city-id',
                'placeholder' => '',
                'class' => 'form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'City',
                //'value_options' => self::$city,
                'disable_inarray_validator' => true,
                //'empty_option' => '--Select City--',
                'value_options' => [
                    0=>'All'
                ]
            ],
        ]);

        /**
         * User Type
         */
        $this->add([
            'name' => 'user_grade_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'user-grade-type',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'User Type<span style="color: red"> *</span>',
               'value_options' =>self::$user_grade_type,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select User Grade--',
            ]

        ]);


        /**
         * Driver Name
         */

         $this->add([
            'name' => 'driver_name',
             'type' => Text::class,
            'attributes' => [
                'id' => 'driver-name',
                'placeholder' => 'Driver Name',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Driver Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

         /**
         * Driver Value
         */
        $this->add([
            'name' => 'driver_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'driver-value',
                'class' => 'form-control'
            ],
        ]);

        /**
         * Markup id
         */
        $this->add([
            'name' => 'markup_id',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'markup-id'
            ],
        ]);
        
        /**
         * Markup id
         */
        $this->add([
            'name' => 'master_booking_type_id',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'master-booking-type-id'
            ],
        ]);

         /**
         * Company id
         */
        $this->add([
            'name' => 'company_id',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'company-id'
            ],
        ]);

        /**
         * Booking Type
         */
        $this->add([
            'name' => 'booking_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking-type',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Booking Type<span style="color: red"> *</span>',
                'value_options' => $bookinglist,
                'disable_inarray_validator' => true,
                //'empty_option' => '--Select Booking Type--'
            ]
        ]);

         /**
         *
         * Extra Min
         */
        $this->add([
            'name' => 'extra_min',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-min',
                'class' => 'form-control',
                'maxlength' => 7,
                'onkeypress' => "return isNumberDecimal(event)"

            ],
            'options' => [
                'label' => 'Driver ID<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Extra Km
         */
        $this->add([
            'name' => 'extra_km',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-km',
                'class' => 'form-control',
                'maxlength' => 7,
                'onkeypress' => "return isNumberDecimal(event)"

            ],
            'options' => [
                'label' => 'Driver ID<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Markup Amount
         */
        $this->add([
            'name' => 'markup_amount',
            'type' => Text::class,
            'attributes' => [
                'id' => 'markup-amount',
                'class' => 'form-control',
                'placeholder' =>'100',
                'maxlength' => 6,
                'onkeypress' => "return isNumberDecimal(event)"
            ],
            'options' => [
                'label' => 'Markup Amount<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);

        /**
         * Search
         */
        $this->add([
            'name' => 'search',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Search',
                'id' => 'search',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);

        /**
         * Clear
         */
        $this->add([
            'name' => 'reset',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Reset',
                'id' => 'reset',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);

        /**
         * Clear
         */
        $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Save',
                'id' => 'save-id',
                'class' => 'save_data_btn btn btn-primary btn-new-vehile markup_save'
            ],
        ]);


    }

     public function getInputFilterSpecification() {
        return [
            'driver_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select driver id'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'country_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Country '
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

            'name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'city_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter city id'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

            'markup_amount' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [

                             'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter markup ammount'
                            ]
                        ],
                         'break_chain_on_failure' => true
                    ]


                ]
            ]

        ];
    }


}
