<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;

use Zend\Form\Element;
use Zend\Form\Element\Select;
use Zend\Form\Element\File;
use Zend\Form\Element\Text;
use Zend\Form\Element\Radio;
use Zend\Form\Element\Submit;
use Zend\Form\Element\Checkbox;
use Zend\Form\Element\Email;

class MapDriverSearchForm extends Form {

    public function __construct($name = null) {

        parent::__construct('map-driver-search-form');
        $this->setAttribute('method', 'post');
        
        /**
         * 
         * State
         */
        $this->add([
            'name' => 'state_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'state-id',                
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'State<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);  
        
        /**
         * Driver Name
         */
        $this->add([
            'name' => 'driver_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'driver-name',
                'placeholder' => 'Driver Name',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Driver Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);  
        
        /**
         * 
         * Status
         */
        $this->add([
            'name' => 'status',
            'type' => Radio::class,
            'attributes' => [
                'id' => 'status',                
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Status<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);   
        
        /**
         * City
         */
        $this->add([
            'name' => 'city_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'city-id',                
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'City<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);  
        
        /**
         * Vehicle Number
         */
        $this->add([
            'name' => 'vehicle_number',
            'type' => Text::class,
            'attributes' => [
                'id' => 'vehicle-number',
                'placeholder' => 'DL-524',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Vehicle Number<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);  
        
        /**
         * Search
         */
        $this->add([
            'name' => 'search',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Map Driver',
                'id' => 'search',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);   
        
        /**
         * Clear
         */
        $this->add([
            'name' => 'clear',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Clear',
                'id' => 'clear',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]); 
    }

}
