<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;
use Zend\Form\Element\Select;
use Zend\Form\Element\File;
use Zend\Form\Element\Text;
use Zend\Form\Element\Radio;
use Zend\Form\Element\Submit;
use Zend\Form\Element\Checkbox;
use Zend\Form\Element\Email;
use Zend\Form\Element\Hidden;

class FareAddpriceDistanceForm extends Form {

    public function __construct($name = null) {

        parent::__construct('distance-fare');

        $this->setAttribute('method', 'post');
        
        /**
         * Public Fare Selected
         */
        $this->add([
            'name' => 'distance_fare_id',
            'type' => Hidden::class,
          ]);         
        /**
        
        
        /**
         * 
         * Rate Per Km
         */
        $this->add([
            'name' => 'rate_per_km',
            'type' => Text::class,
            'attributes' => [
                'id' => 'rate-per-km-id',  
                'placeholder' => '10',
                'class' => 'form-control',
                'maxlength'=>5,
                'onkeypress'=>"return isNumber(event)"
                
            ],
            'options' => [
                'label' => 'Rate Per Km',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * 
         * Ignore First Km Rate
         */
        $this->add([
            'name' => 'ignore_first_km_rate',
            'type' => Text::class,
            'attributes' => [
                'id' => 'ignore_first_km_rate-id',  
                'placeholder' => '1',
                'class' => 'form-control',
                'maxlength'=>5,
                'onkeypress'=>"return isNumber(event)"
                
            ],
            'options' => [
                'label' => 'Ignore First Km Rate',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        
        /**
         * 
         * Minimum Fare
         */
          $this->add([
            'name' => 'minimum_fare',
            'type' => Text::class,
            'attributes' => [
                'id' => 'minimum-fare-id',  
                'placeholder' => '10',
                'class' => 'form-control',
                'maxlength'=>5,
                'onkeypress'=>"return isNumber(event)"
                
            ],
            'options' => [
                'label' => 'Minimum Fare',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
           
          
          /**
         * 
         * Round up kms
         */
            $this->add([
            'name' => 'round_per_kms',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'round-per-km-id',    
                'placeholder' => '',
                'class' => 'checkmark',
               
            ],
            'options' => [
                'label' => 'Round Up Kms',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 

            
             /**
         * 
         * accumulated instances
         */
            $this->add([
            'name' => 'accumulated_instances',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'accumulated-instances-id',    
                'placeholder' => '',
                'class' => 'checkmark',
               
            ],
            'options' => [
                'label' => 'Accumulated Instances',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
            
            
             /**
         * 
         * Kms Up To
         */
            $this->add([
            'name' => 'package_km_upto_to[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'km-upto-id_',  
                'placeholder' => '5',
                'class' => 'form-control',
                'maxlength'=>5,
                'onkeypress'=>"return isNumber(event)"
                
            ],
            'options' => [
                'label' => 'Kms Up To',
                'label_options' => ['disable_html_escape' => true]                
            ],
        ]);
         
             /**
         * 
         * Rate Per Km
         */
             $this->add([
            'name' => 'package_rate_per_km[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-rate-per-km-id',  
                'placeholder' => '120',
                'class' => 'form-control',
                'maxlength'=>5,
                'onkeypress'=>"return isNumber(event)"
                
            ],
            'options' => [
                'label' => 'Rate Per Km',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
             
                    /**
         * 
         * Add
         */
               $this->add([
            'name' => 'package_km_upto_rate_per_km',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'package-km-upto-rate-per-km-id',    
                'placeholder' => 'add',
                'class' => 'btn btn-info form-control',
            ],
            
        ]);
       
               /**
         * 
         * update all rows
         */
              
            $this->add([
            'name' => 'update_all_rows',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'update-all-rows-id',    
                'placeholder' => '',
                'class' => 'checkmark',
               
            ],
            'options' => [
                'label' => 'Update All Rows',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
            
             /**
         * 
         * Package Name
         */
             $this->add([
            'name' => 'distance_package_name[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-name-id',  
                'placeholder' => '40Km',
                'class' => 'form-control allowtext',
                
            ],
            'options' => [
                'label' => 'Package Name',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
             
         /**
         * 
         * Ignore KM
         */
              $this->add([
            'name' => 'distance_ignore_km[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'ignore-km-id',  
                'placeholder' => '1',
                'class' => 'form-control',
                
            ],
            'options' => [
                'label' => 'Ignore KM',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
              
              /**
         * 
         * Amount
         */
              $this->add([
            'name' => 'distance_amount[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pkg_amountDistance_1',  
                'placeholder' => '250',
                'class' => 'form-control',
                
            ],
            'options' => [
                'label' => 'Amount',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
              
              
               /**
         * 
         * Add
         */
               $this->add([
            'name' => 'submit_distance',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'distance-fare-btn',                 
                'class' => 'btn btn-info form-control ',
                'value'=>'Save',
                'onclick'=>"submitForm('#distance-fare', event);"
            ],
            
        ]);
               
                /**
         * 
         * save
         */
               $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'save-id',    
                'placeholder' => 'Save',
                'class' => 'btn btn-info form-control',
            ],
            
        ]);
               
                /**
         * 
         * next
         */
                $this->add([
            'name' => 'next',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'next-id',    
                'placeholder' => 'Next',
                'class' => 'btn btn-info form-control margin-bottom10px',
                 'value'=>'Next'
            ],
            
        ]);
    }

}
