<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden,
    Date,
    Time
};
use Zend\Validator\{
    NotEmpty,
    Digits
};
use Zend\InputFilter\InputFilterProviderInterface;

class FareAddPricePremiumForm extends Form implements InputFilterProviderInterface {

      public static $masterextra = [];

    public function __construct($name = null) {
        parent::__construct('premium-fare');
        $this->setAttribute('method', 'post');

        /**
         *
         *
          Night Premium
         */
        $this->add([
            'name' => 'night_rate_value',
            'type' => Text::class,
            'attributes' => [
                'id' => 'night-rate-value',
                'placeholder' => '100',
                'class' => 'form-control margin-top0',
                'maxlength' => 5,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Night',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         *
          Night Rate begins
         */
        $this->add([
            'name' => 'night_rate_begins',
            'type' => Text::class,
            'attributes' => [
                'id' => 'night-rate-begin',
                'class' => 'form-control timepicker',
            ],

            'options' => [
                'label' => 'Night rate Begins',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         *
         *
          Night Rate Ends
         */
        $this->add([
            'name' => 'night_rate_ends',
            'type' => Text::class,
            'attributes' => [
                'id' => 'night-rate-ends',
                'class' => 'form-control timepicker'
            ],
            'options' => [
                'label' => 'Night Rate Ends',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         *
         *
          Night Premium
         */
        $this->add([
            'name' => 'premiums_value',
            'type' => Text::class,
            'attributes' => [
                'id' => 'premiums-value',
                'placeholder' => '100',
                'class' => 'form-control margin-top0',
                'maxlength' => 5,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Night',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         *
         *
          time from
         */
        $this->add([
            'name' => 'start_time[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'start-time',
                'placeholder' => '11:00:00',
                'class' => 'form-control timepicker',
            ],
            'options' => [
                'label' => 'Time From',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         *
          Time To
         */
        $this->add([
            'name' => 'end_time[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'end-time',
                'placeholder' => '11:00:00',
                'class' => 'form-control timepicker',
            ],
            'options' => [
                'label' => 'Time To',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        $this->add([
            'name' => 'peaktime_value[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'end-time',
                'placeholder' => '20',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Percentage',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         *
          Percentage
         */
        $this->add([
            'name' => 'peak_time_charges_percentage',
            'type' => Text::class,
            'attributes' => [
                'id' => 'time-from-id',
                'placeholder' => '500Rs',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Time From',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         *
         *
          add
         */
        $this->add([
            'name' => 'peak_time_charges_add',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'peak-time-charges-add-id',
                'placeholder' => 'Add',
                'class' => 'input-group addpeaktime_on_plus no-padding ',
            ],
        ]);


        /**
         *
         *
          Extras
         */
        $this->add([
            'name' => 'extras_no_name1[]',
            'type' => Text::class,
            'attributes' => [
                'placeholder' => '',
                'class' => 'form-control allowtext',
                'maxlength'=>10
            ],
            'options' => [
                'label' => '',
                 //'value_options' => self::$masterextra,
                'label_options' => ['disable_html_escape' => true],
                //'disable_inarray_validator' => true,
                //'empty_option' => '--Select Extra--',
            ],
        ]);

        /**
         *
         *
          Extras
         */
        $this->add([
            'name' => 'extras_no_name2[]',
            'type' => Text::class,
            'attributes' => [
                'placeholder' => '',
                'class' => 'form-control',
                'maxlength'=>10
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         *
          Extras
         */
        $this->add([
            'name' => 'extras_rs_1',
            'type' => radio::class,
            'attributes' => [
                'id' => 'extras-rs-1-id',
                'placeholder' => '',
            ],
            'options' => [
                'label' => 'Rs',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);



        /**
         *
         *
          Extras
         */
        $this->add([
            'name' => 'extras_rs_2',
            'type' => radio::class,
            'attributes' => [
                'id' => 'extrs-rs-2-id',
                'placeholder' => '',
            ],
            'options' => [
                'label' => 'Rs',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);



        /**
         *
         *
          add
         */
        $this->add([
            'name' => 'extras',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'extras-id',
                'placeholder' => 'Add',
                'class' => 'btn btn-info ',
            ],
        ]);



        /**
         *
         *
          save
         */
        $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'premium-fare-btn',
                'placeholder' => 'Save',
                'class' => 'btn btn-info form-control margin-bttom10px widthpersent100',
                'Value' => 'Save',
                'onclick' => "submitForm('#premium-fare', event);"
            ],
        ]);


        /**
         *
         *
          Next
         */
        $this->add([
            'name' => 'next',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'next-id',
                'placeholder' => 'Next',
                'class' => 'btn btn-info form-control margin-bottom10px widthpersent100',
            ],
        ]);

        $this->add([
            'name' => 'night_premium_id',
            'type' => Hidden::class,
        ]);

        $this->add([
            'name' => 'premiums_id',
            'type' => Hidden::class,
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'night_rate_value' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Value'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'night_rate_begins' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Night Rate Begins'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'night_rate_ends' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Night Rate Ends'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'premiums_value' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Premiums Value'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
             'extras_rs_1' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Premiums Value'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
             'extras_rs_2' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Premiums Value'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

            'extras_no_name1[]' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Premiums Value'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

            'extras_no_name2[]' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Premiums Value'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
        ];
    }

}
