<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;
use Zend\Form\Element\Select;
use Zend\Form\Element\File;
use Zend\Form\Element\Text;
use Zend\Form\Element\Radio;
use Zend\Form\Element\Submit;
use Zend\Form\Element\Checkbox;
use Zend\Form\Element\Email;
use Zend\Form\Element\Hidden;


class FareAddPriceHourForm extends Form {

    public function __construct($name = null) {

        parent::__construct('hour-fare');

        $this->setAttribute('method', 'post');

         /**
         * Public Fare Selected
         */
        $this->add([
            'name' => 'hour_fare_id',
            'type' => Hidden::class,
          ]);         
        /**
        
        /**
         *
         * Rate Per hour
         */
        $this->add([
            'name' => 'rate_per_hour',
            'type' => Text::class,
            'attributes' => [
                'id' => 'rate-per-hour-id',
                'placeholder' => '200',
                'class' => 'form-control',
                'maxlength'=>5,
                'onkeypress'=>"return isNumber(event)"

            ],
            'options' => [
                'label' => 'Rate Per Hour',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Ignore First Hours
         */
        $this->add([
            'name' => 'ignore_first_hours',
            'type' => Text::class,
            'attributes' => [
                'id' => 'ignore_first_hours-id',
                'placeholder' => '1',
                'class' => 'form-control',
                 'maxlength'=>5,
                'onkeypress'=>"return isNumber(event)"

            ],
            'options' => [
                'label' => 'Ignore First Hours',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

         /**
         *
         * Minimum Fare
         */
          $this->add([
            'name' => 'minimum_fare',
            'type' => Text::class,
            'attributes' => [
                'id' => 'minimum-fare-id',
                'placeholder' => '0',
                'class' => 'form-control',
                 'maxlength'=>5,
                'onkeypress'=>"return isNumber(event)"

            ],
            'options' => [
                'label' => 'Minimum Fare',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

          /**
         *
         * update all rows
         */

            $this->add([
            'name' => 'update_all_rows',
                'type' => Checkbox::class,
            'attributes' => [
                'id' => 'update-all-rows-id',
                'placeholder' => '',
                'class' => 'checkmark',

            ],
            'options' => [
                'label' => 'Update All Rows',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


            /**
         *
         * Package Name
         */
            $this->add([
            'name' => 'hour_package_name[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-name-id',
                'placeholder' => '4Hrs',
                'class' => 'form-control allowtext',

            ],
            'options' => [
                'label' => 'Package Name',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


             /**
         *
         * Ignore Hours
         */
            $this->add([
            'name' => 'hour_ignore_hours[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'ignore-hours-id',
                'placeholder' => '4',
                'class' => 'form-control',

            ],
            'options' => [
                'label' => 'Ignore Hours',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

              /**
         *
         * Amount
         */
            $this->add([
            'name' => 'hour_amount[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pkg_amountHourly_1',
                'placeholder' => '400',
                'class' => 'form-control',
                'maxlength'=>6,
                'onkeypress'=>"return isNumber(event)"

            ],
            'options' => [
                'label' => 'Amount',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


            /**
         *
         * Add
         */
              $this->add([
            'name' => 'package_name_ignore_hours_amount_add',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'package-name-ignore-hours-amount-add-id',
                'placeholder' => 'Add',
                'class' => 'col-sm-4 addPKG_loc_hourly no-padding',
            ],

        ]);

              /**
         *
         * save
         */
               $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'hour-fare-btn',
                'class' => 'btn btn-info form-control margin-bottom10px',
                'value'=>'Save',
                'value'=>'Save',
                'onclick'=>"submitForm('#hour-fare', event);"
            ],

        ]);

               /**
         *
         * next
         */
                $this->add([
            'name' => 'next',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'next-id',
                'class' => 'btn btn-info form-control margin-bottom15',
                'value'=>'Next'
            ],

        ]);

    }

}
