<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;

use Zend\Form\Element\Select;
use Zend\Form\Element\File;
use Zend\Form\Element\Text;
use Zend\Form\Element\Radio;
use Zend\Form\Element\Submit;
use Zend\Form\Element\Checkbox;
use Zend\Form\Element\Email;
use Zend\Form\Element\Textarea;
use Zend\Form\Element\Hidden;

class FareAddPriceFixedRoutesForm extends Form {

    public function __construct($name = null) {

        parent::__construct('fixed-route');

        $this->setAttribute('method', 'post');
        
        
         $this->add([
            'name' => 'fix_route_id',
            'type' => Hidden::class,
        ]);   
        
        /**
         * 
         * Frequent Location
         */
        $this->add([
            'name' => 'frequent_location',
            'type' => Text::class,
            'attributes' => [
                'id' => 'frequent-location-id',  
                'placeholder' => '',
                'class' => 'form-control allowtext',
                'maxlength' =>10,
                'onkeypress'=>'return isNumber(event)'
                
            ],
            'options' => [
                'label' => 'Frequent Location',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * 
         * pickup postcode
         */
        $this->add([
            'name' => 'pickup_postcode[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pickup-postcode-id',  
                'placeholder' => '',
                'class' => 'form-control',
                'maxlength'=>'8',
                'onkeypress'=>'return isNumber(event)'
                
            ],
            'options' => [
                'label' => 'Pickup Postcode',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * 
         * Drop Off postcode
         */
        $this->add([
            'name' => 'drop_off_postcode[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'drop-off-postcode-id',  
                'placeholder' => '',
                'class' => 'form-control',
                'maxlength'=>'8',
                'onkeypress'=>'return isNumber(event)'
                
            ],
            'options' => [
                'label' => 'Drop Off Postcode',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * 
         * value
         */
          $this->add([
            'name' => 'value[]',
            'type' =>Text::class,
            'attributes' => [
                'id' => 'value-id',  
                'placeholder' => '',
                'class' => 'form-control',
                'maxlength'=>'5',
                'onkeypress'=>'return isNumber(event)'
                
            ],
            'options' => [
                'label' => 'Value',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
           
          
         /**
         * 
         * checkbox with no name
         */
            $this->add([
            'name' => 'no_label',
            'attributes' => [
                'id' => 'no-label-id',    
                'placeholder' => '',
                'class' => 'checkmark',
               
            ],
            'options' => [
                'label' => '',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 

            /**
         * 
         * add
         */
              $this->add([
            'name' => 'fixed_routes_add',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'fixed-routes-id',    
                'placeholder' => 'Add',
                'class' => 'btn btn-info addPostCodes  ',
            ],
            
        ]);
              
              
              /**
         * 
         * update all rows
         */
              $this->add([
            'name' => 'update_all_rows',
                  'type' => Checkbox::class,
            'attributes' => [
                'id' => 'update-all-rows-id',    
                'placeholder' => '',
                'class' => 'checkmark',
               
            ],
            'options' => [
                'label' => 'Update All Rows',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
              
              /**
         * 
         * save
         */
              $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'fixed-route-btn',    
                'placeholder' => 'Save',
                'class' => 'btn btn-info form-control ',
                 'value'=>'Save',
                'onclick'=>"submitForm('#fixed-route', event)"             
            ],
            
        ]);
              
              /**
         * 
         * Next
         */
               $this->add([
            'name' => 'next',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'next-id',    
                'placeholder' => 'Next',
                'class' => 'btn btn-info form-control margin-bottom10px widthpersent100',
            ],
            
        ]);
             
    }

}
