<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Radio,
    Submit,
    Checkbox,
    Email,
    Textarea,
    Date,
    Hidden
};
use Zend\Validator\{
    NotEmpty,
    EmailAddress
};
use Zend\InputFilter\InputFilterProviderInterface;

class ContactUsForm extends Form implements InputFilterProviderInterface {

    public function __construct($name = null) {
        parent::__construct('contact-us');
        $this->setAttribute('method', 'post');

        /**
         *
         * Address
         */
        $this->add([
            'name' => 'office_address',
            'type' => Text::class,
            'attributes' => [
                'id' => 'office-address',
                'placeholder' => 'Road # 33 House # 06 1st Floor, Dhaka 1212, Bangladesh',
                'class' => 'form-control',

            ],
            'options' => [
                'label' => 'Office Address : <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Telephone
         */
        $this->add([
            'name' => 'phone',
            'type' => Text::class,
            'attributes' => [
                'id' => 'phone',
                'placeholder' => '+88029857484',
                'class' => 'form-control',

            ],
            'options' => [
                'label' => 'Telephone : <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Fax Number
         */
        $this->add([
            'name' => 'fax_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'fax-no',
                'placeholder' => '+88029857484',
                'class' => 'form-control',

            ],
            'options' => [
                'label' => 'Fax Number : <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

          /**
         *
         * Hotline
         */
         $this->add([
            'name' => 'email',
            'type' => Text::class,
            'attributes' => [
                'id' => 'email',
                'placeholder' => 'info@eicra.com',
                'class' => 'form-control',

            ],
            'options' => [
                'label' => 'Hotline : <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

         /**
         *
         * Support Email
         */
        $this->add([
            'name' => 'global_email',
            'type' => Text::class,
            'attributes' => [
                'id' => 'global-email',
                'placeholder' => 'info@eicra.com',
                'class' => 'form-control margin-top0',

            ],
            'options' => [
                'label' => 'Support Email : <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Working Hour
         */
        $this->add([
            'name' => 'working_hour',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'working-hour',
                'placeholder' => '6AM - 8PM',
                'class' => 'form-control',

            ],
            'options' => [
                'label' => 'Working Hour : <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * button System Backup
         */
         $this->add([
            'name' => 'system_backup',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'system-backup-id',
                'placeholder' => 'System Backup',
                'class' => 'btn btn-info',
            ],

        ]);

         /**
         *
         * button Restore
         */
          $this->add([
            'name' => 'restore',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'restore-id',
                'placeholder' => 'Restore',
                'class' => 'btn btn-danger',
            ],

        ]);


         /**
         *
         * button reset
         */
          $this->add([
            'name' => 'reset',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'reset-id',
                'placeholder' => 'reset',
                'class' => 'btn btn-success',
            ],

        ]);

          /**
         *
         * save
         */
        $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'contact-us-save-btn',
                'placeholder' => 'Save',
                'class' => 'save_data_btn btn btn-primary btn-warning pull-right margin-L-1',
                'Value' => 'Save',
                'onclick' => "submitForm('#contact-us', event);"
            ],
        ]);

    }

        public function getInputFilterSpecification() {
        return [
            'office_address' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Office Address'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'phone' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Telephone No.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'fax_no' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Fax No.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'email' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'EmailAddress',
                        'options' => [
                            'messages' => [
                                EmailAddress::INVALID => 'Please enter Valid Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'global_email' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Support Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'EmailAddress',
                        'options' => [
                            'messages' => [
                                EmailAddress::INVALID => 'Please enter Valid Support Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'working_hour' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Working Hour.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
        ];
    }

}
