<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\Select;
use Zend\Form\Element\File;
use Zend\Form\Element\Text;
use Zend\Form\Element\Radio;
use Zend\Form\Element\Submit;
use Zend\Form\Element\Checkbox;
use Zend\Form\Element\Email;
use Zend\Form\Element\Date;

class CancellationDeadlineForm extends Form {
    public static $bookingType = [];
    public static $bookingstatus = [];

    public function __construct($name = null) {

        parent::__construct('cancellation-deadline-form');
        $this->setAttribute('method', 'post');

        /**
         *
         * Booking Type
         */
        $this->add([
            'name' => 'booking_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking-type',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Booking Type',
                'value_options' => self::$bookingType,
                'empty_option' => 'Select Booking Type',
            ],
        ]);
        
        
         /**
         *
         * Booking Type
         */
        $this->add([
            'name' => 'booking_status',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking-type',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Booking Type',
                'value_options' => self::$bookingstatus,
                'empty_option' => 'Select Booking Type',
            ],
        ]);
        
         $this->add([
            'name' => 'booking_id',
            'type' => Text::class,
            'attributes' => [
                'id' => 'booking-id',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Booking Reference'
                
            ],
        ]);

        /**
         * From Date
         */
        $this->add([
            'name' => 'from_date',
            'type' => text::class,
            'attributes' => [
                'id' => 'pickup-date',
                'class' => 'form-control datepicker'
            ],
            'options' => [
                'label' => 'Pickup Date'
            ],
        ]);

        /**
         * To Date
         */
        $this->add([
            'name' => 'to_date',
            'type' => text::class,
            'attributes' => [
                'id' => 'end-date',
                'class' => 'form-control datepicker'
            ],
            'options' => [
                'label' => 'To'
            ],
        ]);


        /**
         * Search
         */
        $this->add([
            'name' => 'search',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Search',
                'id' => 'search',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);

        /**
         * Clear
         */
        $this->add([
            'name' => 'clear',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Clear',
                'id' => 'clear',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);
    }

}
