<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;
use Zend\Form\Element\Select;
use Zend\Form\Element\Submit;

class BookingStatusSearchForm extends Form {
    public static $bookingstatus=[];
    public static $ordertime=[];

    public function __construct($name = null) {

        parent::__construct('booking-status-search-form');
        $this->setAttribute('method', 'post');

        /**
         * Status Tab start
         * Booking Status
         */
        $this->add([
            'name' => 'booking_status',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking-status',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Booking Status<span style="color: red"> *</span>',
                'value_options' => self::$bookingstatus,
                'empty_option' => 'Select',
            ],
        ]);

        /**
         * Status Tab end
         * Order Time
         */
        $this->add([
            'name' => 'order_time',
            'type' => Select::class,
            'attributes' => [
                'id' => 'order-time',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Order Time<span style="color: red"> *</span>',
                'value_options' => self::$ordertime,
            ],
        ]);

        /**
         * Search
         */
        $this->add([
            'name' => 'search',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Search',
                'id' => 'search',
                'class' => 'btn btn-primary btn-lg booking-his'
            ],
        ]);

        /**
         * Clear
         */
        $this->add([
            'name' => 'clear',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Clear',
                'id' => 'clear',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);
    }

}
